/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.connect.build.DockerOutput;
import io.strimzi.api.kafka.model.connect.build.ImageStreamOutput;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.HashMap;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DockerOutput.class, name="docker"), @JsonSubTypes.Type(value=ImageStreamOutput.class, name="imagestream")})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class Output
implements UnknownPropertyPreserving {
    public static final String TYPE_DOCKER = "docker";
    public static final String TYPE_IMAGESTREAM = "imagestream";
    private String image;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="Output type. Must be either `docker` for pushing the newly build image to Docker compatible registry or `imagestream` for pushing the image to OpenShift ImageStream. Required.")
    public abstract String getType();

    @Description(value="The name of the image which will be built. Required")
    @JsonProperty(required=true)
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Output)) {
            return false;
        }
        Output other = (Output)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Output;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "Output(image=" + this.getImage() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }
}

