/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connector;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import java.util.HashMap;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"enabled", "maxRestarts"})
public class AutoRestart
implements UnknownPropertyPreserving {
    private boolean enabled = true;
    private Integer maxRestarts;
    private final Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="Whether automatic restart for failed connectors and tasks should be enabled or disabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Description(value="The maximum number of connector restarts that the operator will try. If the connector remains in a failed state after reaching this limit, it must be restarted manually by the user. Defaults to an unlimited number of restarts.")
    public Integer getMaxRestarts() {
        return this.maxRestarts;
    }

    public void setMaxRestarts(Integer maxRestarts) {
        this.maxRestarts = maxRestarts;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoRestart)) {
            return false;
        }
        AutoRestart other = (AutoRestart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Integer this$maxRestarts = this.getMaxRestarts();
        Integer other$maxRestarts = other.getMaxRestarts();
        if (this$maxRestarts == null ? other$maxRestarts != null : !((Object)this$maxRestarts).equals(other$maxRestarts)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoRestart;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Integer $maxRestarts = this.getMaxRestarts();
        result = result * 59 + ($maxRestarts == null ? 43 : ((Object)$maxRestarts).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "AutoRestart(enabled=" + this.isEnabled() + ", maxRestarts=" + this.getMaxRestarts() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }
}

