/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.kafka.Kafka;
import io.strimzi.api.kafka.model.kafka.KafkaFluent;

public class KafkaBuilder
extends KafkaFluent<KafkaBuilder>
implements VisitableBuilder<Kafka, KafkaBuilder> {
    KafkaFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBuilder() {
        this(false);
    }

    public KafkaBuilder(Boolean validationEnabled) {
        this(new Kafka(), validationEnabled);
    }

    public KafkaBuilder(KafkaFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public KafkaBuilder(KafkaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Kafka(), validationEnabled);
    }

    public KafkaBuilder(KafkaFluent<?> fluent, Kafka instance) {
        this(fluent, instance, false);
    }

    public KafkaBuilder(KafkaFluent<?> fluent, Kafka instance, Boolean validationEnabled) {
        this.fluent = fluent;
        Kafka kafka = instance = instance != null ? instance : new Kafka();
        if (instance != null) {
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
        }
        this.validationEnabled = validationEnabled;
    }

    public KafkaBuilder(Kafka instance) {
        this(instance, (Boolean)false);
    }

    public KafkaBuilder(Kafka instance, Boolean validationEnabled) {
        this.fluent = this;
        Kafka kafka = instance = instance != null ? instance : new Kafka();
        if (instance != null) {
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
        this.validationEnabled = validationEnabled;
    }

    public Kafka build() {
        Kafka buildable = new Kafka(this.fluent.buildSpec(), this.fluent.buildStatus());
        buildable.setApiVersion(this.fluent.getApiVersion());
        buildable.setKind(this.fluent.getKind());
        buildable.setMetadata(this.fluent.buildMetadata());
        return buildable;
    }
}

