/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.strimzi.api.kafka.model.common.Condition;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class Status
implements UnknownPropertyPreserving {
    private List<Condition> conditions;
    private long observedGeneration;
    private Map<String, Object> additionalProperties;

    @Description(value="List of status conditions")
    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    private List<Condition> prepareConditionsUpdate() {
        List<Condition> oldConditions = this.getConditions();
        ArrayList<Condition> newConditions = oldConditions != null ? new ArrayList<Condition>(oldConditions) : new ArrayList(0);
        return newConditions;
    }

    public void addCondition(Condition condition) {
        List<Condition> newConditions = this.prepareConditionsUpdate();
        newConditions.add(condition);
        this.setConditions(Collections.unmodifiableList(newConditions));
    }

    public void addConditions(Collection<Condition> conditions) {
        List<Condition> newConditions = this.prepareConditionsUpdate();
        newConditions.addAll(conditions);
        this.setConditions(Collections.unmodifiableList(newConditions));
    }

    @Description(value="The generation of the CRD that was last reconciled by the operator.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Collections.emptyMap();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(1);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Status)) {
            return false;
        }
        Status other = (Status)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getObservedGeneration() != other.getObservedGeneration()) {
            return false;
        }
        List<Condition> this$conditions = this.getConditions();
        List<Condition> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Status;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $observedGeneration = this.getObservedGeneration();
        result = result * 59 + (int)($observedGeneration >>> 32 ^ $observedGeneration);
        List<Condition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "Status(conditions=" + this.getConditions() + ", observedGeneration=" + this.getObservedGeneration() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }
}

