/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.entityoperator;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.common.ProbeBuilder;
import io.strimzi.api.kafka.model.common.ProbeFluent;
import io.strimzi.api.kafka.model.common.SidecarFluent;
import io.strimzi.api.kafka.model.kafka.entityoperator.TlsSidecar;
import io.strimzi.api.kafka.model.kafka.entityoperator.TlsSidecarLogLevel;
import java.util.Objects;
import java.util.Optional;

public class TlsSidecarFluent<A extends TlsSidecarFluent<A>>
extends SidecarFluent<A> {
    private TlsSidecarLogLevel logLevel;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;

    public TlsSidecarFluent() {
    }

    public TlsSidecarFluent(TlsSidecar instance) {
        TlsSidecar tlsSidecar = instance = instance != null ? instance : new TlsSidecar();
        if (instance != null) {
            this.withLogLevel(instance.getLogLevel());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withImage(instance.getImage());
            this.withResources(instance.getResources());
        }
    }

    public TlsSidecarLogLevel getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(TlsSidecarLogLevel logLevel) {
        this.logLevel = logLevel;
        return (A)((Object)this);
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TlsSidecarFluent that = (TlsSidecarFluent)((Object)o);
        if (!Objects.equals((Object)this.logLevel, (Object)that.logLevel)) {
            return false;
        }
        if (!Objects.equals((Object)this.livenessProbe, (Object)that.livenessProbe)) {
            return false;
        }
        return Objects.equals((Object)this.readinessProbe, (Object)that.readinessProbe);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.logLevel, this.livenessProbe, this.readinessProbe, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append(this.livenessProbe + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append((Object)this.readinessProbe);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)TlsSidecarFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)TlsSidecarFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }
}

