/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.listener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DescriptionFile
@JsonPropertyOrder(value={"alternativeNames", "host", "dnsAnnotations", "nodePort", "loadBalancerIP", "annotations", "labels", "externalIPs"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GenericKafkaListenerConfigurationBootstrap
implements UnknownPropertyPreserving {
    private List<String> alternativeNames;
    private String host;
    private Map<String, String> annotations = new HashMap<String, String>(0);
    private Map<String, String> labels = new HashMap<String, String>(0);
    private Integer nodePort;
    private String loadBalancerIP;
    private List<String> externalIPs;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="Additional alternative names for the bootstrap service. The alternative names will be added to the list of subject alternative names of the TLS certificates.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getAlternativeNames() {
        return this.alternativeNames;
    }

    public void setAlternativeNames(List<String> alternativeNames) {
        this.alternativeNames = alternativeNames;
    }

    @Description(value="The bootstrap host. This field will be used in the Ingress resource or in the Route resource to specify the desired hostname. This field can be used only with `route` (optional) or `ingress` (required) type listeners.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Description(value="Annotations that will be added to the `Ingress`, `Route`, or `Service` resource. You can use this field to configure DNS providers such as External DNS. This field can be used only with `loadbalancer`, `nodeport`, `route`, or `ingress` type listeners.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    @Description(value="Labels that will be added to the `Ingress`, `Route`, or `Service` resource. This field can be used only with `loadbalancer`, `nodeport`, `route`, or `ingress` type listeners.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    @Description(value="Node port for the bootstrap service. This field can be used only with `nodeport` type listener.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getNodePort() {
        return this.nodePort;
    }

    public void setNodePort(Integer nodePort) {
        this.nodePort = nodePort;
    }

    @Description(value="The loadbalancer is requested with the IP address specified in this field. This feature depends on whether the underlying cloud provider supports specifying the `loadBalancerIP` when a load balancer is created. This field is ignored if the cloud provider does not support the feature.This field can be used only with `loadbalancer` type listener.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    public void setLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
    }

    @Description(value="External IPs associated to the nodeport service. These IPs are used by clients external to the Kubernetes cluster to access the Kafka brokers. This field is helpful when `nodeport` without `externalIP` is not sufficient. For example on bare-metal Kubernetes clusters that do not support Loadbalancer service types. This field can only be used with `nodeport` type listener.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getExternalIPs() {
        return this.externalIPs;
    }

    public void setExternalIPs(List<String> externalIPs) {
        this.externalIPs = externalIPs;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericKafkaListenerConfigurationBootstrap)) {
            return false;
        }
        GenericKafkaListenerConfigurationBootstrap other = (GenericKafkaListenerConfigurationBootstrap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$nodePort = this.getNodePort();
        Integer other$nodePort = other.getNodePort();
        if (this$nodePort == null ? other$nodePort != null : !((Object)this$nodePort).equals(other$nodePort)) {
            return false;
        }
        List<String> this$alternativeNames = this.getAlternativeNames();
        List<String> other$alternativeNames = other.getAlternativeNames();
        if (this$alternativeNames == null ? other$alternativeNames != null : !((Object)this$alternativeNames).equals(other$alternativeNames)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        String this$loadBalancerIP = this.getLoadBalancerIP();
        String other$loadBalancerIP = other.getLoadBalancerIP();
        if (this$loadBalancerIP == null ? other$loadBalancerIP != null : !this$loadBalancerIP.equals(other$loadBalancerIP)) {
            return false;
        }
        List<String> this$externalIPs = this.getExternalIPs();
        List<String> other$externalIPs = other.getExternalIPs();
        if (this$externalIPs == null ? other$externalIPs != null : !((Object)this$externalIPs).equals(other$externalIPs)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericKafkaListenerConfigurationBootstrap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $nodePort = this.getNodePort();
        result = result * 59 + ($nodePort == null ? 43 : ((Object)$nodePort).hashCode());
        List<String> $alternativeNames = this.getAlternativeNames();
        result = result * 59 + ($alternativeNames == null ? 43 : ((Object)$alternativeNames).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        String $loadBalancerIP = this.getLoadBalancerIP();
        result = result * 59 + ($loadBalancerIP == null ? 43 : $loadBalancerIP.hashCode());
        List<String> $externalIPs = this.getExternalIPs();
        result = result * 59 + ($externalIPs == null ? 43 : ((Object)$externalIPs).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "GenericKafkaListenerConfigurationBootstrap(alternativeNames=" + this.getAlternativeNames() + ", host=" + this.getHost() + ", annotations=" + this.getAnnotations() + ", labels=" + this.getLabels() + ", nodePort=" + this.getNodePort() + ", loadBalancerIP=" + this.getLoadBalancerIP() + ", externalIPs=" + this.getExternalIPs() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }
}

