/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListener;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfiguration;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationBuilder;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationFluent;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationCustom;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationCustomBuilder;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationCustomFluent;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationOAuth;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationOAuthBuilder;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationScramSha512;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationTls;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationTlsFluent;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GenericKafkaListenerFluent<A extends GenericKafkaListenerFluent<A>>
extends BaseFluent<A> {
    private String name;
    private int port;
    private KafkaListenerType type;
    private boolean tls;
    private VisitableBuilder<? extends KafkaListenerAuthentication, ?> auth;
    private GenericKafkaListenerConfigurationBuilder configuration;
    private List<NetworkPolicyPeer> networkPolicyPeers;

    public GenericKafkaListenerFluent() {
    }

    public GenericKafkaListenerFluent(GenericKafkaListener instance) {
        GenericKafkaListener genericKafkaListener = instance = instance != null ? instance : new GenericKafkaListener();
        if (instance != null) {
            this.withName(instance.getName());
            this.withPort(instance.getPort());
            this.withType(instance.getType());
            this.withTls(instance.isTls());
            this.withAuth(instance.getAuth());
            this.withConfiguration(instance.getConfiguration());
            this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public int getPort() {
        return this.port;
    }

    public A withPort(int port) {
        this.port = port;
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return true;
    }

    public KafkaListenerType getType() {
        return this.type;
    }

    public A withType(KafkaListenerType type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public boolean isTls() {
        return this.tls;
    }

    public A withTls(boolean tls) {
        this.tls = tls;
        return (A)((Object)this);
    }

    public boolean hasTls() {
        return true;
    }

    public KafkaListenerAuthentication buildAuth() {
        return this.auth != null ? (KafkaListenerAuthentication)this.auth.build() : null;
    }

    public A withAuth(KafkaListenerAuthentication auth) {
        if (auth == null) {
            this.auth = null;
            this._visitables.remove((Object)"auth");
            return (A)((Object)this);
        }
        VisitableBuilder builder = GenericKafkaListenerFluent.builder(auth);
        this._visitables.get((Object)"auth").clear();
        this._visitables.get((Object)"auth").add(builder);
        this.auth = builder;
        return (A)((Object)this);
    }

    public boolean hasAuth() {
        return this.auth != null;
    }

    public KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuth() {
        return new KafkaListenerAuthenticationTlsAuthNested(null);
    }

    public KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuthLike(KafkaListenerAuthenticationTls item) {
        return new KafkaListenerAuthenticationTlsAuthNested(item);
    }

    public KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512Auth() {
        return new KafkaListenerAuthenticationScramSha512AuthNested(null);
    }

    public KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512AuthLike(KafkaListenerAuthenticationScramSha512 item) {
        return new KafkaListenerAuthenticationScramSha512AuthNested(item);
    }

    public KafkaListenerAuthenticationCustomAuthNested<A> withNewKafkaListenerAuthenticationCustomAuth() {
        return new KafkaListenerAuthenticationCustomAuthNested(null);
    }

    public KafkaListenerAuthenticationCustomAuthNested<A> withNewKafkaListenerAuthenticationCustomAuthLike(KafkaListenerAuthenticationCustom item) {
        return new KafkaListenerAuthenticationCustomAuthNested(item);
    }

    public KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuth() {
        return new KafkaListenerAuthenticationOAuthNested(null);
    }

    public KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuthLike(KafkaListenerAuthenticationOAuth item) {
        return new KafkaListenerAuthenticationOAuthNested(item);
    }

    public GenericKafkaListenerConfiguration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(GenericKafkaListenerConfiguration configuration) {
        this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        if (configuration != null) {
            this.configuration = new GenericKafkaListenerConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(GenericKafkaListenerConfiguration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new GenericKafkaListenerConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(GenericKafkaListenerConfiguration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public A addToNetworkPolicyPeers(int index, NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        this.networkPolicyPeers.add(index, item);
        return (A)((Object)this);
    }

    public A setToNetworkPolicyPeers(int index, NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        this.networkPolicyPeers.set(index, item);
        return (A)((Object)this);
    }

    public A addToNetworkPolicyPeers(NetworkPolicyPeer ... items) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        for (NetworkPolicyPeer item : items) {
            this.networkPolicyPeers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
        if (this.networkPolicyPeers == null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
        }
        for (NetworkPolicyPeer item : items) {
            this.networkPolicyPeers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromNetworkPolicyPeers(NetworkPolicyPeer ... items) {
        if (this.networkPolicyPeers == null) {
            return (A)((Object)this);
        }
        for (NetworkPolicyPeer item : items) {
            this.networkPolicyPeers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
        if (this.networkPolicyPeers == null) {
            return (A)((Object)this);
        }
        for (NetworkPolicyPeer item : items) {
            this.networkPolicyPeers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<NetworkPolicyPeer> getNetworkPolicyPeers() {
        return this.networkPolicyPeers;
    }

    public NetworkPolicyPeer getNetworkPolicyPeer(int index) {
        return this.networkPolicyPeers.get(index);
    }

    public NetworkPolicyPeer getFirstNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(0);
    }

    public NetworkPolicyPeer getLastNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(this.networkPolicyPeers.size() - 1);
    }

    public NetworkPolicyPeer getMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
        for (NetworkPolicyPeer item : this.networkPolicyPeers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
        for (NetworkPolicyPeer item : this.networkPolicyPeers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNetworkPolicyPeers(List<NetworkPolicyPeer> networkPolicyPeers) {
        if (networkPolicyPeers != null) {
            this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();
            for (NetworkPolicyPeer item : networkPolicyPeers) {
                this.addToNetworkPolicyPeers(item);
            }
        } else {
            this.networkPolicyPeers = null;
        }
        return (A)((Object)this);
    }

    public A withNetworkPolicyPeers(NetworkPolicyPeer ... networkPolicyPeers) {
        if (this.networkPolicyPeers != null) {
            this.networkPolicyPeers.clear();
            this._visitables.remove((Object)"networkPolicyPeers");
        }
        if (networkPolicyPeers != null) {
            for (NetworkPolicyPeer item : networkPolicyPeers) {
                this.addToNetworkPolicyPeers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasNetworkPolicyPeers() {
        return this.networkPolicyPeers != null && !this.networkPolicyPeers.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericKafkaListenerFluent that = (GenericKafkaListenerFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        if (!Objects.equals((Object)this.type, (Object)that.type)) {
            return false;
        }
        if (this.tls != that.tls) {
            return false;
        }
        if (!Objects.equals(this.auth, that.auth)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        return Objects.equals(this.networkPolicyPeers, that.networkPolicyPeers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.port, this.type, this.tls, this.auth, this.configuration, this.networkPolicyPeers, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        sb.append("port:");
        sb.append(this.port + ",");
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        sb.append("tls:");
        sb.append(this.tls + ",");
        if (this.auth != null) {
            sb.append("auth:");
            sb.append(this.auth + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.networkPolicyPeers != null && !this.networkPolicyPeers.isEmpty()) {
            sb.append("networkPolicyPeers:");
            sb.append(this.networkPolicyPeers);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationTls": {
                return new KafkaListenerAuthenticationTlsBuilder((KafkaListenerAuthenticationTls)item);
            }
            case "io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationScramSha512": {
                return new KafkaListenerAuthenticationScramSha512Builder((KafkaListenerAuthenticationScramSha512)item);
            }
            case "io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationCustom": {
                return new KafkaListenerAuthenticationCustomBuilder((KafkaListenerAuthenticationCustom)item);
            }
            case "io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthenticationOAuth": {
                return new KafkaListenerAuthenticationOAuthBuilder((KafkaListenerAuthenticationOAuth)item);
            }
        }
        return GenericKafkaListenerFluent.builderOf((Object)item);
    }

    public A withTls() {
        return this.withTls(true);
    }

    public class KafkaListenerAuthenticationTlsAuthNested<N>
    extends KafkaListenerAuthenticationTlsFluent<KafkaListenerAuthenticationTlsAuthNested<N>>
    implements Nested<N> {
        KafkaListenerAuthenticationTlsBuilder builder;

        KafkaListenerAuthenticationTlsAuthNested(KafkaListenerAuthenticationTls item) {
            this.builder = new KafkaListenerAuthenticationTlsBuilder(this, item);
        }

        public N and() {
            return (N)GenericKafkaListenerFluent.this.withAuth(this.builder.build());
        }

        public N endKafkaListenerAuthenticationTlsAuth() {
            return this.and();
        }
    }

    public class KafkaListenerAuthenticationScramSha512AuthNested<N>
    extends KafkaListenerAuthenticationScramSha512Fluent<KafkaListenerAuthenticationScramSha512AuthNested<N>>
    implements Nested<N> {
        KafkaListenerAuthenticationScramSha512Builder builder;

        KafkaListenerAuthenticationScramSha512AuthNested(KafkaListenerAuthenticationScramSha512 item) {
            this.builder = new KafkaListenerAuthenticationScramSha512Builder(this, item);
        }

        public N and() {
            return (N)GenericKafkaListenerFluent.this.withAuth(this.builder.build());
        }

        public N endKafkaListenerAuthenticationScramSha512Auth() {
            return this.and();
        }
    }

    public class KafkaListenerAuthenticationCustomAuthNested<N>
    extends KafkaListenerAuthenticationCustomFluent<KafkaListenerAuthenticationCustomAuthNested<N>>
    implements Nested<N> {
        KafkaListenerAuthenticationCustomBuilder builder;

        KafkaListenerAuthenticationCustomAuthNested(KafkaListenerAuthenticationCustom item) {
            this.builder = new KafkaListenerAuthenticationCustomBuilder(this, item);
        }

        public N and() {
            return (N)GenericKafkaListenerFluent.this.withAuth(this.builder.build());
        }

        public N endKafkaListenerAuthenticationCustomAuth() {
            return this.and();
        }
    }

    public class KafkaListenerAuthenticationOAuthNested<N>
    extends KafkaListenerAuthenticationOAuthFluent<KafkaListenerAuthenticationOAuthNested<N>>
    implements Nested<N> {
        KafkaListenerAuthenticationOAuthBuilder builder;

        KafkaListenerAuthenticationOAuthNested(KafkaListenerAuthenticationOAuth item) {
            this.builder = new KafkaListenerAuthenticationOAuthBuilder(this, item);
        }

        public N and() {
            return (N)GenericKafkaListenerFluent.this.withAuth(this.builder.build());
        }

        public N endKafkaListenerAuthenticationOAuth() {
            return this.and();
        }
    }

    public class ConfigurationNested<N>
    extends GenericKafkaListenerConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        GenericKafkaListenerConfigurationBuilder builder;

        ConfigurationNested(GenericKafkaListenerConfiguration item) {
            this.builder = new GenericKafkaListenerConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)GenericKafkaListenerFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

