/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.listener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.GenericSecretSource;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthentication;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import java.util.List;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "sasl", "listenerConfig", "secrets"})
public class KafkaListenerAuthenticationCustom
extends KafkaListenerAuthentication {
    public static final String FORBIDDEN_PREFIXES = "ssl.";
    public static final String TYPE_CUSTOM = "custom";
    private Map<String, Object> listenerConfig;
    private boolean sasl;
    private List<GenericSecretSource> secrets;

    @Override
    @Description(value="Must be `custom`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return TYPE_CUSTOM;
    }

    @Description(value="Enable or disable SASL on this listener.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public boolean isSasl() {
        return this.sasl;
    }

    public void setSasl(boolean enabled) {
        this.sasl = enabled;
    }

    @Description(value="Configuration to be used for a specific listener. All values are prefixed with listener.name._<listener_name>_.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> getListenerConfig() {
        return this.listenerConfig;
    }

    public void setListenerConfig(Map<String, Object> config) {
        this.listenerConfig = config;
    }

    @Description(value="Secrets to be mounted to /opt/kafka/custom-authn-secrets/custom-listener-_<listener_name>-<port>_/_<secret_name>_")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<GenericSecretSource> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(List<GenericSecretSource> secrets) {
        this.secrets = secrets;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaListenerAuthenticationCustom)) {
            return false;
        }
        KafkaListenerAuthenticationCustom other = (KafkaListenerAuthenticationCustom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSasl() != other.isSasl()) {
            return false;
        }
        Map<String, Object> this$listenerConfig = this.getListenerConfig();
        Map<String, Object> other$listenerConfig = other.getListenerConfig();
        if (this$listenerConfig == null ? other$listenerConfig != null : !((Object)this$listenerConfig).equals(other$listenerConfig)) {
            return false;
        }
        List<GenericSecretSource> this$secrets = this.getSecrets();
        List<GenericSecretSource> other$secrets = other.getSecrets();
        return !(this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaListenerAuthenticationCustom;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSasl() ? 79 : 97);
        Map<String, Object> $listenerConfig = this.getListenerConfig();
        result = result * 59 + ($listenerConfig == null ? 43 : ((Object)$listenerConfig).hashCode());
        List<GenericSecretSource> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaListenerAuthenticationCustom(super=" + super.toString() + ", listenerConfig=" + this.getListenerConfig() + ", sasl=" + this.isSasl() + ", secrets=" + this.getSecrets() + ")";
    }
}

