/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.tieredstorage;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.kafka.tieredstorage.RemoteStorageManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class RemoteStorageManagerFluent<A extends RemoteStorageManagerFluent<A>>
extends BaseFluent<A> {
    private String className;
    private String classPath;
    private Map<String, String> config;

    public RemoteStorageManagerFluent() {
    }

    public RemoteStorageManagerFluent(RemoteStorageManager instance) {
        RemoteStorageManager remoteStorageManager = instance = instance != null ? instance : new RemoteStorageManager();
        if (instance != null) {
            this.withClassName(instance.getClassName());
            this.withClassPath(instance.getClassPath());
            this.withConfig(instance.getConfig());
        }
    }

    public String getClassName() {
        return this.className;
    }

    public A withClassName(String className) {
        this.className = className;
        return (A)((Object)this);
    }

    public boolean hasClassName() {
        return this.className != null;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public A withClassPath(String classPath) {
        this.classPath = classPath;
        return (A)((Object)this);
    }

    public boolean hasClassPath() {
        return this.classPath != null;
    }

    public A addToConfig(String key, String value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConfig(Map<String, String> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(Map<String, String> map) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public <K, V> A withConfig(Map<String, String> config) {
        this.config = config == null ? null : new LinkedHashMap<String, String>(config);
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoteStorageManagerFluent that = (RemoteStorageManagerFluent)((Object)o);
        if (!Objects.equals(this.className, that.className)) {
            return false;
        }
        if (!Objects.equals(this.classPath, that.classPath)) {
            return false;
        }
        return Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.classPath, this.config, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.className != null) {
            sb.append("className:");
            sb.append(this.className + ",");
        }
        if (this.classPath != null) {
            sb.append("classPath:");
            sb.append(this.classPath + ",");
        }
        if (this.config != null && !this.config.isEmpty()) {
            sb.append("config:");
            sb.append(this.config);
        }
        sb.append("}");
        return sb.toString();
    }
}

