/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.nodepool;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.SpecFluent;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.PodTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateFluent;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolTemplate;
import java.util.Objects;
import java.util.Optional;

public class KafkaNodePoolTemplateFluent<A extends KafkaNodePoolTemplateFluent<A>>
extends SpecFluent<A> {
    private ResourceTemplateBuilder podSet;
    private PodTemplateBuilder pod;
    private ResourceTemplateBuilder perPodService;
    private ResourceTemplateBuilder perPodRoute;
    private ResourceTemplateBuilder perPodIngress;
    private ResourceTemplateBuilder persistentVolumeClaim;
    private ContainerTemplateBuilder kafkaContainer;
    private ContainerTemplateBuilder initContainer;

    public KafkaNodePoolTemplateFluent() {
    }

    public KafkaNodePoolTemplateFluent(KafkaNodePoolTemplate instance) {
        KafkaNodePoolTemplate kafkaNodePoolTemplate = instance = instance != null ? instance : new KafkaNodePoolTemplate();
        if (instance != null) {
            this.withPodSet(instance.getPodSet());
            this.withPod(instance.getPod());
            this.withPerPodService(instance.getPerPodService());
            this.withPerPodRoute(instance.getPerPodRoute());
            this.withPerPodIngress(instance.getPerPodIngress());
            this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
            this.withKafkaContainer(instance.getKafkaContainer());
            this.withInitContainer(instance.getInitContainer());
        }
    }

    public ResourceTemplate buildPodSet() {
        return this.podSet != null ? this.podSet.build() : null;
    }

    public A withPodSet(ResourceTemplate podSet) {
        this._visitables.get((Object)"podSet").remove((Object)this.podSet);
        if (podSet != null) {
            this.podSet = new ResourceTemplateBuilder(podSet);
            this._visitables.get((Object)"podSet").add(this.podSet);
        } else {
            this.podSet = null;
            this._visitables.get((Object)"podSet").remove((Object)this.podSet);
        }
        return (A)((Object)this);
    }

    public boolean hasPodSet() {
        return this.podSet != null;
    }

    public PodSetNested<A> withNewPodSet() {
        return new PodSetNested(null);
    }

    public PodSetNested<A> withNewPodSetLike(ResourceTemplate item) {
        return new PodSetNested(item);
    }

    public PodSetNested<A> editPodSet() {
        return this.withNewPodSetLike(Optional.ofNullable(this.buildPodSet()).orElse(null));
    }

    public PodSetNested<A> editOrNewPodSet() {
        return this.withNewPodSetLike(Optional.ofNullable(this.buildPodSet()).orElse(new ResourceTemplateBuilder().build()));
    }

    public PodSetNested<A> editOrNewPodSetLike(ResourceTemplate item) {
        return this.withNewPodSetLike(Optional.ofNullable(this.buildPodSet()).orElse(item));
    }

    public PodTemplate buildPod() {
        return this.pod != null ? this.pod.build() : null;
    }

    public A withPod(PodTemplate pod) {
        this._visitables.get((Object)"pod").remove((Object)this.pod);
        if (pod != null) {
            this.pod = new PodTemplateBuilder(pod);
            this._visitables.get((Object)"pod").add(this.pod);
        } else {
            this.pod = null;
            this._visitables.get((Object)"pod").remove((Object)this.pod);
        }
        return (A)((Object)this);
    }

    public boolean hasPod() {
        return this.pod != null;
    }

    public PodNested<A> withNewPod() {
        return new PodNested(null);
    }

    public PodNested<A> withNewPodLike(PodTemplate item) {
        return new PodNested(item);
    }

    public PodNested<A> editPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(null));
    }

    public PodNested<A> editOrNewPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(new PodTemplateBuilder().build()));
    }

    public PodNested<A> editOrNewPodLike(PodTemplate item) {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(item));
    }

    public ResourceTemplate buildPerPodService() {
        return this.perPodService != null ? this.perPodService.build() : null;
    }

    public A withPerPodService(ResourceTemplate perPodService) {
        this._visitables.get((Object)"perPodService").remove((Object)this.perPodService);
        if (perPodService != null) {
            this.perPodService = new ResourceTemplateBuilder(perPodService);
            this._visitables.get((Object)"perPodService").add(this.perPodService);
        } else {
            this.perPodService = null;
            this._visitables.get((Object)"perPodService").remove((Object)this.perPodService);
        }
        return (A)((Object)this);
    }

    public boolean hasPerPodService() {
        return this.perPodService != null;
    }

    public PerPodServiceNested<A> withNewPerPodService() {
        return new PerPodServiceNested(null);
    }

    public PerPodServiceNested<A> withNewPerPodServiceLike(ResourceTemplate item) {
        return new PerPodServiceNested(item);
    }

    public PerPodServiceNested<A> editPerPodService() {
        return this.withNewPerPodServiceLike(Optional.ofNullable(this.buildPerPodService()).orElse(null));
    }

    public PerPodServiceNested<A> editOrNewPerPodService() {
        return this.withNewPerPodServiceLike(Optional.ofNullable(this.buildPerPodService()).orElse(new ResourceTemplateBuilder().build()));
    }

    public PerPodServiceNested<A> editOrNewPerPodServiceLike(ResourceTemplate item) {
        return this.withNewPerPodServiceLike(Optional.ofNullable(this.buildPerPodService()).orElse(item));
    }

    public ResourceTemplate buildPerPodRoute() {
        return this.perPodRoute != null ? this.perPodRoute.build() : null;
    }

    public A withPerPodRoute(ResourceTemplate perPodRoute) {
        this._visitables.get((Object)"perPodRoute").remove((Object)this.perPodRoute);
        if (perPodRoute != null) {
            this.perPodRoute = new ResourceTemplateBuilder(perPodRoute);
            this._visitables.get((Object)"perPodRoute").add(this.perPodRoute);
        } else {
            this.perPodRoute = null;
            this._visitables.get((Object)"perPodRoute").remove((Object)this.perPodRoute);
        }
        return (A)((Object)this);
    }

    public boolean hasPerPodRoute() {
        return this.perPodRoute != null;
    }

    public PerPodRouteNested<A> withNewPerPodRoute() {
        return new PerPodRouteNested(null);
    }

    public PerPodRouteNested<A> withNewPerPodRouteLike(ResourceTemplate item) {
        return new PerPodRouteNested(item);
    }

    public PerPodRouteNested<A> editPerPodRoute() {
        return this.withNewPerPodRouteLike(Optional.ofNullable(this.buildPerPodRoute()).orElse(null));
    }

    public PerPodRouteNested<A> editOrNewPerPodRoute() {
        return this.withNewPerPodRouteLike(Optional.ofNullable(this.buildPerPodRoute()).orElse(new ResourceTemplateBuilder().build()));
    }

    public PerPodRouteNested<A> editOrNewPerPodRouteLike(ResourceTemplate item) {
        return this.withNewPerPodRouteLike(Optional.ofNullable(this.buildPerPodRoute()).orElse(item));
    }

    public ResourceTemplate buildPerPodIngress() {
        return this.perPodIngress != null ? this.perPodIngress.build() : null;
    }

    public A withPerPodIngress(ResourceTemplate perPodIngress) {
        this._visitables.get((Object)"perPodIngress").remove((Object)this.perPodIngress);
        if (perPodIngress != null) {
            this.perPodIngress = new ResourceTemplateBuilder(perPodIngress);
            this._visitables.get((Object)"perPodIngress").add(this.perPodIngress);
        } else {
            this.perPodIngress = null;
            this._visitables.get((Object)"perPodIngress").remove((Object)this.perPodIngress);
        }
        return (A)((Object)this);
    }

    public boolean hasPerPodIngress() {
        return this.perPodIngress != null;
    }

    public PerPodIngressNested<A> withNewPerPodIngress() {
        return new PerPodIngressNested(null);
    }

    public PerPodIngressNested<A> withNewPerPodIngressLike(ResourceTemplate item) {
        return new PerPodIngressNested(item);
    }

    public PerPodIngressNested<A> editPerPodIngress() {
        return this.withNewPerPodIngressLike(Optional.ofNullable(this.buildPerPodIngress()).orElse(null));
    }

    public PerPodIngressNested<A> editOrNewPerPodIngress() {
        return this.withNewPerPodIngressLike(Optional.ofNullable(this.buildPerPodIngress()).orElse(new ResourceTemplateBuilder().build()));
    }

    public PerPodIngressNested<A> editOrNewPerPodIngressLike(ResourceTemplate item) {
        return this.withNewPerPodIngressLike(Optional.ofNullable(this.buildPerPodIngress()).orElse(item));
    }

    public ResourceTemplate buildPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null ? this.persistentVolumeClaim.build() : null;
    }

    public A withPersistentVolumeClaim(ResourceTemplate persistentVolumeClaim) {
        this._visitables.get((Object)"persistentVolumeClaim").remove((Object)this.persistentVolumeClaim);
        if (persistentVolumeClaim != null) {
            this.persistentVolumeClaim = new ResourceTemplateBuilder(persistentVolumeClaim);
            this._visitables.get((Object)"persistentVolumeClaim").add(this.persistentVolumeClaim);
        } else {
            this.persistentVolumeClaim = null;
            this._visitables.get((Object)"persistentVolumeClaim").remove((Object)this.persistentVolumeClaim);
        }
        return (A)((Object)this);
    }

    public boolean hasPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null;
    }

    public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
        return new PersistentVolumeClaimNested(null);
    }

    public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(ResourceTemplate item) {
        return new PersistentVolumeClaimNested(item);
    }

    public PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
        return this.withNewPersistentVolumeClaimLike(Optional.ofNullable(this.buildPersistentVolumeClaim()).orElse(null));
    }

    public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
        return this.withNewPersistentVolumeClaimLike(Optional.ofNullable(this.buildPersistentVolumeClaim()).orElse(new ResourceTemplateBuilder().build()));
    }

    public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(ResourceTemplate item) {
        return this.withNewPersistentVolumeClaimLike(Optional.ofNullable(this.buildPersistentVolumeClaim()).orElse(item));
    }

    public ContainerTemplate buildKafkaContainer() {
        return this.kafkaContainer != null ? this.kafkaContainer.build() : null;
    }

    public A withKafkaContainer(ContainerTemplate kafkaContainer) {
        this._visitables.get((Object)"kafkaContainer").remove((Object)this.kafkaContainer);
        if (kafkaContainer != null) {
            this.kafkaContainer = new ContainerTemplateBuilder(kafkaContainer);
            this._visitables.get((Object)"kafkaContainer").add(this.kafkaContainer);
        } else {
            this.kafkaContainer = null;
            this._visitables.get((Object)"kafkaContainer").remove((Object)this.kafkaContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasKafkaContainer() {
        return this.kafkaContainer != null;
    }

    public KafkaContainerNested<A> withNewKafkaContainer() {
        return new KafkaContainerNested(null);
    }

    public KafkaContainerNested<A> withNewKafkaContainerLike(ContainerTemplate item) {
        return new KafkaContainerNested(item);
    }

    public KafkaContainerNested<A> editKafkaContainer() {
        return this.withNewKafkaContainerLike(Optional.ofNullable(this.buildKafkaContainer()).orElse(null));
    }

    public KafkaContainerNested<A> editOrNewKafkaContainer() {
        return this.withNewKafkaContainerLike(Optional.ofNullable(this.buildKafkaContainer()).orElse(new ContainerTemplateBuilder().build()));
    }

    public KafkaContainerNested<A> editOrNewKafkaContainerLike(ContainerTemplate item) {
        return this.withNewKafkaContainerLike(Optional.ofNullable(this.buildKafkaContainer()).orElse(item));
    }

    public ContainerTemplate buildInitContainer() {
        return this.initContainer != null ? this.initContainer.build() : null;
    }

    public A withInitContainer(ContainerTemplate initContainer) {
        this._visitables.get((Object)"initContainer").remove((Object)this.initContainer);
        if (initContainer != null) {
            this.initContainer = new ContainerTemplateBuilder(initContainer);
            this._visitables.get((Object)"initContainer").add(this.initContainer);
        } else {
            this.initContainer = null;
            this._visitables.get((Object)"initContainer").remove((Object)this.initContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasInitContainer() {
        return this.initContainer != null;
    }

    public InitContainerNested<A> withNewInitContainer() {
        return new InitContainerNested(null);
    }

    public InitContainerNested<A> withNewInitContainerLike(ContainerTemplate item) {
        return new InitContainerNested(item);
    }

    public InitContainerNested<A> editInitContainer() {
        return this.withNewInitContainerLike(Optional.ofNullable(this.buildInitContainer()).orElse(null));
    }

    public InitContainerNested<A> editOrNewInitContainer() {
        return this.withNewInitContainerLike(Optional.ofNullable(this.buildInitContainer()).orElse(new ContainerTemplateBuilder().build()));
    }

    public InitContainerNested<A> editOrNewInitContainerLike(ContainerTemplate item) {
        return this.withNewInitContainerLike(Optional.ofNullable(this.buildInitContainer()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaNodePoolTemplateFluent that = (KafkaNodePoolTemplateFluent)((Object)o);
        if (!Objects.equals((Object)this.podSet, (Object)that.podSet)) {
            return false;
        }
        if (!Objects.equals((Object)this.pod, (Object)that.pod)) {
            return false;
        }
        if (!Objects.equals((Object)this.perPodService, (Object)that.perPodService)) {
            return false;
        }
        if (!Objects.equals((Object)this.perPodRoute, (Object)that.perPodRoute)) {
            return false;
        }
        if (!Objects.equals((Object)this.perPodIngress, (Object)that.perPodIngress)) {
            return false;
        }
        if (!Objects.equals((Object)this.persistentVolumeClaim, (Object)that.persistentVolumeClaim)) {
            return false;
        }
        if (!Objects.equals((Object)this.kafkaContainer, (Object)that.kafkaContainer)) {
            return false;
        }
        return Objects.equals((Object)this.initContainer, (Object)that.initContainer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.podSet, this.pod, this.perPodService, this.perPodRoute, this.perPodIngress, this.persistentVolumeClaim, this.kafkaContainer, this.initContainer, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.podSet != null) {
            sb.append("podSet:");
            sb.append(this.podSet + ",");
        }
        if (this.pod != null) {
            sb.append("pod:");
            sb.append(this.pod + ",");
        }
        if (this.perPodService != null) {
            sb.append("perPodService:");
            sb.append(this.perPodService + ",");
        }
        if (this.perPodRoute != null) {
            sb.append("perPodRoute:");
            sb.append(this.perPodRoute + ",");
        }
        if (this.perPodIngress != null) {
            sb.append("perPodIngress:");
            sb.append(this.perPodIngress + ",");
        }
        if (this.persistentVolumeClaim != null) {
            sb.append("persistentVolumeClaim:");
            sb.append(this.persistentVolumeClaim + ",");
        }
        if (this.kafkaContainer != null) {
            sb.append("kafkaContainer:");
            sb.append(this.kafkaContainer + ",");
        }
        if (this.initContainer != null) {
            sb.append("initContainer:");
            sb.append((Object)this.initContainer);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PodSetNested<N>
    extends ResourceTemplateFluent<PodSetNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        PodSetNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolTemplateFluent.this.withPodSet(this.builder.build());
        }

        public N endPodSet() {
            return this.and();
        }
    }

    public class PodNested<N>
    extends PodTemplateFluent<PodNested<N>>
    implements Nested<N> {
        PodTemplateBuilder builder;

        PodNested(PodTemplate item) {
            this.builder = new PodTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolTemplateFluent.this.withPod(this.builder.build());
        }

        public N endPod() {
            return this.and();
        }
    }

    public class PerPodServiceNested<N>
    extends ResourceTemplateFluent<PerPodServiceNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        PerPodServiceNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolTemplateFluent.this.withPerPodService(this.builder.build());
        }

        public N endPerPodService() {
            return this.and();
        }
    }

    public class PerPodRouteNested<N>
    extends ResourceTemplateFluent<PerPodRouteNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        PerPodRouteNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolTemplateFluent.this.withPerPodRoute(this.builder.build());
        }

        public N endPerPodRoute() {
            return this.and();
        }
    }

    public class PerPodIngressNested<N>
    extends ResourceTemplateFluent<PerPodIngressNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        PerPodIngressNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolTemplateFluent.this.withPerPodIngress(this.builder.build());
        }

        public N endPerPodIngress() {
            return this.and();
        }
    }

    public class PersistentVolumeClaimNested<N>
    extends ResourceTemplateFluent<PersistentVolumeClaimNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        PersistentVolumeClaimNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolTemplateFluent.this.withPersistentVolumeClaim(this.builder.build());
        }

        public N endPersistentVolumeClaim() {
            return this.and();
        }
    }

    public class KafkaContainerNested<N>
    extends ContainerTemplateFluent<KafkaContainerNested<N>>
    implements Nested<N> {
        ContainerTemplateBuilder builder;

        KafkaContainerNested(ContainerTemplate item) {
            this.builder = new ContainerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolTemplateFluent.this.withKafkaContainer(this.builder.build());
        }

        public N endKafkaContainer() {
            return this.and();
        }
    }

    public class InitContainerNested<N>
    extends ContainerTemplateFluent<InitContainerNested<N>>
    implements Nested<N> {
        ContainerTemplateBuilder builder;

        InitContainerNested(ContainerTemplate item) {
            this.builder = new ContainerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolTemplateFluent.this.withInitContainer(this.builder.build());
        }

        public N endInitContainer() {
            return this.and();
        }
    }
}

