/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.topic;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.strimzi.api.kafka.model.common.CustomResourceConditions;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.topic.KafkaTopicSpec;
import io.strimzi.api.kafka.model.topic.KafkaTopicStatus;
import io.strimzi.crdgenerator.annotations.Crd;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

@JsonDeserialize
@Crd(spec=@Crd.Spec(names=@Crd.Spec.Names(kind="KafkaTopic", plural="kafkatopics", shortNames={"kt"}, categories={"strimzi"}), group="kafka.strimzi.io", scope="Namespaced", versions={@Crd.Spec.Version(name="v1beta2", served=true, storage=false), @Crd.Spec.Version(name="v1beta1", served=true, storage=true), @Crd.Spec.Version(name="v1alpha1", served=true, storage=false)}, subresources=@Crd.Spec.Subresources(status={@Crd.Spec.Subresources.Status}), additionalPrinterColumns={@Crd.Spec.AdditionalPrinterColumn(name="Cluster", description="The name of the Kafka cluster this topic belongs to", jsonPath=".metadata.labels.strimzi\\.io/cluster", type="string"), @Crd.Spec.AdditionalPrinterColumn(name="Partitions", description="The desired number of partitions in the topic", jsonPath=".spec.partitions", type="integer"), @Crd.Spec.AdditionalPrinterColumn(name="Replication factor", description="The desired number of replicas of each partition", jsonPath=".spec.replicas", type="integer"), @Crd.Spec.AdditionalPrinterColumn(name="Ready", description="The state of the custom resource", jsonPath=".status.conditions[?(@.type==\"Ready\")].status", type="string")}))
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
@Version(value="v1beta2")
@Group(value="kafka.strimzi.io")
public class KafkaTopic
extends CustomResource<KafkaTopicSpec, KafkaTopicStatus>
implements Namespaced,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    public static final String SCOPE = "Namespaced";
    public static final String V1ALPHA1 = "v1alpha1";
    public static final String V1BETA1 = "v1beta1";
    public static final String V1BETA2 = "v1beta2";
    public static final String CONSUMED_VERSION = "v1beta2";
    public static final List<String> VERSIONS = List.of("v1beta2", "v1beta1", "v1alpha1");
    public static final String RESOURCE_KIND = "KafkaTopic";
    public static final String RESOURCE_LIST_KIND = "KafkaTopicList";
    public static final String RESOURCE_GROUP = "kafka.strimzi.io";
    public static final String RESOURCE_PLURAL = "kafkatopics";
    public static final String RESOURCE_SINGULAR = "kafkatopic";
    public static final String CRD_NAME = "kafkatopics.kafka.strimzi.io";
    public static final String SHORT_NAME = "kt";
    public static final List<String> RESOURCE_SHORTNAMES = List.of("kt");
    private final Map<String, Object> additionalProperties = new HashMap<String, Object>(0);
    private String apiVersion;
    private String kind;

    public KafkaTopic() {
    }

    public KafkaTopic(KafkaTopicSpec spec, KafkaTopicStatus status) {
        this.spec = spec;
        this.status = status;
    }

    @Description(value="The specification of the topic.")
    public KafkaTopicSpec getSpec() {
        return (KafkaTopicSpec)super.getSpec();
    }

    @Description(value="The status of the topic.")
    public KafkaTopicStatus getStatus() {
        return (KafkaTopicStatus)super.getStatus();
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Collections.emptyMap();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public static Predicate<KafkaTopic> isReady() {
        return CustomResourceConditions.isReady();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaTopic)) {
            return false;
        }
        KafkaTopic other = (KafkaTopic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        if (this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties)) {
            return false;
        }
        String this$apiVersion = this.apiVersion;
        String other$apiVersion = other.apiVersion;
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$kind = this.kind;
        String other$kind = other.kind;
        return !(this$kind == null ? other$kind != null : !this$kind.equals(other$kind));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaTopic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        String $apiVersion = this.apiVersion;
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $kind = this.kind;
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaTopic(super=" + super.toString() + ", additionalProperties=" + this.getAdditionalProperties() + ", apiVersion=" + this.apiVersion + ", kind=" + this.kind + ")";
    }
}

