/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.bridge;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeSpec;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeStatus;
import io.strimzi.api.kafka.model.common.CustomResourceConditions;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Crd;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

@JsonDeserialize
@Crd(spec=@Crd.Spec(names=@Crd.Spec.Names(kind="KafkaBridge", plural="kafkabridges", shortNames={"kb"}, categories={"strimzi"}), group="kafka.strimzi.io", scope="Namespaced", versions={@Crd.Spec.Version(name="v1beta2", served=true, storage=false), @Crd.Spec.Version(name="v1alpha1", served=true, storage=true)}, subresources=@Crd.Spec.Subresources(status={@Crd.Spec.Subresources.Status}, scale={@Crd.Spec.Subresources.Scale(specReplicasPath=".spec.replicas", statusReplicasPath=".status.replicas", labelSelectorPath=".status.labelSelector")}), additionalPrinterColumns={@Crd.Spec.AdditionalPrinterColumn(name="Desired replicas", description="The desired number of Kafka Bridge replicas", jsonPath=".spec.replicas", type="integer"), @Crd.Spec.AdditionalPrinterColumn(name="Bootstrap Servers", description="The boostrap servers", jsonPath=".spec.bootstrapServers", type="string", priority=1), @Crd.Spec.AdditionalPrinterColumn(name="Ready", description="The state of the custom resource", jsonPath=".status.conditions[?(@.type==\"Ready\")].status", type="string")}))
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
@Version(value="v1beta2")
@Group(value="kafka.strimzi.io")
public class KafkaBridge
extends CustomResource<KafkaBridgeSpec, KafkaBridgeStatus>
implements Namespaced,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    public static final String SCOPE = "Namespaced";
    public static final String V1BETA2 = "v1beta2";
    public static final String V1ALPHA1 = "v1alpha1";
    public static final String CONSUMED_VERSION = "v1beta2";
    public static final List<String> VERSIONS = List.of("v1beta2", "v1alpha1");
    public static final String RESOURCE_KIND = "KafkaBridge";
    public static final String RESOURCE_LIST_KIND = "KafkaBridgeList";
    public static final String RESOURCE_GROUP = "kafka.strimzi.io";
    public static final String RESOURCE_PLURAL = "kafkabridges";
    public static final String RESOURCE_SINGULAR = "kafkabridge";
    public static final String CRD_NAME = "kafkabridges.kafka.strimzi.io";
    public static final String SHORT_NAME = "kb";
    public static final List<String> RESOURCE_SHORTNAMES = List.of("kb");
    public static final String SPEC_REPLICAS_PATH = ".spec.replicas";
    public static final String STATUS_REPLICAS_PATH = ".status.replicas";
    public static final String LABEL_SELECTOR_PATH = ".status.labelSelector";
    private String apiVersion;
    private String kind;
    private Map<String, Object> additionalProperties;

    public KafkaBridge() {
    }

    public KafkaBridge(KafkaBridgeSpec spec, KafkaBridgeStatus status) {
        this.spec = spec;
        this.status = status;
    }

    @Description(value="The specification of the Kafka Bridge.")
    public KafkaBridgeSpec getSpec() {
        return (KafkaBridgeSpec)super.getSpec();
    }

    @Description(value="The status of the Kafka Bridge.")
    public KafkaBridgeStatus getStatus() {
        return (KafkaBridgeStatus)super.getStatus();
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public static Predicate<KafkaBridge> isReady() {
        return CustomResourceConditions.isReady();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaBridge)) {
            return false;
        }
        KafkaBridge other = (KafkaBridge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.apiVersion;
        String other$apiVersion = other.apiVersion;
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$kind = this.kind;
        String other$kind = other.kind;
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaBridge;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.apiVersion;
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $kind = this.kind;
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaBridge(apiVersion=" + this.apiVersion + ", kind=" + this.kind + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }
}

