/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.SystemProperty;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Pattern;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"-XX", "-Xmx", "-Xms", "gcLoggingEnabled", "javaSystemProperties"})
public class JvmOptions
implements UnknownPropertyPreserving {
    public static final boolean DEFAULT_GC_LOGGING_ENABLED = false;
    private String xmx;
    private String xms;
    private boolean gcLoggingEnabled = false;
    private List<SystemProperty> javaSystemProperties;
    private Map<String, String> xx;
    private Map<String, Object> additionalProperties;

    @JsonProperty(value="-Xmx")
    @Pattern(value="^[0-9]+[mMgG]?$")
    @Description(value="-Xmx option to to the JVM")
    public String getXmx() {
        return this.xmx;
    }

    public void setXmx(String xmx) {
        this.xmx = xmx;
    }

    @JsonProperty(value="-Xms")
    @Pattern(value="^[0-9]+[mMgG]?$")
    @Description(value="-Xms option to to the JVM")
    public String getXms() {
        return this.xms;
    }

    public void setXms(String xms) {
        this.xms = xms;
    }

    @Description(value="Specifies whether the Garbage Collection logging is enabled. The default is false.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isGcLoggingEnabled() {
        return this.gcLoggingEnabled;
    }

    public void setGcLoggingEnabled(boolean gcLoggingEnabled) {
        this.gcLoggingEnabled = gcLoggingEnabled;
    }

    @Description(value="A map of additional system properties which will be passed using the `-D` option to the JVM.")
    public List<SystemProperty> getJavaSystemProperties() {
        return this.javaSystemProperties;
    }

    public void setJavaSystemProperties(List<SystemProperty> javaSystemProperties) {
        this.javaSystemProperties = javaSystemProperties;
    }

    @JsonProperty(value="-XX")
    @Description(value="A map of -XX options to the JVM")
    public Map<String, String> getXx() {
        return this.xx;
    }

    public void setXx(Map<String, String> xx) {
        this.xx = xx;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JvmOptions)) {
            return false;
        }
        JvmOptions other = (JvmOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGcLoggingEnabled() != other.isGcLoggingEnabled()) {
            return false;
        }
        String this$xmx = this.getXmx();
        String other$xmx = other.getXmx();
        if (this$xmx == null ? other$xmx != null : !this$xmx.equals(other$xmx)) {
            return false;
        }
        String this$xms = this.getXms();
        String other$xms = other.getXms();
        if (this$xms == null ? other$xms != null : !this$xms.equals(other$xms)) {
            return false;
        }
        List<SystemProperty> this$javaSystemProperties = this.getJavaSystemProperties();
        List<SystemProperty> other$javaSystemProperties = other.getJavaSystemProperties();
        if (this$javaSystemProperties == null ? other$javaSystemProperties != null : !((Object)this$javaSystemProperties).equals(other$javaSystemProperties)) {
            return false;
        }
        Map<String, String> this$xx = this.getXx();
        Map<String, String> other$xx = other.getXx();
        if (this$xx == null ? other$xx != null : !((Object)this$xx).equals(other$xx)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JvmOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGcLoggingEnabled() ? 79 : 97);
        String $xmx = this.getXmx();
        result = result * 59 + ($xmx == null ? 43 : $xmx.hashCode());
        String $xms = this.getXms();
        result = result * 59 + ($xms == null ? 43 : $xms.hashCode());
        List<SystemProperty> $javaSystemProperties = this.getJavaSystemProperties();
        result = result * 59 + ($javaSystemProperties == null ? 43 : ((Object)$javaSystemProperties).hashCode());
        Map<String, String> $xx = this.getXx();
        result = result * 59 + ($xx == null ? 43 : ((Object)$xx).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "JvmOptions(xmx=" + this.getXmx() + ", xms=" + this.getXms() + ", gcLoggingEnabled=" + this.isGcLoggingEnabled() + ", javaSystemProperties=" + this.getJavaSystemProperties() + ", xx=" + this.getXx() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }
}

