/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.strimzi.api.kafka.model.common.template.AdditionalVolume;
import java.util.Objects;

public class AdditionalVolumeFluent<A extends AdditionalVolumeFluent<A>>
extends BaseFluent<A> {
    private String name;
    private SecretVolumeSource secret;
    private ConfigMapVolumeSource configMap;
    private EmptyDirVolumeSource emptyDir;
    private PersistentVolumeClaimVolumeSource persistentVolumeClaim;

    public AdditionalVolumeFluent() {
    }

    public AdditionalVolumeFluent(AdditionalVolume instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AdditionalVolume instance) {
        AdditionalVolume additionalVolume = instance = instance != null ? instance : new AdditionalVolume();
        if (instance != null) {
            this.withName(instance.getName());
            this.withSecret(instance.getSecret());
            this.withConfigMap(instance.getConfigMap());
            this.withEmptyDir(instance.getEmptyDir());
            this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public SecretVolumeSource getSecret() {
        return this.secret;
    }

    public A withSecret(SecretVolumeSource secret) {
        this.secret = secret;
        return (A)((Object)this);
    }

    public boolean hasSecret() {
        return this.secret != null;
    }

    public ConfigMapVolumeSource getConfigMap() {
        return this.configMap;
    }

    public A withConfigMap(ConfigMapVolumeSource configMap) {
        this.configMap = configMap;
        return (A)((Object)this);
    }

    public boolean hasConfigMap() {
        return this.configMap != null;
    }

    public EmptyDirVolumeSource getEmptyDir() {
        return this.emptyDir;
    }

    public A withEmptyDir(EmptyDirVolumeSource emptyDir) {
        this.emptyDir = emptyDir;
        return (A)((Object)this);
    }

    public boolean hasEmptyDir() {
        return this.emptyDir != null;
    }

    public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim() {
        return this.persistentVolumeClaim;
    }

    public A withPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
        this.persistentVolumeClaim = persistentVolumeClaim;
        return (A)((Object)this);
    }

    public boolean hasPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null;
    }

    public A withNewPersistentVolumeClaim(String claimName, Boolean readOnly) {
        return this.withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdditionalVolumeFluent that = (AdditionalVolumeFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.secret, that.secret)) {
            return false;
        }
        if (!Objects.equals(this.configMap, that.configMap)) {
            return false;
        }
        if (!Objects.equals(this.emptyDir, that.emptyDir)) {
            return false;
        }
        return Objects.equals(this.persistentVolumeClaim, that.persistentVolumeClaim);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.secret, this.configMap, this.emptyDir, this.persistentVolumeClaim, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.secret != null) {
            sb.append("secret:");
            sb.append(this.secret + ",");
        }
        if (this.configMap != null) {
            sb.append("configMap:");
            sb.append(this.configMap + ",");
        }
        if (this.emptyDir != null) {
            sb.append("emptyDir:");
            sb.append(this.emptyDir + ",");
        }
        if (this.persistentVolumeClaim != null) {
            sb.append("persistentVolumeClaim:");
            sb.append(this.persistentVolumeClaim);
        }
        sb.append("}");
        return sb.toString();
    }
}

