/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.common.ExternalLogging;
import io.strimzi.api.kafka.model.common.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.common.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.common.InlineLogging;
import io.strimzi.api.kafka.model.common.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.common.InlineLoggingFluent;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.common.JvmOptionsFluent;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.common.ProbeBuilder;
import io.strimzi.api.kafka.model.common.ProbeFluent;
import io.strimzi.api.kafka.model.common.Rack;
import io.strimzi.api.kafka.model.common.RackBuilder;
import io.strimzi.api.kafka.model.common.RackFluent;
import io.strimzi.api.kafka.model.common.SpecFluent;
import io.strimzi.api.kafka.model.common.jmx.KafkaJmxOptions;
import io.strimzi.api.kafka.model.common.jmx.KafkaJmxOptionsBuilder;
import io.strimzi.api.kafka.model.common.jmx.KafkaJmxOptionsFluent;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetrics;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsBuilder;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsFluent;
import io.strimzi.api.kafka.model.common.metrics.MetricsConfig;
import io.strimzi.api.kafka.model.common.tracing.JaegerTracing;
import io.strimzi.api.kafka.model.common.tracing.JaegerTracingBuilder;
import io.strimzi.api.kafka.model.common.tracing.JaegerTracingFluent;
import io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracing;
import io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracingBuilder;
import io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracingFluent;
import io.strimzi.api.kafka.model.common.tracing.Tracing;
import io.strimzi.api.kafka.model.connect.AbstractKafkaConnectSpec;
import io.strimzi.api.kafka.model.connect.ExternalConfiguration;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationBuilder;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent;
import io.strimzi.api.kafka.model.connect.KafkaConnectTemplate;
import io.strimzi.api.kafka.model.connect.KafkaConnectTemplateBuilder;
import io.strimzi.api.kafka.model.connect.KafkaConnectTemplateFluent;
import java.util.Objects;
import java.util.Optional;

public class AbstractKafkaConnectSpecFluent<A extends AbstractKafkaConnectSpecFluent<A>>
extends SpecFluent<A> {
    private VisitableBuilder<? extends Logging, ?> logging;
    private int replicas;
    private String version;
    private String image;
    private ResourceRequirements resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private KafkaJmxOptionsBuilder jmxOptions;
    private JvmOptionsBuilder jvmOptions;
    private VisitableBuilder<? extends MetricsConfig, ?> metricsConfig;
    private VisitableBuilder<? extends Tracing, ?> tracing;
    private KafkaConnectTemplateBuilder template;
    private ExternalConfigurationBuilder externalConfiguration;
    private String clientRackInitImage;
    private RackBuilder rack;

    public AbstractKafkaConnectSpecFluent() {
    }

    public AbstractKafkaConnectSpecFluent(AbstractKafkaConnectSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AbstractKafkaConnectSpec instance) {
        if (instance != null) {
            this.withLogging(instance.getLogging());
            this.withReplicas(instance.getReplicas());
            this.withVersion(instance.getVersion());
            this.withImage(instance.getImage());
            this.withResources(instance.getResources());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withJmxOptions(instance.getJmxOptions());
            this.withJvmOptions(instance.getJvmOptions());
            this.withMetricsConfig(instance.getMetricsConfig());
            this.withTracing(instance.getTracing());
            this.withTemplate(instance.getTemplate());
            this.withExternalConfiguration(instance.getExternalConfiguration());
            this.withClientRackInitImage(instance.getClientRackInitImage());
            this.withRack(instance.getRack());
        }
    }

    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    public A withLogging(Logging logging) {
        if (logging == null) {
            this.logging = null;
            this._visitables.remove((Object)"logging");
            return (A)((Object)this);
        }
        VisitableBuilder builder = AbstractKafkaConnectSpecFluent.builder(logging);
        this._visitables.get((Object)"logging").clear();
        this._visitables.get((Object)"logging").add(builder);
        this.logging = builder;
        return (A)((Object)this);
    }

    public boolean hasLogging() {
        return this.logging != null;
    }

    public InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNested(null);
    }

    public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNested(item);
    }

    public ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNested(null);
    }

    public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNested(item);
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return true;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.remove((Object)"livenessProbe");
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.remove((Object)"readinessProbe");
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    public KafkaJmxOptions buildJmxOptions() {
        return this.jmxOptions != null ? this.jmxOptions.build() : null;
    }

    public A withJmxOptions(KafkaJmxOptions jmxOptions) {
        this._visitables.remove((Object)"jmxOptions");
        if (jmxOptions != null) {
            this.jmxOptions = new KafkaJmxOptionsBuilder(jmxOptions);
            this._visitables.get((Object)"jmxOptions").add(this.jmxOptions);
        } else {
            this.jmxOptions = null;
            this._visitables.get((Object)"jmxOptions").remove((Object)this.jmxOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasJmxOptions() {
        return this.jmxOptions != null;
    }

    public JmxOptionsNested<A> withNewJmxOptions() {
        return new JmxOptionsNested(null);
    }

    public JmxOptionsNested<A> withNewJmxOptionsLike(KafkaJmxOptions item) {
        return new JmxOptionsNested(item);
    }

    public JmxOptionsNested<A> editJmxOptions() {
        return this.withNewJmxOptionsLike(Optional.ofNullable(this.buildJmxOptions()).orElse(null));
    }

    public JmxOptionsNested<A> editOrNewJmxOptions() {
        return this.withNewJmxOptionsLike(Optional.ofNullable(this.buildJmxOptions()).orElse(new KafkaJmxOptionsBuilder().build()));
    }

    public JmxOptionsNested<A> editOrNewJmxOptionsLike(KafkaJmxOptions item) {
        return this.withNewJmxOptionsLike(Optional.ofNullable(this.buildJmxOptions()).orElse(item));
    }

    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.remove((Object)"jvmOptions");
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.get((Object)"jvmOptions").add(this.jvmOptions);
        } else {
            this.jvmOptions = null;
            this._visitables.get((Object)"jvmOptions").remove((Object)this.jvmOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNested(null);
    }

    public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNested(item);
    }

    public JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(null));
    }

    public JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
    }

    public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(item));
    }

    public MetricsConfig buildMetricsConfig() {
        return this.metricsConfig != null ? (MetricsConfig)this.metricsConfig.build() : null;
    }

    public A withMetricsConfig(MetricsConfig metricsConfig) {
        if (metricsConfig == null) {
            this.metricsConfig = null;
            this._visitables.remove((Object)"metricsConfig");
            return (A)((Object)this);
        }
        VisitableBuilder builder = AbstractKafkaConnectSpecFluent.builder(metricsConfig);
        this._visitables.get((Object)"metricsConfig").clear();
        this._visitables.get((Object)"metricsConfig").add(builder);
        this.metricsConfig = builder;
        return (A)((Object)this);
    }

    public boolean hasMetricsConfig() {
        return this.metricsConfig != null;
    }

    public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
        return new JmxPrometheusExporterMetricsConfigNested(null);
    }

    public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item) {
        return new JmxPrometheusExporterMetricsConfigNested(item);
    }

    public Tracing buildTracing() {
        return this.tracing != null ? (Tracing)this.tracing.build() : null;
    }

    public A withTracing(Tracing tracing) {
        if (tracing == null) {
            this.tracing = null;
            this._visitables.remove((Object)"tracing");
            return (A)((Object)this);
        }
        VisitableBuilder builder = AbstractKafkaConnectSpecFluent.builder(tracing);
        this._visitables.get((Object)"tracing").clear();
        this._visitables.get((Object)"tracing").add(builder);
        this.tracing = builder;
        return (A)((Object)this);
    }

    public boolean hasTracing() {
        return this.tracing != null;
    }

    public JaegerTracingNested<A> withNewJaegerTracing() {
        return new JaegerTracingNested(null);
    }

    public JaegerTracingNested<A> withNewJaegerTracingLike(JaegerTracing item) {
        return new JaegerTracingNested(item);
    }

    public OpenTelemetryTracingNested<A> withNewOpenTelemetryTracing() {
        return new OpenTelemetryTracingNested(null);
    }

    public OpenTelemetryTracingNested<A> withNewOpenTelemetryTracingLike(OpenTelemetryTracing item) {
        return new OpenTelemetryTracingNested(item);
    }

    public KafkaConnectTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(KafkaConnectTemplate template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new KafkaConnectTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(KafkaConnectTemplate item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new KafkaConnectTemplateBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(KafkaConnectTemplate item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public ExternalConfiguration buildExternalConfiguration() {
        return this.externalConfiguration != null ? this.externalConfiguration.build() : null;
    }

    public A withExternalConfiguration(ExternalConfiguration externalConfiguration) {
        this._visitables.remove((Object)"externalConfiguration");
        if (externalConfiguration != null) {
            this.externalConfiguration = new ExternalConfigurationBuilder(externalConfiguration);
            this._visitables.get((Object)"externalConfiguration").add(this.externalConfiguration);
        } else {
            this.externalConfiguration = null;
            this._visitables.get((Object)"externalConfiguration").remove((Object)this.externalConfiguration);
        }
        return (A)((Object)this);
    }

    public boolean hasExternalConfiguration() {
        return this.externalConfiguration != null;
    }

    public ExternalConfigurationNested<A> withNewExternalConfiguration() {
        return new ExternalConfigurationNested(null);
    }

    public ExternalConfigurationNested<A> withNewExternalConfigurationLike(ExternalConfiguration item) {
        return new ExternalConfigurationNested(item);
    }

    public ExternalConfigurationNested<A> editExternalConfiguration() {
        return this.withNewExternalConfigurationLike(Optional.ofNullable(this.buildExternalConfiguration()).orElse(null));
    }

    public ExternalConfigurationNested<A> editOrNewExternalConfiguration() {
        return this.withNewExternalConfigurationLike(Optional.ofNullable(this.buildExternalConfiguration()).orElse(new ExternalConfigurationBuilder().build()));
    }

    public ExternalConfigurationNested<A> editOrNewExternalConfigurationLike(ExternalConfiguration item) {
        return this.withNewExternalConfigurationLike(Optional.ofNullable(this.buildExternalConfiguration()).orElse(item));
    }

    public String getClientRackInitImage() {
        return this.clientRackInitImage;
    }

    public A withClientRackInitImage(String clientRackInitImage) {
        this.clientRackInitImage = clientRackInitImage;
        return (A)((Object)this);
    }

    public boolean hasClientRackInitImage() {
        return this.clientRackInitImage != null;
    }

    public Rack buildRack() {
        return this.rack != null ? this.rack.build() : null;
    }

    public A withRack(Rack rack) {
        this._visitables.remove((Object)"rack");
        if (rack != null) {
            this.rack = new RackBuilder(rack);
            this._visitables.get((Object)"rack").add(this.rack);
        } else {
            this.rack = null;
            this._visitables.get((Object)"rack").remove((Object)this.rack);
        }
        return (A)((Object)this);
    }

    public boolean hasRack() {
        return this.rack != null;
    }

    public A withNewRack(String topologyKey) {
        return this.withRack(new Rack(topologyKey));
    }

    public RackNested<A> withNewRack() {
        return new RackNested(null);
    }

    public RackNested<A> withNewRackLike(Rack item) {
        return new RackNested(item);
    }

    public RackNested<A> editRack() {
        return this.withNewRackLike(Optional.ofNullable(this.buildRack()).orElse(null));
    }

    public RackNested<A> editOrNewRack() {
        return this.withNewRackLike(Optional.ofNullable(this.buildRack()).orElse(new RackBuilder().build()));
    }

    public RackNested<A> editOrNewRackLike(Rack item) {
        return this.withNewRackLike(Optional.ofNullable(this.buildRack()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractKafkaConnectSpecFluent that = (AbstractKafkaConnectSpecFluent)((Object)o);
        if (!Objects.equals(this.logging, that.logging)) {
            return false;
        }
        if (this.replicas != that.replicas) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals((Object)this.livenessProbe, (Object)that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.readinessProbe, (Object)that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.jmxOptions, (Object)that.jmxOptions)) {
            return false;
        }
        if (!Objects.equals((Object)this.jvmOptions, (Object)that.jvmOptions)) {
            return false;
        }
        if (!Objects.equals(this.metricsConfig, that.metricsConfig)) {
            return false;
        }
        if (!Objects.equals(this.tracing, that.tracing)) {
            return false;
        }
        if (!Objects.equals((Object)this.template, (Object)that.template)) {
            return false;
        }
        if (!Objects.equals((Object)this.externalConfiguration, (Object)that.externalConfiguration)) {
            return false;
        }
        if (!Objects.equals(this.clientRackInitImage, that.clientRackInitImage)) {
            return false;
        }
        return Objects.equals((Object)this.rack, (Object)that.rack);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.logging, this.replicas, this.version, this.image, this.resources, this.livenessProbe, this.readinessProbe, this.jmxOptions, this.jvmOptions, this.metricsConfig, this.tracing, this.template, this.externalConfiguration, this.clientRackInitImage, this.rack, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logging != null) {
            sb.append("logging:");
            sb.append(this.logging + ",");
        }
        sb.append("replicas:");
        sb.append(this.replicas + ",");
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append(this.livenessProbe + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append(this.readinessProbe + ",");
        }
        if (this.jmxOptions != null) {
            sb.append("jmxOptions:");
            sb.append(this.jmxOptions + ",");
        }
        if (this.jvmOptions != null) {
            sb.append("jvmOptions:");
            sb.append(this.jvmOptions + ",");
        }
        if (this.metricsConfig != null) {
            sb.append("metricsConfig:");
            sb.append(this.metricsConfig + ",");
        }
        if (this.tracing != null) {
            sb.append("tracing:");
            sb.append(this.tracing + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.externalConfiguration != null) {
            sb.append("externalConfiguration:");
            sb.append(this.externalConfiguration + ",");
        }
        if (this.clientRackInitImage != null) {
            sb.append("clientRackInitImage:");
            sb.append(this.clientRackInitImage + ",");
        }
        if (this.rack != null) {
            sb.append("rack:");
            sb.append((Object)this.rack);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.common.InlineLogging": {
                return new InlineLoggingBuilder((InlineLogging)item);
            }
            case "io.strimzi.api.kafka.model.common.ExternalLogging": {
                return new ExternalLoggingBuilder((ExternalLogging)item);
            }
            case "io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetrics": {
                return new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics)item);
            }
            case "io.strimzi.api.kafka.model.common.tracing.JaegerTracing": {
                return new JaegerTracingBuilder((JaegerTracing)item);
            }
            case "io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracing": {
                return new OpenTelemetryTracingBuilder((OpenTelemetryTracing)item);
            }
        }
        return AbstractKafkaConnectSpecFluent.builderOf((Object)item);
    }

    public class InlineLoggingNested<N>
    extends InlineLoggingFluent<InlineLoggingNested<N>>
    implements Nested<N> {
        InlineLoggingBuilder builder;

        InlineLoggingNested(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        public N and() {
            return (N)AbstractKafkaConnectSpecFluent.this.withLogging(this.builder.build());
        }

        public N endInlineLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingNested<N>
    extends ExternalLoggingFluent<ExternalLoggingNested<N>>
    implements Nested<N> {
        ExternalLoggingBuilder builder;

        ExternalLoggingNested(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        public N and() {
            return (N)AbstractKafkaConnectSpecFluent.this.withLogging(this.builder.build());
        }

        public N endExternalLogging() {
            return this.and();
        }
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)AbstractKafkaConnectSpecFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)AbstractKafkaConnectSpecFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class JmxOptionsNested<N>
    extends KafkaJmxOptionsFluent<JmxOptionsNested<N>>
    implements Nested<N> {
        KafkaJmxOptionsBuilder builder;

        JmxOptionsNested(KafkaJmxOptions item) {
            this.builder = new KafkaJmxOptionsBuilder(this, item);
        }

        public N and() {
            return (N)AbstractKafkaConnectSpecFluent.this.withJmxOptions(this.builder.build());
        }

        public N endJmxOptions() {
            return this.and();
        }
    }

    public class JvmOptionsNested<N>
    extends JvmOptionsFluent<JvmOptionsNested<N>>
    implements Nested<N> {
        JvmOptionsBuilder builder;

        JvmOptionsNested(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        public N and() {
            return (N)AbstractKafkaConnectSpecFluent.this.withJvmOptions(this.builder.build());
        }

        public N endJvmOptions() {
            return this.and();
        }
    }

    public class JmxPrometheusExporterMetricsConfigNested<N>
    extends JmxPrometheusExporterMetricsFluent<JmxPrometheusExporterMetricsConfigNested<N>>
    implements Nested<N> {
        JmxPrometheusExporterMetricsBuilder builder;

        JmxPrometheusExporterMetricsConfigNested(JmxPrometheusExporterMetrics item) {
            this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
        }

        public N and() {
            return (N)AbstractKafkaConnectSpecFluent.this.withMetricsConfig(this.builder.build());
        }

        public N endJmxPrometheusExporterMetricsConfig() {
            return this.and();
        }
    }

    public class JaegerTracingNested<N>
    extends JaegerTracingFluent<JaegerTracingNested<N>>
    implements Nested<N> {
        JaegerTracingBuilder builder;

        JaegerTracingNested(JaegerTracing item) {
            this.builder = new JaegerTracingBuilder(this, item);
        }

        public N and() {
            return (N)AbstractKafkaConnectSpecFluent.this.withTracing(this.builder.build());
        }

        public N endJaegerTracing() {
            return this.and();
        }
    }

    public class OpenTelemetryTracingNested<N>
    extends OpenTelemetryTracingFluent<OpenTelemetryTracingNested<N>>
    implements Nested<N> {
        OpenTelemetryTracingBuilder builder;

        OpenTelemetryTracingNested(OpenTelemetryTracing item) {
            this.builder = new OpenTelemetryTracingBuilder(this, item);
        }

        public N and() {
            return (N)AbstractKafkaConnectSpecFluent.this.withTracing(this.builder.build());
        }

        public N endOpenTelemetryTracing() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends KafkaConnectTemplateFluent<TemplateNested<N>>
    implements Nested<N> {
        KafkaConnectTemplateBuilder builder;

        TemplateNested(KafkaConnectTemplate item) {
            this.builder = new KafkaConnectTemplateBuilder(this, item);
        }

        public N and() {
            return (N)AbstractKafkaConnectSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class ExternalConfigurationNested<N>
    extends ExternalConfigurationFluent<ExternalConfigurationNested<N>>
    implements Nested<N> {
        ExternalConfigurationBuilder builder;

        ExternalConfigurationNested(ExternalConfiguration item) {
            this.builder = new ExternalConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)AbstractKafkaConnectSpecFluent.this.withExternalConfiguration(this.builder.build());
        }

        public N endExternalConfiguration() {
            return this.and();
        }
    }

    public class RackNested<N>
    extends RackFluent<RackNested<N>>
    implements Nested<N> {
        RackBuilder builder;

        RackNested(Rack item) {
            this.builder = new RackBuilder(this, item);
        }

        public N and() {
            return (N)AbstractKafkaConnectSpecFluent.this.withRack(this.builder.build());
        }

        public N endRack() {
            return this.and();
        }
    }
}

