/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.connect.ExternalConfiguration;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvFluent;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ExternalConfigurationFluent<A extends ExternalConfigurationFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ExternalConfigurationEnvBuilder> env;
    private ArrayList<ExternalConfigurationVolumeSourceBuilder> volumes;

    public ExternalConfigurationFluent() {
    }

    public ExternalConfigurationFluent(ExternalConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ExternalConfiguration instance) {
        ExternalConfiguration externalConfiguration = instance = instance != null ? instance : new ExternalConfiguration();
        if (instance != null) {
            this.withEnv(instance.getEnv());
            this.withVolumes(instance.getVolumes());
        }
    }

    public A addToEnv(int index, ExternalConfigurationEnv item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(index, builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnv(int index, ExternalConfigurationEnv item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").set(index, builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(ExternalConfigurationEnv ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (ExternalConfigurationEnv item : items) {
            ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnv(Collection<ExternalConfigurationEnv> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (ExternalConfigurationEnv item : items) {
            ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(ExternalConfigurationEnv ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (ExternalConfigurationEnv item : items) {
            ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnv(Collection<ExternalConfigurationEnv> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (ExternalConfigurationEnv item : items) {
            ExternalConfigurationEnvBuilder builder = new ExternalConfigurationEnvBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnv(Predicate<ExternalConfigurationEnvBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<ExternalConfigurationEnvBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            ExternalConfigurationEnvBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ExternalConfigurationEnv> buildEnv() {
        return this.env != null ? ExternalConfigurationFluent.build(this.env) : null;
    }

    public ExternalConfigurationEnv buildEnv(int index) {
        return this.env.get(index).build();
    }

    public ExternalConfigurationEnv buildFirstEnv() {
        return this.env.get(0).build();
    }

    public ExternalConfigurationEnv buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public ExternalConfigurationEnv buildMatchingEnv(Predicate<ExternalConfigurationEnvBuilder> predicate) {
        for (ExternalConfigurationEnvBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<ExternalConfigurationEnvBuilder> predicate) {
        for (ExternalConfigurationEnvBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<ExternalConfigurationEnv> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (ExternalConfigurationEnv item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(ExternalConfigurationEnv ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (ExternalConfigurationEnv item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(ExternalConfigurationEnv item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, ExternalConfigurationEnv item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<ExternalConfigurationEnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public A addToVolumes(int index, ExternalConfigurationVolumeSource item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").add(index, builder);
            this.volumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumes(int index, ExternalConfigurationVolumeSource item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
            this.volumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumes(ExternalConfigurationVolumeSource ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (ExternalConfigurationVolumeSource item : items) {
            ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumes(Collection<ExternalConfigurationVolumeSource> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (ExternalConfigurationVolumeSource item : items) {
            ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumes(ExternalConfigurationVolumeSource ... items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (ExternalConfigurationVolumeSource item : items) {
            ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);
            this._visitables.get((Object)"volumes").remove((Object)builder);
            this.volumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumes(Collection<ExternalConfigurationVolumeSource> items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (ExternalConfigurationVolumeSource item : items) {
            ExternalConfigurationVolumeSourceBuilder builder = new ExternalConfigurationVolumeSourceBuilder(item);
            this._visitables.get((Object)"volumes").remove((Object)builder);
            this.volumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumes(Predicate<ExternalConfigurationVolumeSourceBuilder> predicate) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        Iterator<ExternalConfigurationVolumeSourceBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            ExternalConfigurationVolumeSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ExternalConfigurationVolumeSource> buildVolumes() {
        return this.volumes != null ? ExternalConfigurationFluent.build(this.volumes) : null;
    }

    public ExternalConfigurationVolumeSource buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public ExternalConfigurationVolumeSource buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public ExternalConfigurationVolumeSource buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    public ExternalConfigurationVolumeSource buildMatchingVolume(Predicate<ExternalConfigurationVolumeSourceBuilder> predicate) {
        for (ExternalConfigurationVolumeSourceBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<ExternalConfigurationVolumeSourceBuilder> predicate) {
        for (ExternalConfigurationVolumeSourceBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<ExternalConfigurationVolumeSource> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").clear();
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (ExternalConfigurationVolumeSource item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)((Object)this);
    }

    public A withVolumes(ExternalConfigurationVolumeSource ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove((Object)"volumes");
        }
        if (volumes != null) {
            for (ExternalConfigurationVolumeSource item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public VolumesNested<A> addNewVolume() {
        return new VolumesNested(-1, null);
    }

    public VolumesNested<A> addNewVolumeLike(ExternalConfigurationVolumeSource item) {
        return new VolumesNested(-1, item);
    }

    public VolumesNested<A> setNewVolumeLike(int index, ExternalConfigurationVolumeSource item) {
        return new VolumesNested(index, item);
    }

    public VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    public VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editMatchingVolume(Predicate<ExternalConfigurationVolumeSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalConfigurationFluent that = (ExternalConfigurationFluent)((Object)o);
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        return Objects.equals(this.volumes, that.volumes);
    }

    public int hashCode() {
        return Objects.hash(this.env, this.volumes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EnvNested<N>
    extends ExternalConfigurationEnvFluent<EnvNested<N>>
    implements Nested<N> {
        ExternalConfigurationEnvBuilder builder;
        int index;

        EnvNested(int index, ExternalConfigurationEnv item) {
            this.index = index;
            this.builder = new ExternalConfigurationEnvBuilder(this, item);
        }

        public N and() {
            return (N)ExternalConfigurationFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endEnv() {
            return this.and();
        }
    }

    public class VolumesNested<N>
    extends ExternalConfigurationVolumeSourceFluent<VolumesNested<N>>
    implements Nested<N> {
        ExternalConfigurationVolumeSourceBuilder builder;
        int index;

        VolumesNested(int index, ExternalConfigurationVolumeSource item) {
            this.index = index;
            this.builder = new ExternalConfigurationVolumeSourceBuilder(this, item);
        }

        public N and() {
            return (N)ExternalConfigurationFluent.this.setToVolumes(this.index, this.builder.build());
        }

        public N endVolume() {
            return this.and();
        }
    }
}

