/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"name", "secret", "configMap"})
public class ExternalConfigurationVolumeSource
implements UnknownPropertyPreserving {
    private String name;
    private SecretVolumeSource secret;
    private ConfigMapVolumeSource configMap;
    private Map<String, Object> additionalProperties;

    @Description(value="Name of the volume which will be added to the Kafka Connect pods.")
    @JsonProperty(required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Description(value="Reference to a key in a Secret. Exactly one Secret or ConfigMap has to be specified.")
    @KubeLink(group="core", version="v1", kind="secretvolumesource")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SecretVolumeSource getSecret() {
        return this.secret;
    }

    public void setSecret(SecretVolumeSource secret) {
        this.secret = secret;
    }

    @Description(value="Reference to a key in a ConfigMap. Exactly one Secret or ConfigMap has to be specified.")
    @KubeLink(group="core", version="v1", kind="configmapvolumesource")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ConfigMapVolumeSource getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(ConfigMapVolumeSource configMap) {
        this.configMap = configMap;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalConfigurationVolumeSource)) {
            return false;
        }
        ExternalConfigurationVolumeSource other = (ExternalConfigurationVolumeSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        SecretVolumeSource this$secret = this.getSecret();
        SecretVolumeSource other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        ConfigMapVolumeSource this$configMap = this.getConfigMap();
        ConfigMapVolumeSource other$configMap = other.getConfigMap();
        if (this$configMap == null ? other$configMap != null : !this$configMap.equals(other$configMap)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExternalConfigurationVolumeSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        SecretVolumeSource $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        ConfigMapVolumeSource $configMap = this.getConfigMap();
        result = result * 59 + ($configMap == null ? 43 : $configMap.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "ExternalConfigurationVolumeSource(name=" + this.getName() + ", secret=" + this.getSecret() + ", configMap=" + this.getConfigMap() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }
}

