/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.connect.ConnectorPlugin;
import io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder;
import io.strimzi.api.kafka.model.connect.ConnectorPluginFluent;
import io.strimzi.api.kafka.model.connect.KafkaConnectStatus;
import io.strimzi.api.kafka.model.kafka.StatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaConnectStatusFluent<A extends KafkaConnectStatusFluent<A>>
extends StatusFluent<A> {
    private String url;
    private ArrayList<ConnectorPluginBuilder> connectorPlugins;
    private int replicas;
    private String labelSelector;

    public KafkaConnectStatusFluent() {
    }

    public KafkaConnectStatusFluent(KafkaConnectStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaConnectStatus instance) {
        KafkaConnectStatus kafkaConnectStatus = instance = instance != null ? instance : new KafkaConnectStatus();
        if (instance != null) {
            this.withUrl(instance.getUrl());
            this.withConnectorPlugins(instance.getConnectorPlugins());
            this.withReplicas(instance.getReplicas());
            this.withLabelSelector(instance.getLabelSelector());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public A addToConnectorPlugins(int index, ConnectorPlugin item) {
        if (this.connectorPlugins == null) {
            this.connectorPlugins = new ArrayList();
        }
        ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
        if (index < 0 || index >= this.connectorPlugins.size()) {
            this._visitables.get((Object)"connectorPlugins").add(builder);
            this.connectorPlugins.add(builder);
        } else {
            this._visitables.get((Object)"connectorPlugins").add(index, builder);
            this.connectorPlugins.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConnectorPlugins(int index, ConnectorPlugin item) {
        if (this.connectorPlugins == null) {
            this.connectorPlugins = new ArrayList();
        }
        ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
        if (index < 0 || index >= this.connectorPlugins.size()) {
            this._visitables.get((Object)"connectorPlugins").add(builder);
            this.connectorPlugins.add(builder);
        } else {
            this._visitables.get((Object)"connectorPlugins").set(index, builder);
            this.connectorPlugins.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConnectorPlugins(ConnectorPlugin ... items) {
        if (this.connectorPlugins == null) {
            this.connectorPlugins = new ArrayList();
        }
        for (ConnectorPlugin item : items) {
            ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
            this._visitables.get((Object)"connectorPlugins").add(builder);
            this.connectorPlugins.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConnectorPlugins(Collection<ConnectorPlugin> items) {
        if (this.connectorPlugins == null) {
            this.connectorPlugins = new ArrayList();
        }
        for (ConnectorPlugin item : items) {
            ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
            this._visitables.get((Object)"connectorPlugins").add(builder);
            this.connectorPlugins.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConnectorPlugins(ConnectorPlugin ... items) {
        if (this.connectorPlugins == null) {
            return (A)((Object)this);
        }
        for (ConnectorPlugin item : items) {
            ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
            this._visitables.get((Object)"connectorPlugins").remove((Object)builder);
            this.connectorPlugins.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConnectorPlugins(Collection<ConnectorPlugin> items) {
        if (this.connectorPlugins == null) {
            return (A)((Object)this);
        }
        for (ConnectorPlugin item : items) {
            ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
            this._visitables.get((Object)"connectorPlugins").remove((Object)builder);
            this.connectorPlugins.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConnectorPlugins(Predicate<ConnectorPluginBuilder> predicate) {
        if (this.connectorPlugins == null) {
            return (A)((Object)this);
        }
        Iterator<ConnectorPluginBuilder> each = this.connectorPlugins.iterator();
        List visitables = this._visitables.get((Object)"connectorPlugins");
        while (each.hasNext()) {
            ConnectorPluginBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ConnectorPlugin> buildConnectorPlugins() {
        return this.connectorPlugins != null ? KafkaConnectStatusFluent.build(this.connectorPlugins) : null;
    }

    public ConnectorPlugin buildConnectorPlugin(int index) {
        return this.connectorPlugins.get(index).build();
    }

    public ConnectorPlugin buildFirstConnectorPlugin() {
        return this.connectorPlugins.get(0).build();
    }

    public ConnectorPlugin buildLastConnectorPlugin() {
        return this.connectorPlugins.get(this.connectorPlugins.size() - 1).build();
    }

    public ConnectorPlugin buildMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate) {
        for (ConnectorPluginBuilder item : this.connectorPlugins) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate) {
        for (ConnectorPluginBuilder item : this.connectorPlugins) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConnectorPlugins(List<ConnectorPlugin> connectorPlugins) {
        if (this.connectorPlugins != null) {
            this._visitables.get((Object)"connectorPlugins").clear();
        }
        if (connectorPlugins != null) {
            this.connectorPlugins = new ArrayList();
            for (ConnectorPlugin item : connectorPlugins) {
                this.addToConnectorPlugins(item);
            }
        } else {
            this.connectorPlugins = null;
        }
        return (A)((Object)this);
    }

    public A withConnectorPlugins(ConnectorPlugin ... connectorPlugins) {
        if (this.connectorPlugins != null) {
            this.connectorPlugins.clear();
            this._visitables.remove((Object)"connectorPlugins");
        }
        if (connectorPlugins != null) {
            for (ConnectorPlugin item : connectorPlugins) {
                this.addToConnectorPlugins(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConnectorPlugins() {
        return this.connectorPlugins != null && !this.connectorPlugins.isEmpty();
    }

    public ConnectorPluginsNested<A> addNewConnectorPlugin() {
        return new ConnectorPluginsNested(-1, null);
    }

    public ConnectorPluginsNested<A> addNewConnectorPluginLike(ConnectorPlugin item) {
        return new ConnectorPluginsNested(-1, item);
    }

    public ConnectorPluginsNested<A> setNewConnectorPluginLike(int index, ConnectorPlugin item) {
        return new ConnectorPluginsNested(index, item);
    }

    public ConnectorPluginsNested<A> editConnectorPlugin(int index) {
        if (this.connectorPlugins.size() <= index) {
            throw new RuntimeException("Can't edit connectorPlugins. Index exceeds size.");
        }
        return this.setNewConnectorPluginLike(index, this.buildConnectorPlugin(index));
    }

    public ConnectorPluginsNested<A> editFirstConnectorPlugin() {
        if (this.connectorPlugins.size() == 0) {
            throw new RuntimeException("Can't edit first connectorPlugins. The list is empty.");
        }
        return this.setNewConnectorPluginLike(0, this.buildConnectorPlugin(0));
    }

    public ConnectorPluginsNested<A> editLastConnectorPlugin() {
        int index = this.connectorPlugins.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last connectorPlugins. The list is empty.");
        }
        return this.setNewConnectorPluginLike(index, this.buildConnectorPlugin(index));
    }

    public ConnectorPluginsNested<A> editMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.connectorPlugins.size(); ++i) {
            if (!predicate.test(this.connectorPlugins.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching connectorPlugins. No match found.");
        }
        return this.setNewConnectorPluginLike(index, this.buildConnectorPlugin(index));
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return true;
    }

    public String getLabelSelector() {
        return this.labelSelector;
    }

    public A withLabelSelector(String labelSelector) {
        this.labelSelector = labelSelector;
        return (A)((Object)this);
    }

    public boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConnectStatusFluent that = (KafkaConnectStatusFluent)((Object)o);
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.connectorPlugins, that.connectorPlugins)) {
            return false;
        }
        if (this.replicas != that.replicas) {
            return false;
        }
        return Objects.equals(this.labelSelector, that.labelSelector);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.url, this.connectorPlugins, this.replicas, this.labelSelector, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.connectorPlugins != null && !this.connectorPlugins.isEmpty()) {
            sb.append("connectorPlugins:");
            sb.append(this.connectorPlugins + ",");
        }
        sb.append("replicas:");
        sb.append(this.replicas + ",");
        if (this.labelSelector != null) {
            sb.append("labelSelector:");
            sb.append(this.labelSelector);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConnectorPluginsNested<N>
    extends ConnectorPluginFluent<ConnectorPluginsNested<N>>
    implements Nested<N> {
        ConnectorPluginBuilder builder;
        int index;

        ConnectorPluginsNested(int index, ConnectorPlugin item) {
            this.index = index;
            this.builder = new ConnectorPluginBuilder(this, item);
        }

        public N and() {
            return (N)KafkaConnectStatusFluent.this.setToConnectorPlugins(this.index, this.builder.build());
        }

        public N endConnectorPlugin() {
            return this.and();
        }
    }
}

