/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.connect.build.Build;
import io.strimzi.api.kafka.model.connect.build.DockerOutput;
import io.strimzi.api.kafka.model.connect.build.DockerOutputBuilder;
import io.strimzi.api.kafka.model.connect.build.DockerOutputFluent;
import io.strimzi.api.kafka.model.connect.build.ImageStreamOutput;
import io.strimzi.api.kafka.model.connect.build.ImageStreamOutputBuilder;
import io.strimzi.api.kafka.model.connect.build.ImageStreamOutputFluent;
import io.strimzi.api.kafka.model.connect.build.Output;
import io.strimzi.api.kafka.model.connect.build.Plugin;
import io.strimzi.api.kafka.model.connect.build.PluginBuilder;
import io.strimzi.api.kafka.model.connect.build.PluginFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class BuildFluent<A extends BuildFluent<A>>
extends BaseFluent<A> {
    private VisitableBuilder<? extends Output, ?> output;
    private ArrayList<PluginBuilder> plugins;
    private ResourceRequirements resources;

    public BuildFluent() {
    }

    public BuildFluent(Build instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Build instance) {
        Build build = instance = instance != null ? instance : new Build();
        if (instance != null) {
            this.withOutput(instance.getOutput());
            this.withPlugins(instance.getPlugins());
            this.withResources(instance.getResources());
        }
    }

    public Output buildOutput() {
        return this.output != null ? (Output)this.output.build() : null;
    }

    public A withOutput(Output output) {
        if (output == null) {
            this.output = null;
            this._visitables.remove((Object)"output");
            return (A)((Object)this);
        }
        VisitableBuilder builder = BuildFluent.builder(output);
        this._visitables.get((Object)"output").clear();
        this._visitables.get((Object)"output").add(builder);
        this.output = builder;
        return (A)((Object)this);
    }

    public boolean hasOutput() {
        return this.output != null;
    }

    public ImageStreamOutputNested<A> withNewImageStreamOutput() {
        return new ImageStreamOutputNested(null);
    }

    public ImageStreamOutputNested<A> withNewImageStreamOutputLike(ImageStreamOutput item) {
        return new ImageStreamOutputNested(item);
    }

    public DockerOutputNested<A> withNewDockerOutput() {
        return new DockerOutputNested(null);
    }

    public DockerOutputNested<A> withNewDockerOutputLike(DockerOutput item) {
        return new DockerOutputNested(item);
    }

    public A addToPlugins(int index, Plugin item) {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        PluginBuilder builder = new PluginBuilder(item);
        if (index < 0 || index >= this.plugins.size()) {
            this._visitables.get((Object)"plugins").add(builder);
            this.plugins.add(builder);
        } else {
            this._visitables.get((Object)"plugins").add(index, builder);
            this.plugins.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPlugins(int index, Plugin item) {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        PluginBuilder builder = new PluginBuilder(item);
        if (index < 0 || index >= this.plugins.size()) {
            this._visitables.get((Object)"plugins").add(builder);
            this.plugins.add(builder);
        } else {
            this._visitables.get((Object)"plugins").set(index, builder);
            this.plugins.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPlugins(Plugin ... items) {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        for (Plugin item : items) {
            PluginBuilder builder = new PluginBuilder(item);
            this._visitables.get((Object)"plugins").add(builder);
            this.plugins.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPlugins(Collection<Plugin> items) {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        for (Plugin item : items) {
            PluginBuilder builder = new PluginBuilder(item);
            this._visitables.get((Object)"plugins").add(builder);
            this.plugins.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPlugins(Plugin ... items) {
        if (this.plugins == null) {
            return (A)((Object)this);
        }
        for (Plugin item : items) {
            PluginBuilder builder = new PluginBuilder(item);
            this._visitables.get((Object)"plugins").remove((Object)builder);
            this.plugins.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPlugins(Collection<Plugin> items) {
        if (this.plugins == null) {
            return (A)((Object)this);
        }
        for (Plugin item : items) {
            PluginBuilder builder = new PluginBuilder(item);
            this._visitables.get((Object)"plugins").remove((Object)builder);
            this.plugins.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPlugins(Predicate<PluginBuilder> predicate) {
        if (this.plugins == null) {
            return (A)((Object)this);
        }
        Iterator<PluginBuilder> each = this.plugins.iterator();
        List visitables = this._visitables.get((Object)"plugins");
        while (each.hasNext()) {
            PluginBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Plugin> buildPlugins() {
        return this.plugins != null ? BuildFluent.build(this.plugins) : null;
    }

    public Plugin buildPlugin(int index) {
        return this.plugins.get(index).build();
    }

    public Plugin buildFirstPlugin() {
        return this.plugins.get(0).build();
    }

    public Plugin buildLastPlugin() {
        return this.plugins.get(this.plugins.size() - 1).build();
    }

    public Plugin buildMatchingPlugin(Predicate<PluginBuilder> predicate) {
        for (PluginBuilder item : this.plugins) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPlugin(Predicate<PluginBuilder> predicate) {
        for (PluginBuilder item : this.plugins) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPlugins(List<Plugin> plugins) {
        if (this.plugins != null) {
            this._visitables.get((Object)"plugins").clear();
        }
        if (plugins != null) {
            this.plugins = new ArrayList();
            for (Plugin item : plugins) {
                this.addToPlugins(item);
            }
        } else {
            this.plugins = null;
        }
        return (A)((Object)this);
    }

    public A withPlugins(Plugin ... plugins) {
        if (this.plugins != null) {
            this.plugins.clear();
            this._visitables.remove((Object)"plugins");
        }
        if (plugins != null) {
            for (Plugin item : plugins) {
                this.addToPlugins(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPlugins() {
        return this.plugins != null && !this.plugins.isEmpty();
    }

    public PluginsNested<A> addNewPlugin() {
        return new PluginsNested(-1, null);
    }

    public PluginsNested<A> addNewPluginLike(Plugin item) {
        return new PluginsNested(-1, item);
    }

    public PluginsNested<A> setNewPluginLike(int index, Plugin item) {
        return new PluginsNested(index, item);
    }

    public PluginsNested<A> editPlugin(int index) {
        if (this.plugins.size() <= index) {
            throw new RuntimeException("Can't edit plugins. Index exceeds size.");
        }
        return this.setNewPluginLike(index, this.buildPlugin(index));
    }

    public PluginsNested<A> editFirstPlugin() {
        if (this.plugins.size() == 0) {
            throw new RuntimeException("Can't edit first plugins. The list is empty.");
        }
        return this.setNewPluginLike(0, this.buildPlugin(0));
    }

    public PluginsNested<A> editLastPlugin() {
        int index = this.plugins.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last plugins. The list is empty.");
        }
        return this.setNewPluginLike(index, this.buildPlugin(index));
    }

    public PluginsNested<A> editMatchingPlugin(Predicate<PluginBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.plugins.size(); ++i) {
            if (!predicate.test(this.plugins.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching plugins. No match found.");
        }
        return this.setNewPluginLike(index, this.buildPlugin(index));
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildFluent that = (BuildFluent)((Object)o);
        if (!Objects.equals(this.output, that.output)) {
            return false;
        }
        if (!Objects.equals(this.plugins, that.plugins)) {
            return false;
        }
        return Objects.equals(this.resources, that.resources);
    }

    public int hashCode() {
        return Objects.hash(this.output, this.plugins, this.resources, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.output != null) {
            sb.append("output:");
            sb.append(this.output + ",");
        }
        if (this.plugins != null && !this.plugins.isEmpty()) {
            sb.append("plugins:");
            sb.append(this.plugins + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.connect.build.ImageStreamOutput": {
                return new ImageStreamOutputBuilder((ImageStreamOutput)item);
            }
            case "io.strimzi.api.kafka.model.connect.build.DockerOutput": {
                return new DockerOutputBuilder((DockerOutput)item);
            }
        }
        return BuildFluent.builderOf((Object)item);
    }

    public class ImageStreamOutputNested<N>
    extends ImageStreamOutputFluent<ImageStreamOutputNested<N>>
    implements Nested<N> {
        ImageStreamOutputBuilder builder;

        ImageStreamOutputNested(ImageStreamOutput item) {
            this.builder = new ImageStreamOutputBuilder(this, item);
        }

        public N and() {
            return (N)BuildFluent.this.withOutput(this.builder.build());
        }

        public N endImageStreamOutput() {
            return this.and();
        }
    }

    public class DockerOutputNested<N>
    extends DockerOutputFluent<DockerOutputNested<N>>
    implements Nested<N> {
        DockerOutputBuilder builder;

        DockerOutputNested(DockerOutput item) {
            this.builder = new DockerOutputBuilder(this, item);
        }

        public N and() {
            return (N)BuildFluent.this.withOutput(this.builder.build());
        }

        public N endDockerOutput() {
            return this.and();
        }
    }

    public class PluginsNested<N>
    extends PluginFluent<PluginsNested<N>>
    implements Nested<N> {
        PluginBuilder builder;
        int index;

        PluginsNested(int index, Plugin item) {
            this.index = index;
            this.builder = new PluginBuilder(this, item);
        }

        public N and() {
            return (N)BuildFluent.this.setToPlugins(this.index, this.builder.build());
        }

        public N endPlugin() {
            return this.and();
        }
    }
}

