/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.connect.build.Artifact;
import io.strimzi.api.kafka.model.connect.build.JarArtifact;
import io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder;
import io.strimzi.api.kafka.model.connect.build.JarArtifactFluent;
import io.strimzi.api.kafka.model.connect.build.MavenArtifact;
import io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder;
import io.strimzi.api.kafka.model.connect.build.MavenArtifactFluent;
import io.strimzi.api.kafka.model.connect.build.OtherArtifact;
import io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder;
import io.strimzi.api.kafka.model.connect.build.OtherArtifactFluent;
import io.strimzi.api.kafka.model.connect.build.Plugin;
import io.strimzi.api.kafka.model.connect.build.TgzArtifact;
import io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder;
import io.strimzi.api.kafka.model.connect.build.TgzArtifactFluent;
import io.strimzi.api.kafka.model.connect.build.ZipArtifact;
import io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder;
import io.strimzi.api.kafka.model.connect.build.ZipArtifactFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PluginFluent<A extends PluginFluent<A>>
extends BaseFluent<A> {
    private String name;
    private ArrayList<VisitableBuilder<? extends Artifact, ?>> artifacts;

    public PluginFluent() {
    }

    public PluginFluent(Plugin instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Plugin instance) {
        Plugin plugin = instance = instance != null ? instance : new Plugin();
        if (instance != null) {
            this.withName(instance.getName());
            this.withArtifacts(instance.getArtifacts());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToArtifacts(VisitableBuilder<? extends Artifact, ?> builder) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        this._visitables.get((Object)"artifacts").add(builder);
        this.artifacts.add(builder);
        return (A)((Object)this);
    }

    public A addToArtifacts(int index, VisitableBuilder<? extends Artifact, ?> builder) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        if (index < 0 || index >= this.artifacts.size()) {
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        } else {
            this._visitables.get((Object)"artifacts").add(index, builder);
            this.artifacts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToArtifacts(int index, Artifact item) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        VisitableBuilder builder = PluginFluent.builder(item);
        if (index < 0 || index >= this.artifacts.size()) {
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        } else {
            this._visitables.get((Object)"artifacts").add(index, builder);
            this.artifacts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToArtifacts(int index, Artifact item) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        VisitableBuilder builder = PluginFluent.builder(item);
        if (index < 0 || index >= this.artifacts.size()) {
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        } else {
            this._visitables.get((Object)"artifacts").set(index, builder);
            this.artifacts.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToArtifacts(Artifact ... items) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        for (Artifact item : items) {
            VisitableBuilder builder = PluginFluent.builder(item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToArtifacts(Collection<Artifact> items) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        for (Artifact item : items) {
            VisitableBuilder builder = PluginFluent.builder(item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromArtifacts(VisitableBuilder<? extends Artifact, ?> builder) {
        if (this.artifacts == null) {
            return (A)((Object)this);
        }
        this._visitables.get((Object)"artifacts").remove(builder);
        this.artifacts.remove(builder);
        return (A)((Object)this);
    }

    public A removeFromArtifacts(Artifact ... items) {
        if (this.artifacts == null) {
            return (A)((Object)this);
        }
        for (Artifact item : items) {
            VisitableBuilder builder = PluginFluent.builder(item);
            this._visitables.get((Object)"artifacts").remove(builder);
            this.artifacts.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromArtifacts(Collection<Artifact> items) {
        if (this.artifacts == null) {
            return (A)((Object)this);
        }
        for (Artifact item : items) {
            VisitableBuilder builder = PluginFluent.builder(item);
            this._visitables.get((Object)"artifacts").remove(builder);
            this.artifacts.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromArtifacts(Predicate<VisitableBuilder<? extends Artifact, ?>> predicate) {
        if (this.artifacts == null) {
            return (A)((Object)this);
        }
        Iterator<VisitableBuilder<Artifact, ?>> each = this.artifacts.iterator();
        List visitables = this._visitables.get((Object)"artifacts");
        while (each.hasNext()) {
            VisitableBuilder<? extends Artifact, ?> builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Artifact> buildArtifacts() {
        return PluginFluent.build(this.artifacts);
    }

    public Artifact buildArtifact(int index) {
        return (Artifact)this.artifacts.get(index).build();
    }

    public Artifact buildFirstArtifact() {
        return (Artifact)this.artifacts.get(0).build();
    }

    public Artifact buildLastArtifact() {
        return (Artifact)this.artifacts.get(this.artifacts.size() - 1).build();
    }

    public Artifact buildMatchingArtifact(Predicate<VisitableBuilder<? extends Artifact, ?>> predicate) {
        for (VisitableBuilder<? extends Artifact, ?> visitableBuilder : this.artifacts) {
            if (!predicate.test(visitableBuilder)) continue;
            return (Artifact)visitableBuilder.build();
        }
        return null;
    }

    public boolean hasMatchingArtifact(Predicate<VisitableBuilder<? extends Artifact, ?>> predicate) {
        for (VisitableBuilder<? extends Artifact, ?> visitableBuilder : this.artifacts) {
            if (!predicate.test(visitableBuilder)) continue;
            return true;
        }
        return false;
    }

    public A withArtifacts(List<Artifact> artifacts) {
        if (artifacts != null) {
            this.artifacts = new ArrayList();
            for (Artifact item : artifacts) {
                this.addToArtifacts(item);
            }
        } else {
            this.artifacts = null;
        }
        return (A)((Object)this);
    }

    public A withArtifacts(Artifact ... artifacts) {
        if (this.artifacts != null) {
            this.artifacts.clear();
            this._visitables.remove((Object)"artifacts");
        }
        if (artifacts != null) {
            for (Artifact item : artifacts) {
                this.addToArtifacts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasArtifacts() {
        return this.artifacts != null && !this.artifacts.isEmpty();
    }

    public MavenArtifactArtifactsNested<A> addNewMavenArtifactArtifact() {
        return new MavenArtifactArtifactsNested(-1, null);
    }

    public MavenArtifactArtifactsNested<A> addNewMavenArtifactArtifactLike(MavenArtifact item) {
        return new MavenArtifactArtifactsNested(-1, item);
    }

    public MavenArtifactArtifactsNested<A> setNewMavenArtifactArtifactLike(int index, MavenArtifact item) {
        return new MavenArtifactArtifactsNested(index, item);
    }

    public ZipArtifactArtifactsNested<A> addNewZipArtifactArtifact() {
        return new ZipArtifactArtifactsNested(-1, null);
    }

    public ZipArtifactArtifactsNested<A> addNewZipArtifactArtifactLike(ZipArtifact item) {
        return new ZipArtifactArtifactsNested(-1, item);
    }

    public ZipArtifactArtifactsNested<A> setNewZipArtifactArtifactLike(int index, ZipArtifact item) {
        return new ZipArtifactArtifactsNested(index, item);
    }

    public OtherArtifactArtifactsNested<A> addNewOtherArtifactArtifact() {
        return new OtherArtifactArtifactsNested(-1, null);
    }

    public OtherArtifactArtifactsNested<A> addNewOtherArtifactArtifactLike(OtherArtifact item) {
        return new OtherArtifactArtifactsNested(-1, item);
    }

    public OtherArtifactArtifactsNested<A> setNewOtherArtifactArtifactLike(int index, OtherArtifact item) {
        return new OtherArtifactArtifactsNested(index, item);
    }

    public JarArtifactArtifactsNested<A> addNewJarArtifactArtifact() {
        return new JarArtifactArtifactsNested(-1, null);
    }

    public JarArtifactArtifactsNested<A> addNewJarArtifactArtifactLike(JarArtifact item) {
        return new JarArtifactArtifactsNested(-1, item);
    }

    public JarArtifactArtifactsNested<A> setNewJarArtifactArtifactLike(int index, JarArtifact item) {
        return new JarArtifactArtifactsNested(index, item);
    }

    public TgzArtifactArtifactsNested<A> addNewTgzArtifactArtifact() {
        return new TgzArtifactArtifactsNested(-1, null);
    }

    public TgzArtifactArtifactsNested<A> addNewTgzArtifactArtifactLike(TgzArtifact item) {
        return new TgzArtifactArtifactsNested(-1, item);
    }

    public TgzArtifactArtifactsNested<A> setNewTgzArtifactArtifactLike(int index, TgzArtifact item) {
        return new TgzArtifactArtifactsNested(index, item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PluginFluent that = (PluginFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.artifacts, that.artifacts);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.artifacts, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.artifacts != null && !this.artifacts.isEmpty()) {
            sb.append("artifacts:");
            sb.append(this.artifacts);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.connect.build.MavenArtifact": {
                return new MavenArtifactBuilder((MavenArtifact)item);
            }
            case "io.strimzi.api.kafka.model.connect.build.ZipArtifact": {
                return new ZipArtifactBuilder((ZipArtifact)item);
            }
            case "io.strimzi.api.kafka.model.connect.build.OtherArtifact": {
                return new OtherArtifactBuilder((OtherArtifact)item);
            }
            case "io.strimzi.api.kafka.model.connect.build.JarArtifact": {
                return new JarArtifactBuilder((JarArtifact)item);
            }
            case "io.strimzi.api.kafka.model.connect.build.TgzArtifact": {
                return new TgzArtifactBuilder((TgzArtifact)item);
            }
        }
        return PluginFluent.builderOf((Object)item);
    }

    public class MavenArtifactArtifactsNested<N>
    extends MavenArtifactFluent<MavenArtifactArtifactsNested<N>>
    implements Nested<N> {
        MavenArtifactBuilder builder;
        int index;

        MavenArtifactArtifactsNested(int index, MavenArtifact item) {
            this.index = index;
            this.builder = new MavenArtifactBuilder(this, item);
        }

        public N and() {
            return (N)PluginFluent.this.setToArtifacts(this.index, this.builder.build());
        }

        public N endMavenArtifactArtifact() {
            return this.and();
        }
    }

    public class ZipArtifactArtifactsNested<N>
    extends ZipArtifactFluent<ZipArtifactArtifactsNested<N>>
    implements Nested<N> {
        ZipArtifactBuilder builder;
        int index;

        ZipArtifactArtifactsNested(int index, ZipArtifact item) {
            this.index = index;
            this.builder = new ZipArtifactBuilder(this, item);
        }

        public N and() {
            return (N)PluginFluent.this.setToArtifacts(this.index, this.builder.build());
        }

        public N endZipArtifactArtifact() {
            return this.and();
        }
    }

    public class OtherArtifactArtifactsNested<N>
    extends OtherArtifactFluent<OtherArtifactArtifactsNested<N>>
    implements Nested<N> {
        OtherArtifactBuilder builder;
        int index;

        OtherArtifactArtifactsNested(int index, OtherArtifact item) {
            this.index = index;
            this.builder = new OtherArtifactBuilder(this, item);
        }

        public N and() {
            return (N)PluginFluent.this.setToArtifacts(this.index, this.builder.build());
        }

        public N endOtherArtifactArtifact() {
            return this.and();
        }
    }

    public class JarArtifactArtifactsNested<N>
    extends JarArtifactFluent<JarArtifactArtifactsNested<N>>
    implements Nested<N> {
        JarArtifactBuilder builder;
        int index;

        JarArtifactArtifactsNested(int index, JarArtifact item) {
            this.index = index;
            this.builder = new JarArtifactBuilder(this, item);
        }

        public N and() {
            return (N)PluginFluent.this.setToArtifacts(this.index, this.builder.build());
        }

        public N endJarArtifactArtifact() {
            return this.and();
        }
    }

    public class TgzArtifactArtifactsNested<N>
    extends TgzArtifactFluent<TgzArtifactArtifactsNested<N>>
    implements Nested<N> {
        TgzArtifactBuilder builder;
        int index;

        TgzArtifactArtifactsNested(int index, TgzArtifact item) {
            this.index = index;
            this.builder = new TgzArtifactBuilder(this, item);
        }

        public N and() {
            return (N)PluginFluent.this.setToArtifacts(this.index, this.builder.build());
        }

        public N endTgzArtifactArtifact() {
            return this.and();
        }
    }
}

