/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connector;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.connector.AutoRestartStatus;
import io.strimzi.api.kafka.model.connector.AutoRestartStatusBuilder;
import io.strimzi.api.kafka.model.connector.AutoRestartStatusFluent;
import io.strimzi.api.kafka.model.connector.KafkaConnectorStatus;
import io.strimzi.api.kafka.model.kafka.StatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KafkaConnectorStatusFluent<A extends KafkaConnectorStatusFluent<A>>
extends StatusFluent<A> {
    private Map<String, Object> connectorStatus;
    private int tasksMax;
    private List<String> topics;
    private AutoRestartStatusBuilder autoRestart;

    public KafkaConnectorStatusFluent() {
    }

    public KafkaConnectorStatusFluent(KafkaConnectorStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaConnectorStatus instance) {
        KafkaConnectorStatus kafkaConnectorStatus = instance = instance != null ? instance : new KafkaConnectorStatus();
        if (instance != null) {
            this.withConnectorStatus(instance.getConnectorStatus());
            this.withTasksMax(instance.getTasksMax());
            this.withTopics(instance.getTopics());
            this.withAutoRestart(instance.getAutoRestart());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
        }
    }

    public A addToConnectorStatus(String key, Object value) {
        if (this.connectorStatus == null && key != null && value != null) {
            this.connectorStatus = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.connectorStatus.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConnectorStatus(Map<String, Object> map) {
        if (this.connectorStatus == null && map != null) {
            this.connectorStatus = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.connectorStatus.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromConnectorStatus(String key) {
        if (this.connectorStatus == null) {
            return (A)((Object)this);
        }
        if (key != null && this.connectorStatus != null) {
            this.connectorStatus.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromConnectorStatus(Map<String, Object> map) {
        if (this.connectorStatus == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.connectorStatus == null) continue;
                this.connectorStatus.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getConnectorStatus() {
        return this.connectorStatus;
    }

    public <K, V> A withConnectorStatus(Map<String, Object> connectorStatus) {
        this.connectorStatus = connectorStatus == null ? null : new LinkedHashMap<String, Object>(connectorStatus);
        return (A)((Object)this);
    }

    public boolean hasConnectorStatus() {
        return this.connectorStatus != null;
    }

    public int getTasksMax() {
        return this.tasksMax;
    }

    public A withTasksMax(int tasksMax) {
        this.tasksMax = tasksMax;
        return (A)((Object)this);
    }

    public boolean hasTasksMax() {
        return true;
    }

    public A addToTopics(int index, String item) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        this.topics.add(index, item);
        return (A)((Object)this);
    }

    public A setToTopics(int index, String item) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        this.topics.set(index, item);
        return (A)((Object)this);
    }

    public A addToTopics(String ... items) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        for (String item : items) {
            this.topics.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTopics(Collection<String> items) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        for (String item : items) {
            this.topics.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTopics(String ... items) {
        if (this.topics == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.topics.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTopics(Collection<String> items) {
        if (this.topics == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.topics.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public String getTopic(int index) {
        return this.topics.get(index);
    }

    public String getFirstTopic() {
        return this.topics.get(0);
    }

    public String getLastTopic() {
        return this.topics.get(this.topics.size() - 1);
    }

    public String getMatchingTopic(Predicate<String> predicate) {
        for (String item : this.topics) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTopic(Predicate<String> predicate) {
        for (String item : this.topics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTopics(List<String> topics) {
        if (topics != null) {
            this.topics = new ArrayList<String>();
            for (String item : topics) {
                this.addToTopics(item);
            }
        } else {
            this.topics = null;
        }
        return (A)((Object)this);
    }

    public A withTopics(String ... topics) {
        if (this.topics != null) {
            this.topics.clear();
            this._visitables.remove((Object)"topics");
        }
        if (topics != null) {
            for (String item : topics) {
                this.addToTopics(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTopics() {
        return this.topics != null && !this.topics.isEmpty();
    }

    public AutoRestartStatus buildAutoRestart() {
        return this.autoRestart != null ? this.autoRestart.build() : null;
    }

    public A withAutoRestart(AutoRestartStatus autoRestart) {
        this._visitables.remove((Object)"autoRestart");
        if (autoRestart != null) {
            this.autoRestart = new AutoRestartStatusBuilder(autoRestart);
            this._visitables.get((Object)"autoRestart").add(this.autoRestart);
        } else {
            this.autoRestart = null;
            this._visitables.get((Object)"autoRestart").remove((Object)this.autoRestart);
        }
        return (A)((Object)this);
    }

    public boolean hasAutoRestart() {
        return this.autoRestart != null;
    }

    public AutoRestartNested<A> withNewAutoRestart() {
        return new AutoRestartNested(null);
    }

    public AutoRestartNested<A> withNewAutoRestartLike(AutoRestartStatus item) {
        return new AutoRestartNested(item);
    }

    public AutoRestartNested<A> editAutoRestart() {
        return this.withNewAutoRestartLike(Optional.ofNullable(this.buildAutoRestart()).orElse(null));
    }

    public AutoRestartNested<A> editOrNewAutoRestart() {
        return this.withNewAutoRestartLike(Optional.ofNullable(this.buildAutoRestart()).orElse(new AutoRestartStatusBuilder().build()));
    }

    public AutoRestartNested<A> editOrNewAutoRestartLike(AutoRestartStatus item) {
        return this.withNewAutoRestartLike(Optional.ofNullable(this.buildAutoRestart()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConnectorStatusFluent that = (KafkaConnectorStatusFluent)((Object)o);
        if (!Objects.equals(this.connectorStatus, that.connectorStatus)) {
            return false;
        }
        if (this.tasksMax != that.tasksMax) {
            return false;
        }
        if (!Objects.equals(this.topics, that.topics)) {
            return false;
        }
        return Objects.equals((Object)this.autoRestart, (Object)that.autoRestart);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.connectorStatus, this.tasksMax, this.topics, this.autoRestart, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.connectorStatus != null && !this.connectorStatus.isEmpty()) {
            sb.append("connectorStatus:");
            sb.append(this.connectorStatus + ",");
        }
        sb.append("tasksMax:");
        sb.append(this.tasksMax + ",");
        if (this.topics != null && !this.topics.isEmpty()) {
            sb.append("topics:");
            sb.append(this.topics + ",");
        }
        if (this.autoRestart != null) {
            sb.append("autoRestart:");
            sb.append((Object)this.autoRestart);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AutoRestartNested<N>
    extends AutoRestartStatusFluent<AutoRestartNested<N>>
    implements Nested<N> {
        AutoRestartStatusBuilder builder;

        AutoRestartNested(AutoRestartStatus item) {
            this.builder = new AutoRestartStatusBuilder(this, item);
        }

        public N and() {
            return (N)KafkaConnectorStatusFluent.this.withAutoRestart(this.builder.build());
        }

        public N endAutoRestart() {
            return this.and();
        }
    }
}

