/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateFluent;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplate;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplate;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.PodTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplate;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplateFluent;
import io.strimzi.api.kafka.model.kafka.KafkaClusterTemplate;
import java.util.Objects;
import java.util.Optional;

public class KafkaClusterTemplateFluent<A extends KafkaClusterTemplateFluent<A>>
extends BaseFluent<A> {
    private StatefulSetTemplateBuilder statefulset;
    private ResourceTemplateBuilder podSet;
    private PodTemplateBuilder pod;
    private InternalServiceTemplateBuilder bootstrapService;
    private InternalServiceTemplateBuilder brokersService;
    private ResourceTemplateBuilder externalBootstrapService;
    private ResourceTemplateBuilder perPodService;
    private ResourceTemplateBuilder externalBootstrapRoute;
    private ResourceTemplateBuilder perPodRoute;
    private ResourceTemplateBuilder externalBootstrapIngress;
    private ResourceTemplateBuilder perPodIngress;
    private ResourceTemplateBuilder persistentVolumeClaim;
    private ResourceTemplateBuilder clusterCaCert;
    private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private ContainerTemplateBuilder kafkaContainer;
    private ContainerTemplateBuilder initContainer;
    private ResourceTemplateBuilder clusterRoleBinding;
    private ResourceTemplateBuilder serviceAccount;
    private ResourceTemplateBuilder jmxSecret;

    public KafkaClusterTemplateFluent() {
    }

    public KafkaClusterTemplateFluent(KafkaClusterTemplate instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaClusterTemplate instance) {
        KafkaClusterTemplate kafkaClusterTemplate = instance = instance != null ? instance : new KafkaClusterTemplate();
        if (instance != null) {
            this.withStatefulset(instance.getStatefulset());
            this.withPodSet(instance.getPodSet());
            this.withPod(instance.getPod());
            this.withBootstrapService(instance.getBootstrapService());
            this.withBrokersService(instance.getBrokersService());
            this.withExternalBootstrapService(instance.getExternalBootstrapService());
            this.withPerPodService(instance.getPerPodService());
            this.withExternalBootstrapRoute(instance.getExternalBootstrapRoute());
            this.withPerPodRoute(instance.getPerPodRoute());
            this.withExternalBootstrapIngress(instance.getExternalBootstrapIngress());
            this.withPerPodIngress(instance.getPerPodIngress());
            this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
            this.withClusterCaCert(instance.getClusterCaCert());
            this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
            this.withKafkaContainer(instance.getKafkaContainer());
            this.withInitContainer(instance.getInitContainer());
            this.withClusterRoleBinding(instance.getClusterRoleBinding());
            this.withServiceAccount(instance.getServiceAccount());
            this.withJmxSecret(instance.getJmxSecret());
        }
    }

    public StatefulSetTemplate buildStatefulset() {
        return this.statefulset != null ? this.statefulset.build() : null;
    }

    public A withStatefulset(StatefulSetTemplate statefulset) {
        this._visitables.remove((Object)"statefulset");
        if (statefulset != null) {
            this.statefulset = new StatefulSetTemplateBuilder(statefulset);
            this._visitables.get((Object)"statefulset").add(this.statefulset);
        } else {
            this.statefulset = null;
            this._visitables.get((Object)"statefulset").remove((Object)this.statefulset);
        }
        return (A)((Object)this);
    }

    public boolean hasStatefulset() {
        return this.statefulset != null;
    }

    public StatefulsetNested<A> withNewStatefulset() {
        return new StatefulsetNested(null);
    }

    public StatefulsetNested<A> withNewStatefulsetLike(StatefulSetTemplate item) {
        return new StatefulsetNested(item);
    }

    public StatefulsetNested<A> editStatefulset() {
        return this.withNewStatefulsetLike(Optional.ofNullable(this.buildStatefulset()).orElse(null));
    }

    public StatefulsetNested<A> editOrNewStatefulset() {
        return this.withNewStatefulsetLike(Optional.ofNullable(this.buildStatefulset()).orElse(new StatefulSetTemplateBuilder().build()));
    }

    public StatefulsetNested<A> editOrNewStatefulsetLike(StatefulSetTemplate item) {
        return this.withNewStatefulsetLike(Optional.ofNullable(this.buildStatefulset()).orElse(item));
    }

    public ResourceTemplate buildPodSet() {
        return this.podSet != null ? this.podSet.build() : null;
    }

    public A withPodSet(ResourceTemplate podSet) {
        this._visitables.remove((Object)"podSet");
        if (podSet != null) {
            this.podSet = new ResourceTemplateBuilder(podSet);
            this._visitables.get((Object)"podSet").add(this.podSet);
        } else {
            this.podSet = null;
            this._visitables.get((Object)"podSet").remove((Object)this.podSet);
        }
        return (A)((Object)this);
    }

    public boolean hasPodSet() {
        return this.podSet != null;
    }

    public PodSetNested<A> withNewPodSet() {
        return new PodSetNested(null);
    }

    public PodSetNested<A> withNewPodSetLike(ResourceTemplate item) {
        return new PodSetNested(item);
    }

    public PodSetNested<A> editPodSet() {
        return this.withNewPodSetLike(Optional.ofNullable(this.buildPodSet()).orElse(null));
    }

    public PodSetNested<A> editOrNewPodSet() {
        return this.withNewPodSetLike(Optional.ofNullable(this.buildPodSet()).orElse(new ResourceTemplateBuilder().build()));
    }

    public PodSetNested<A> editOrNewPodSetLike(ResourceTemplate item) {
        return this.withNewPodSetLike(Optional.ofNullable(this.buildPodSet()).orElse(item));
    }

    public PodTemplate buildPod() {
        return this.pod != null ? this.pod.build() : null;
    }

    public A withPod(PodTemplate pod) {
        this._visitables.remove((Object)"pod");
        if (pod != null) {
            this.pod = new PodTemplateBuilder(pod);
            this._visitables.get((Object)"pod").add(this.pod);
        } else {
            this.pod = null;
            this._visitables.get((Object)"pod").remove((Object)this.pod);
        }
        return (A)((Object)this);
    }

    public boolean hasPod() {
        return this.pod != null;
    }

    public PodNested<A> withNewPod() {
        return new PodNested(null);
    }

    public PodNested<A> withNewPodLike(PodTemplate item) {
        return new PodNested(item);
    }

    public PodNested<A> editPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(null));
    }

    public PodNested<A> editOrNewPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(new PodTemplateBuilder().build()));
    }

    public PodNested<A> editOrNewPodLike(PodTemplate item) {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(item));
    }

    public InternalServiceTemplate buildBootstrapService() {
        return this.bootstrapService != null ? this.bootstrapService.build() : null;
    }

    public A withBootstrapService(InternalServiceTemplate bootstrapService) {
        this._visitables.remove((Object)"bootstrapService");
        if (bootstrapService != null) {
            this.bootstrapService = new InternalServiceTemplateBuilder(bootstrapService);
            this._visitables.get((Object)"bootstrapService").add(this.bootstrapService);
        } else {
            this.bootstrapService = null;
            this._visitables.get((Object)"bootstrapService").remove((Object)this.bootstrapService);
        }
        return (A)((Object)this);
    }

    public boolean hasBootstrapService() {
        return this.bootstrapService != null;
    }

    public BootstrapServiceNested<A> withNewBootstrapService() {
        return new BootstrapServiceNested(null);
    }

    public BootstrapServiceNested<A> withNewBootstrapServiceLike(InternalServiceTemplate item) {
        return new BootstrapServiceNested(item);
    }

    public BootstrapServiceNested<A> editBootstrapService() {
        return this.withNewBootstrapServiceLike(Optional.ofNullable(this.buildBootstrapService()).orElse(null));
    }

    public BootstrapServiceNested<A> editOrNewBootstrapService() {
        return this.withNewBootstrapServiceLike(Optional.ofNullable(this.buildBootstrapService()).orElse(new InternalServiceTemplateBuilder().build()));
    }

    public BootstrapServiceNested<A> editOrNewBootstrapServiceLike(InternalServiceTemplate item) {
        return this.withNewBootstrapServiceLike(Optional.ofNullable(this.buildBootstrapService()).orElse(item));
    }

    public InternalServiceTemplate buildBrokersService() {
        return this.brokersService != null ? this.brokersService.build() : null;
    }

    public A withBrokersService(InternalServiceTemplate brokersService) {
        this._visitables.remove((Object)"brokersService");
        if (brokersService != null) {
            this.brokersService = new InternalServiceTemplateBuilder(brokersService);
            this._visitables.get((Object)"brokersService").add(this.brokersService);
        } else {
            this.brokersService = null;
            this._visitables.get((Object)"brokersService").remove((Object)this.brokersService);
        }
        return (A)((Object)this);
    }

    public boolean hasBrokersService() {
        return this.brokersService != null;
    }

    public BrokersServiceNested<A> withNewBrokersService() {
        return new BrokersServiceNested(null);
    }

    public BrokersServiceNested<A> withNewBrokersServiceLike(InternalServiceTemplate item) {
        return new BrokersServiceNested(item);
    }

    public BrokersServiceNested<A> editBrokersService() {
        return this.withNewBrokersServiceLike(Optional.ofNullable(this.buildBrokersService()).orElse(null));
    }

    public BrokersServiceNested<A> editOrNewBrokersService() {
        return this.withNewBrokersServiceLike(Optional.ofNullable(this.buildBrokersService()).orElse(new InternalServiceTemplateBuilder().build()));
    }

    public BrokersServiceNested<A> editOrNewBrokersServiceLike(InternalServiceTemplate item) {
        return this.withNewBrokersServiceLike(Optional.ofNullable(this.buildBrokersService()).orElse(item));
    }

    public ResourceTemplate buildExternalBootstrapService() {
        return this.externalBootstrapService != null ? this.externalBootstrapService.build() : null;
    }

    public A withExternalBootstrapService(ResourceTemplate externalBootstrapService) {
        this._visitables.remove((Object)"externalBootstrapService");
        if (externalBootstrapService != null) {
            this.externalBootstrapService = new ResourceTemplateBuilder(externalBootstrapService);
            this._visitables.get((Object)"externalBootstrapService").add(this.externalBootstrapService);
        } else {
            this.externalBootstrapService = null;
            this._visitables.get((Object)"externalBootstrapService").remove((Object)this.externalBootstrapService);
        }
        return (A)((Object)this);
    }

    public boolean hasExternalBootstrapService() {
        return this.externalBootstrapService != null;
    }

    public ExternalBootstrapServiceNested<A> withNewExternalBootstrapService() {
        return new ExternalBootstrapServiceNested(null);
    }

    public ExternalBootstrapServiceNested<A> withNewExternalBootstrapServiceLike(ResourceTemplate item) {
        return new ExternalBootstrapServiceNested(item);
    }

    public ExternalBootstrapServiceNested<A> editExternalBootstrapService() {
        return this.withNewExternalBootstrapServiceLike(Optional.ofNullable(this.buildExternalBootstrapService()).orElse(null));
    }

    public ExternalBootstrapServiceNested<A> editOrNewExternalBootstrapService() {
        return this.withNewExternalBootstrapServiceLike(Optional.ofNullable(this.buildExternalBootstrapService()).orElse(new ResourceTemplateBuilder().build()));
    }

    public ExternalBootstrapServiceNested<A> editOrNewExternalBootstrapServiceLike(ResourceTemplate item) {
        return this.withNewExternalBootstrapServiceLike(Optional.ofNullable(this.buildExternalBootstrapService()).orElse(item));
    }

    public ResourceTemplate buildPerPodService() {
        return this.perPodService != null ? this.perPodService.build() : null;
    }

    public A withPerPodService(ResourceTemplate perPodService) {
        this._visitables.remove((Object)"perPodService");
        if (perPodService != null) {
            this.perPodService = new ResourceTemplateBuilder(perPodService);
            this._visitables.get((Object)"perPodService").add(this.perPodService);
        } else {
            this.perPodService = null;
            this._visitables.get((Object)"perPodService").remove((Object)this.perPodService);
        }
        return (A)((Object)this);
    }

    public boolean hasPerPodService() {
        return this.perPodService != null;
    }

    public PerPodServiceNested<A> withNewPerPodService() {
        return new PerPodServiceNested(null);
    }

    public PerPodServiceNested<A> withNewPerPodServiceLike(ResourceTemplate item) {
        return new PerPodServiceNested(item);
    }

    public PerPodServiceNested<A> editPerPodService() {
        return this.withNewPerPodServiceLike(Optional.ofNullable(this.buildPerPodService()).orElse(null));
    }

    public PerPodServiceNested<A> editOrNewPerPodService() {
        return this.withNewPerPodServiceLike(Optional.ofNullable(this.buildPerPodService()).orElse(new ResourceTemplateBuilder().build()));
    }

    public PerPodServiceNested<A> editOrNewPerPodServiceLike(ResourceTemplate item) {
        return this.withNewPerPodServiceLike(Optional.ofNullable(this.buildPerPodService()).orElse(item));
    }

    public ResourceTemplate buildExternalBootstrapRoute() {
        return this.externalBootstrapRoute != null ? this.externalBootstrapRoute.build() : null;
    }

    public A withExternalBootstrapRoute(ResourceTemplate externalBootstrapRoute) {
        this._visitables.remove((Object)"externalBootstrapRoute");
        if (externalBootstrapRoute != null) {
            this.externalBootstrapRoute = new ResourceTemplateBuilder(externalBootstrapRoute);
            this._visitables.get((Object)"externalBootstrapRoute").add(this.externalBootstrapRoute);
        } else {
            this.externalBootstrapRoute = null;
            this._visitables.get((Object)"externalBootstrapRoute").remove((Object)this.externalBootstrapRoute);
        }
        return (A)((Object)this);
    }

    public boolean hasExternalBootstrapRoute() {
        return this.externalBootstrapRoute != null;
    }

    public ExternalBootstrapRouteNested<A> withNewExternalBootstrapRoute() {
        return new ExternalBootstrapRouteNested(null);
    }

    public ExternalBootstrapRouteNested<A> withNewExternalBootstrapRouteLike(ResourceTemplate item) {
        return new ExternalBootstrapRouteNested(item);
    }

    public ExternalBootstrapRouteNested<A> editExternalBootstrapRoute() {
        return this.withNewExternalBootstrapRouteLike(Optional.ofNullable(this.buildExternalBootstrapRoute()).orElse(null));
    }

    public ExternalBootstrapRouteNested<A> editOrNewExternalBootstrapRoute() {
        return this.withNewExternalBootstrapRouteLike(Optional.ofNullable(this.buildExternalBootstrapRoute()).orElse(new ResourceTemplateBuilder().build()));
    }

    public ExternalBootstrapRouteNested<A> editOrNewExternalBootstrapRouteLike(ResourceTemplate item) {
        return this.withNewExternalBootstrapRouteLike(Optional.ofNullable(this.buildExternalBootstrapRoute()).orElse(item));
    }

    public ResourceTemplate buildPerPodRoute() {
        return this.perPodRoute != null ? this.perPodRoute.build() : null;
    }

    public A withPerPodRoute(ResourceTemplate perPodRoute) {
        this._visitables.remove((Object)"perPodRoute");
        if (perPodRoute != null) {
            this.perPodRoute = new ResourceTemplateBuilder(perPodRoute);
            this._visitables.get((Object)"perPodRoute").add(this.perPodRoute);
        } else {
            this.perPodRoute = null;
            this._visitables.get((Object)"perPodRoute").remove((Object)this.perPodRoute);
        }
        return (A)((Object)this);
    }

    public boolean hasPerPodRoute() {
        return this.perPodRoute != null;
    }

    public PerPodRouteNested<A> withNewPerPodRoute() {
        return new PerPodRouteNested(null);
    }

    public PerPodRouteNested<A> withNewPerPodRouteLike(ResourceTemplate item) {
        return new PerPodRouteNested(item);
    }

    public PerPodRouteNested<A> editPerPodRoute() {
        return this.withNewPerPodRouteLike(Optional.ofNullable(this.buildPerPodRoute()).orElse(null));
    }

    public PerPodRouteNested<A> editOrNewPerPodRoute() {
        return this.withNewPerPodRouteLike(Optional.ofNullable(this.buildPerPodRoute()).orElse(new ResourceTemplateBuilder().build()));
    }

    public PerPodRouteNested<A> editOrNewPerPodRouteLike(ResourceTemplate item) {
        return this.withNewPerPodRouteLike(Optional.ofNullable(this.buildPerPodRoute()).orElse(item));
    }

    public ResourceTemplate buildExternalBootstrapIngress() {
        return this.externalBootstrapIngress != null ? this.externalBootstrapIngress.build() : null;
    }

    public A withExternalBootstrapIngress(ResourceTemplate externalBootstrapIngress) {
        this._visitables.remove((Object)"externalBootstrapIngress");
        if (externalBootstrapIngress != null) {
            this.externalBootstrapIngress = new ResourceTemplateBuilder(externalBootstrapIngress);
            this._visitables.get((Object)"externalBootstrapIngress").add(this.externalBootstrapIngress);
        } else {
            this.externalBootstrapIngress = null;
            this._visitables.get((Object)"externalBootstrapIngress").remove((Object)this.externalBootstrapIngress);
        }
        return (A)((Object)this);
    }

    public boolean hasExternalBootstrapIngress() {
        return this.externalBootstrapIngress != null;
    }

    public ExternalBootstrapIngressNested<A> withNewExternalBootstrapIngress() {
        return new ExternalBootstrapIngressNested(null);
    }

    public ExternalBootstrapIngressNested<A> withNewExternalBootstrapIngressLike(ResourceTemplate item) {
        return new ExternalBootstrapIngressNested(item);
    }

    public ExternalBootstrapIngressNested<A> editExternalBootstrapIngress() {
        return this.withNewExternalBootstrapIngressLike(Optional.ofNullable(this.buildExternalBootstrapIngress()).orElse(null));
    }

    public ExternalBootstrapIngressNested<A> editOrNewExternalBootstrapIngress() {
        return this.withNewExternalBootstrapIngressLike(Optional.ofNullable(this.buildExternalBootstrapIngress()).orElse(new ResourceTemplateBuilder().build()));
    }

    public ExternalBootstrapIngressNested<A> editOrNewExternalBootstrapIngressLike(ResourceTemplate item) {
        return this.withNewExternalBootstrapIngressLike(Optional.ofNullable(this.buildExternalBootstrapIngress()).orElse(item));
    }

    public ResourceTemplate buildPerPodIngress() {
        return this.perPodIngress != null ? this.perPodIngress.build() : null;
    }

    public A withPerPodIngress(ResourceTemplate perPodIngress) {
        this._visitables.remove((Object)"perPodIngress");
        if (perPodIngress != null) {
            this.perPodIngress = new ResourceTemplateBuilder(perPodIngress);
            this._visitables.get((Object)"perPodIngress").add(this.perPodIngress);
        } else {
            this.perPodIngress = null;
            this._visitables.get((Object)"perPodIngress").remove((Object)this.perPodIngress);
        }
        return (A)((Object)this);
    }

    public boolean hasPerPodIngress() {
        return this.perPodIngress != null;
    }

    public PerPodIngressNested<A> withNewPerPodIngress() {
        return new PerPodIngressNested(null);
    }

    public PerPodIngressNested<A> withNewPerPodIngressLike(ResourceTemplate item) {
        return new PerPodIngressNested(item);
    }

    public PerPodIngressNested<A> editPerPodIngress() {
        return this.withNewPerPodIngressLike(Optional.ofNullable(this.buildPerPodIngress()).orElse(null));
    }

    public PerPodIngressNested<A> editOrNewPerPodIngress() {
        return this.withNewPerPodIngressLike(Optional.ofNullable(this.buildPerPodIngress()).orElse(new ResourceTemplateBuilder().build()));
    }

    public PerPodIngressNested<A> editOrNewPerPodIngressLike(ResourceTemplate item) {
        return this.withNewPerPodIngressLike(Optional.ofNullable(this.buildPerPodIngress()).orElse(item));
    }

    public ResourceTemplate buildPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null ? this.persistentVolumeClaim.build() : null;
    }

    public A withPersistentVolumeClaim(ResourceTemplate persistentVolumeClaim) {
        this._visitables.remove((Object)"persistentVolumeClaim");
        if (persistentVolumeClaim != null) {
            this.persistentVolumeClaim = new ResourceTemplateBuilder(persistentVolumeClaim);
            this._visitables.get((Object)"persistentVolumeClaim").add(this.persistentVolumeClaim);
        } else {
            this.persistentVolumeClaim = null;
            this._visitables.get((Object)"persistentVolumeClaim").remove((Object)this.persistentVolumeClaim);
        }
        return (A)((Object)this);
    }

    public boolean hasPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null;
    }

    public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
        return new PersistentVolumeClaimNested(null);
    }

    public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(ResourceTemplate item) {
        return new PersistentVolumeClaimNested(item);
    }

    public PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
        return this.withNewPersistentVolumeClaimLike(Optional.ofNullable(this.buildPersistentVolumeClaim()).orElse(null));
    }

    public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
        return this.withNewPersistentVolumeClaimLike(Optional.ofNullable(this.buildPersistentVolumeClaim()).orElse(new ResourceTemplateBuilder().build()));
    }

    public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(ResourceTemplate item) {
        return this.withNewPersistentVolumeClaimLike(Optional.ofNullable(this.buildPersistentVolumeClaim()).orElse(item));
    }

    public ResourceTemplate buildClusterCaCert() {
        return this.clusterCaCert != null ? this.clusterCaCert.build() : null;
    }

    public A withClusterCaCert(ResourceTemplate clusterCaCert) {
        this._visitables.remove((Object)"clusterCaCert");
        if (clusterCaCert != null) {
            this.clusterCaCert = new ResourceTemplateBuilder(clusterCaCert);
            this._visitables.get((Object)"clusterCaCert").add(this.clusterCaCert);
        } else {
            this.clusterCaCert = null;
            this._visitables.get((Object)"clusterCaCert").remove((Object)this.clusterCaCert);
        }
        return (A)((Object)this);
    }

    public boolean hasClusterCaCert() {
        return this.clusterCaCert != null;
    }

    public ClusterCaCertNested<A> withNewClusterCaCert() {
        return new ClusterCaCertNested(null);
    }

    public ClusterCaCertNested<A> withNewClusterCaCertLike(ResourceTemplate item) {
        return new ClusterCaCertNested(item);
    }

    public ClusterCaCertNested<A> editClusterCaCert() {
        return this.withNewClusterCaCertLike(Optional.ofNullable(this.buildClusterCaCert()).orElse(null));
    }

    public ClusterCaCertNested<A> editOrNewClusterCaCert() {
        return this.withNewClusterCaCertLike(Optional.ofNullable(this.buildClusterCaCert()).orElse(new ResourceTemplateBuilder().build()));
    }

    public ClusterCaCertNested<A> editOrNewClusterCaCertLike(ResourceTemplate item) {
        return this.withNewClusterCaCertLike(Optional.ofNullable(this.buildClusterCaCert()).orElse(item));
    }

    public PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
        return this.podDisruptionBudget != null ? this.podDisruptionBudget.build() : null;
    }

    public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
        this._visitables.remove((Object)"podDisruptionBudget");
        if (podDisruptionBudget != null) {
            this.podDisruptionBudget = new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget);
            this._visitables.get((Object)"podDisruptionBudget").add(this.podDisruptionBudget);
        } else {
            this.podDisruptionBudget = null;
            this._visitables.get((Object)"podDisruptionBudget").remove((Object)this.podDisruptionBudget);
        }
        return (A)((Object)this);
    }

    public boolean hasPodDisruptionBudget() {
        return this.podDisruptionBudget != null;
    }

    public PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
        return new PodDisruptionBudgetNested(null);
    }

    public PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return new PodDisruptionBudgetNested(item);
    }

    public PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(null));
    }

    public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(new PodDisruptionBudgetTemplateBuilder().build()));
    }

    public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(item));
    }

    public ContainerTemplate buildKafkaContainer() {
        return this.kafkaContainer != null ? this.kafkaContainer.build() : null;
    }

    public A withKafkaContainer(ContainerTemplate kafkaContainer) {
        this._visitables.remove((Object)"kafkaContainer");
        if (kafkaContainer != null) {
            this.kafkaContainer = new ContainerTemplateBuilder(kafkaContainer);
            this._visitables.get((Object)"kafkaContainer").add(this.kafkaContainer);
        } else {
            this.kafkaContainer = null;
            this._visitables.get((Object)"kafkaContainer").remove((Object)this.kafkaContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasKafkaContainer() {
        return this.kafkaContainer != null;
    }

    public KafkaContainerNested<A> withNewKafkaContainer() {
        return new KafkaContainerNested(null);
    }

    public KafkaContainerNested<A> withNewKafkaContainerLike(ContainerTemplate item) {
        return new KafkaContainerNested(item);
    }

    public KafkaContainerNested<A> editKafkaContainer() {
        return this.withNewKafkaContainerLike(Optional.ofNullable(this.buildKafkaContainer()).orElse(null));
    }

    public KafkaContainerNested<A> editOrNewKafkaContainer() {
        return this.withNewKafkaContainerLike(Optional.ofNullable(this.buildKafkaContainer()).orElse(new ContainerTemplateBuilder().build()));
    }

    public KafkaContainerNested<A> editOrNewKafkaContainerLike(ContainerTemplate item) {
        return this.withNewKafkaContainerLike(Optional.ofNullable(this.buildKafkaContainer()).orElse(item));
    }

    public ContainerTemplate buildInitContainer() {
        return this.initContainer != null ? this.initContainer.build() : null;
    }

    public A withInitContainer(ContainerTemplate initContainer) {
        this._visitables.remove((Object)"initContainer");
        if (initContainer != null) {
            this.initContainer = new ContainerTemplateBuilder(initContainer);
            this._visitables.get((Object)"initContainer").add(this.initContainer);
        } else {
            this.initContainer = null;
            this._visitables.get((Object)"initContainer").remove((Object)this.initContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasInitContainer() {
        return this.initContainer != null;
    }

    public InitContainerNested<A> withNewInitContainer() {
        return new InitContainerNested(null);
    }

    public InitContainerNested<A> withNewInitContainerLike(ContainerTemplate item) {
        return new InitContainerNested(item);
    }

    public InitContainerNested<A> editInitContainer() {
        return this.withNewInitContainerLike(Optional.ofNullable(this.buildInitContainer()).orElse(null));
    }

    public InitContainerNested<A> editOrNewInitContainer() {
        return this.withNewInitContainerLike(Optional.ofNullable(this.buildInitContainer()).orElse(new ContainerTemplateBuilder().build()));
    }

    public InitContainerNested<A> editOrNewInitContainerLike(ContainerTemplate item) {
        return this.withNewInitContainerLike(Optional.ofNullable(this.buildInitContainer()).orElse(item));
    }

    public ResourceTemplate buildClusterRoleBinding() {
        return this.clusterRoleBinding != null ? this.clusterRoleBinding.build() : null;
    }

    public A withClusterRoleBinding(ResourceTemplate clusterRoleBinding) {
        this._visitables.remove((Object)"clusterRoleBinding");
        if (clusterRoleBinding != null) {
            this.clusterRoleBinding = new ResourceTemplateBuilder(clusterRoleBinding);
            this._visitables.get((Object)"clusterRoleBinding").add(this.clusterRoleBinding);
        } else {
            this.clusterRoleBinding = null;
            this._visitables.get((Object)"clusterRoleBinding").remove((Object)this.clusterRoleBinding);
        }
        return (A)((Object)this);
    }

    public boolean hasClusterRoleBinding() {
        return this.clusterRoleBinding != null;
    }

    public ClusterRoleBindingNested<A> withNewClusterRoleBinding() {
        return new ClusterRoleBindingNested(null);
    }

    public ClusterRoleBindingNested<A> withNewClusterRoleBindingLike(ResourceTemplate item) {
        return new ClusterRoleBindingNested(item);
    }

    public ClusterRoleBindingNested<A> editClusterRoleBinding() {
        return this.withNewClusterRoleBindingLike(Optional.ofNullable(this.buildClusterRoleBinding()).orElse(null));
    }

    public ClusterRoleBindingNested<A> editOrNewClusterRoleBinding() {
        return this.withNewClusterRoleBindingLike(Optional.ofNullable(this.buildClusterRoleBinding()).orElse(new ResourceTemplateBuilder().build()));
    }

    public ClusterRoleBindingNested<A> editOrNewClusterRoleBindingLike(ResourceTemplate item) {
        return this.withNewClusterRoleBindingLike(Optional.ofNullable(this.buildClusterRoleBinding()).orElse(item));
    }

    public ResourceTemplate buildServiceAccount() {
        return this.serviceAccount != null ? this.serviceAccount.build() : null;
    }

    public A withServiceAccount(ResourceTemplate serviceAccount) {
        this._visitables.remove((Object)"serviceAccount");
        if (serviceAccount != null) {
            this.serviceAccount = new ResourceTemplateBuilder(serviceAccount);
            this._visitables.get((Object)"serviceAccount").add(this.serviceAccount);
        } else {
            this.serviceAccount = null;
            this._visitables.get((Object)"serviceAccount").remove((Object)this.serviceAccount);
        }
        return (A)((Object)this);
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public ServiceAccountNested<A> withNewServiceAccount() {
        return new ServiceAccountNested(null);
    }

    public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
        return new ServiceAccountNested(item);
    }

    public ServiceAccountNested<A> editServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(null));
    }

    public ServiceAccountNested<A> editOrNewServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
    }

    public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(item));
    }

    public ResourceTemplate buildJmxSecret() {
        return this.jmxSecret != null ? this.jmxSecret.build() : null;
    }

    public A withJmxSecret(ResourceTemplate jmxSecret) {
        this._visitables.remove((Object)"jmxSecret");
        if (jmxSecret != null) {
            this.jmxSecret = new ResourceTemplateBuilder(jmxSecret);
            this._visitables.get((Object)"jmxSecret").add(this.jmxSecret);
        } else {
            this.jmxSecret = null;
            this._visitables.get((Object)"jmxSecret").remove((Object)this.jmxSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasJmxSecret() {
        return this.jmxSecret != null;
    }

    public JmxSecretNested<A> withNewJmxSecret() {
        return new JmxSecretNested(null);
    }

    public JmxSecretNested<A> withNewJmxSecretLike(ResourceTemplate item) {
        return new JmxSecretNested(item);
    }

    public JmxSecretNested<A> editJmxSecret() {
        return this.withNewJmxSecretLike(Optional.ofNullable(this.buildJmxSecret()).orElse(null));
    }

    public JmxSecretNested<A> editOrNewJmxSecret() {
        return this.withNewJmxSecretLike(Optional.ofNullable(this.buildJmxSecret()).orElse(new ResourceTemplateBuilder().build()));
    }

    public JmxSecretNested<A> editOrNewJmxSecretLike(ResourceTemplate item) {
        return this.withNewJmxSecretLike(Optional.ofNullable(this.buildJmxSecret()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaClusterTemplateFluent that = (KafkaClusterTemplateFluent)((Object)o);
        if (!Objects.equals((Object)this.statefulset, (Object)that.statefulset)) {
            return false;
        }
        if (!Objects.equals((Object)this.podSet, (Object)that.podSet)) {
            return false;
        }
        if (!Objects.equals((Object)this.pod, (Object)that.pod)) {
            return false;
        }
        if (!Objects.equals((Object)this.bootstrapService, (Object)that.bootstrapService)) {
            return false;
        }
        if (!Objects.equals((Object)this.brokersService, (Object)that.brokersService)) {
            return false;
        }
        if (!Objects.equals((Object)this.externalBootstrapService, (Object)that.externalBootstrapService)) {
            return false;
        }
        if (!Objects.equals((Object)this.perPodService, (Object)that.perPodService)) {
            return false;
        }
        if (!Objects.equals((Object)this.externalBootstrapRoute, (Object)that.externalBootstrapRoute)) {
            return false;
        }
        if (!Objects.equals((Object)this.perPodRoute, (Object)that.perPodRoute)) {
            return false;
        }
        if (!Objects.equals((Object)this.externalBootstrapIngress, (Object)that.externalBootstrapIngress)) {
            return false;
        }
        if (!Objects.equals((Object)this.perPodIngress, (Object)that.perPodIngress)) {
            return false;
        }
        if (!Objects.equals((Object)this.persistentVolumeClaim, (Object)that.persistentVolumeClaim)) {
            return false;
        }
        if (!Objects.equals((Object)this.clusterCaCert, (Object)that.clusterCaCert)) {
            return false;
        }
        if (!Objects.equals((Object)this.podDisruptionBudget, (Object)that.podDisruptionBudget)) {
            return false;
        }
        if (!Objects.equals((Object)this.kafkaContainer, (Object)that.kafkaContainer)) {
            return false;
        }
        if (!Objects.equals((Object)this.initContainer, (Object)that.initContainer)) {
            return false;
        }
        if (!Objects.equals((Object)this.clusterRoleBinding, (Object)that.clusterRoleBinding)) {
            return false;
        }
        if (!Objects.equals((Object)this.serviceAccount, (Object)that.serviceAccount)) {
            return false;
        }
        return Objects.equals((Object)this.jmxSecret, (Object)that.jmxSecret);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.statefulset, this.podSet, this.pod, this.bootstrapService, this.brokersService, this.externalBootstrapService, this.perPodService, this.externalBootstrapRoute, this.perPodRoute, this.externalBootstrapIngress, this.perPodIngress, this.persistentVolumeClaim, this.clusterCaCert, this.podDisruptionBudget, this.kafkaContainer, this.initContainer, this.clusterRoleBinding, this.serviceAccount, this.jmxSecret, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.statefulset != null) {
            sb.append("statefulset:");
            sb.append(this.statefulset + ",");
        }
        if (this.podSet != null) {
            sb.append("podSet:");
            sb.append(this.podSet + ",");
        }
        if (this.pod != null) {
            sb.append("pod:");
            sb.append(this.pod + ",");
        }
        if (this.bootstrapService != null) {
            sb.append("bootstrapService:");
            sb.append(this.bootstrapService + ",");
        }
        if (this.brokersService != null) {
            sb.append("brokersService:");
            sb.append(this.brokersService + ",");
        }
        if (this.externalBootstrapService != null) {
            sb.append("externalBootstrapService:");
            sb.append(this.externalBootstrapService + ",");
        }
        if (this.perPodService != null) {
            sb.append("perPodService:");
            sb.append(this.perPodService + ",");
        }
        if (this.externalBootstrapRoute != null) {
            sb.append("externalBootstrapRoute:");
            sb.append(this.externalBootstrapRoute + ",");
        }
        if (this.perPodRoute != null) {
            sb.append("perPodRoute:");
            sb.append(this.perPodRoute + ",");
        }
        if (this.externalBootstrapIngress != null) {
            sb.append("externalBootstrapIngress:");
            sb.append(this.externalBootstrapIngress + ",");
        }
        if (this.perPodIngress != null) {
            sb.append("perPodIngress:");
            sb.append(this.perPodIngress + ",");
        }
        if (this.persistentVolumeClaim != null) {
            sb.append("persistentVolumeClaim:");
            sb.append(this.persistentVolumeClaim + ",");
        }
        if (this.clusterCaCert != null) {
            sb.append("clusterCaCert:");
            sb.append(this.clusterCaCert + ",");
        }
        if (this.podDisruptionBudget != null) {
            sb.append("podDisruptionBudget:");
            sb.append(this.podDisruptionBudget + ",");
        }
        if (this.kafkaContainer != null) {
            sb.append("kafkaContainer:");
            sb.append(this.kafkaContainer + ",");
        }
        if (this.initContainer != null) {
            sb.append("initContainer:");
            sb.append(this.initContainer + ",");
        }
        if (this.clusterRoleBinding != null) {
            sb.append("clusterRoleBinding:");
            sb.append(this.clusterRoleBinding + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.jmxSecret != null) {
            sb.append("jmxSecret:");
            sb.append((Object)this.jmxSecret);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StatefulsetNested<N>
    extends StatefulSetTemplateFluent<StatefulsetNested<N>>
    implements Nested<N> {
        StatefulSetTemplateBuilder builder;

        StatefulsetNested(StatefulSetTemplate item) {
            this.builder = new StatefulSetTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withStatefulset(this.builder.build());
        }

        public N endStatefulset() {
            return this.and();
        }
    }

    public class PodSetNested<N>
    extends ResourceTemplateFluent<PodSetNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        PodSetNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withPodSet(this.builder.build());
        }

        public N endPodSet() {
            return this.and();
        }
    }

    public class PodNested<N>
    extends PodTemplateFluent<PodNested<N>>
    implements Nested<N> {
        PodTemplateBuilder builder;

        PodNested(PodTemplate item) {
            this.builder = new PodTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withPod(this.builder.build());
        }

        public N endPod() {
            return this.and();
        }
    }

    public class BootstrapServiceNested<N>
    extends InternalServiceTemplateFluent<BootstrapServiceNested<N>>
    implements Nested<N> {
        InternalServiceTemplateBuilder builder;

        BootstrapServiceNested(InternalServiceTemplate item) {
            this.builder = new InternalServiceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withBootstrapService(this.builder.build());
        }

        public N endBootstrapService() {
            return this.and();
        }
    }

    public class BrokersServiceNested<N>
    extends InternalServiceTemplateFluent<BrokersServiceNested<N>>
    implements Nested<N> {
        InternalServiceTemplateBuilder builder;

        BrokersServiceNested(InternalServiceTemplate item) {
            this.builder = new InternalServiceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withBrokersService(this.builder.build());
        }

        public N endBrokersService() {
            return this.and();
        }
    }

    public class ExternalBootstrapServiceNested<N>
    extends ResourceTemplateFluent<ExternalBootstrapServiceNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        ExternalBootstrapServiceNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withExternalBootstrapService(this.builder.build());
        }

        public N endExternalBootstrapService() {
            return this.and();
        }
    }

    public class PerPodServiceNested<N>
    extends ResourceTemplateFluent<PerPodServiceNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        PerPodServiceNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withPerPodService(this.builder.build());
        }

        public N endPerPodService() {
            return this.and();
        }
    }

    public class ExternalBootstrapRouteNested<N>
    extends ResourceTemplateFluent<ExternalBootstrapRouteNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        ExternalBootstrapRouteNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withExternalBootstrapRoute(this.builder.build());
        }

        public N endExternalBootstrapRoute() {
            return this.and();
        }
    }

    public class PerPodRouteNested<N>
    extends ResourceTemplateFluent<PerPodRouteNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        PerPodRouteNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withPerPodRoute(this.builder.build());
        }

        public N endPerPodRoute() {
            return this.and();
        }
    }

    public class ExternalBootstrapIngressNested<N>
    extends ResourceTemplateFluent<ExternalBootstrapIngressNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        ExternalBootstrapIngressNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withExternalBootstrapIngress(this.builder.build());
        }

        public N endExternalBootstrapIngress() {
            return this.and();
        }
    }

    public class PerPodIngressNested<N>
    extends ResourceTemplateFluent<PerPodIngressNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        PerPodIngressNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withPerPodIngress(this.builder.build());
        }

        public N endPerPodIngress() {
            return this.and();
        }
    }

    public class PersistentVolumeClaimNested<N>
    extends ResourceTemplateFluent<PersistentVolumeClaimNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        PersistentVolumeClaimNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withPersistentVolumeClaim(this.builder.build());
        }

        public N endPersistentVolumeClaim() {
            return this.and();
        }
    }

    public class ClusterCaCertNested<N>
    extends ResourceTemplateFluent<ClusterCaCertNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        ClusterCaCertNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withClusterCaCert(this.builder.build());
        }

        public N endClusterCaCert() {
            return this.and();
        }
    }

    public class PodDisruptionBudgetNested<N>
    extends PodDisruptionBudgetTemplateFluent<PodDisruptionBudgetNested<N>>
    implements Nested<N> {
        PodDisruptionBudgetTemplateBuilder builder;

        PodDisruptionBudgetNested(PodDisruptionBudgetTemplate item) {
            this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withPodDisruptionBudget(this.builder.build());
        }

        public N endPodDisruptionBudget() {
            return this.and();
        }
    }

    public class KafkaContainerNested<N>
    extends ContainerTemplateFluent<KafkaContainerNested<N>>
    implements Nested<N> {
        ContainerTemplateBuilder builder;

        KafkaContainerNested(ContainerTemplate item) {
            this.builder = new ContainerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withKafkaContainer(this.builder.build());
        }

        public N endKafkaContainer() {
            return this.and();
        }
    }

    public class InitContainerNested<N>
    extends ContainerTemplateFluent<InitContainerNested<N>>
    implements Nested<N> {
        ContainerTemplateBuilder builder;

        InitContainerNested(ContainerTemplate item) {
            this.builder = new ContainerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withInitContainer(this.builder.build());
        }

        public N endInitContainer() {
            return this.and();
        }
    }

    public class ClusterRoleBindingNested<N>
    extends ResourceTemplateFluent<ClusterRoleBindingNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        ClusterRoleBindingNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withClusterRoleBinding(this.builder.build());
        }

        public N endClusterRoleBinding() {
            return this.and();
        }
    }

    public class ServiceAccountNested<N>
    extends ResourceTemplateFluent<ServiceAccountNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        ServiceAccountNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withServiceAccount(this.builder.build());
        }

        public N endServiceAccount() {
            return this.and();
        }
    }

    public class JmxSecretNested<N>
    extends ResourceTemplateFluent<JmxSecretNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        JmxSecretNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClusterTemplateFluent.this.withJmxSecret(this.builder.build());
        }

        public N endJmxSecret() {
            return this.and();
        }
    }
}

