/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.BrokerCapacity;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.BrokerCapacityOverride;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.BrokerCapacityOverrideBuilder;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.BrokerCapacityOverrideFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class BrokerCapacityFluent<A extends BrokerCapacityFluent<A>>
extends BaseFluent<A> {
    private String disk;
    private Integer cpuUtilization;
    private String cpu;
    private String inboundNetwork;
    private String outboundNetwork;
    private ArrayList<BrokerCapacityOverrideBuilder> overrides;

    public BrokerCapacityFluent() {
    }

    public BrokerCapacityFluent(BrokerCapacity instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BrokerCapacity instance) {
        BrokerCapacity brokerCapacity = instance = instance != null ? instance : new BrokerCapacity();
        if (instance != null) {
            this.withDisk(instance.getDisk());
            this.withCpuUtilization(instance.getCpuUtilization());
            this.withCpu(instance.getCpu());
            this.withInboundNetwork(instance.getInboundNetwork());
            this.withOutboundNetwork(instance.getOutboundNetwork());
            this.withOverrides(instance.getOverrides());
        }
    }

    public String getDisk() {
        return this.disk;
    }

    public A withDisk(String disk) {
        this.disk = disk;
        return (A)((Object)this);
    }

    public boolean hasDisk() {
        return this.disk != null;
    }

    public Integer getCpuUtilization() {
        return this.cpuUtilization;
    }

    public A withCpuUtilization(Integer cpuUtilization) {
        this.cpuUtilization = cpuUtilization;
        return (A)((Object)this);
    }

    public boolean hasCpuUtilization() {
        return this.cpuUtilization != null;
    }

    public String getCpu() {
        return this.cpu;
    }

    public A withCpu(String cpu) {
        this.cpu = cpu;
        return (A)((Object)this);
    }

    public boolean hasCpu() {
        return this.cpu != null;
    }

    public String getInboundNetwork() {
        return this.inboundNetwork;
    }

    public A withInboundNetwork(String inboundNetwork) {
        this.inboundNetwork = inboundNetwork;
        return (A)((Object)this);
    }

    public boolean hasInboundNetwork() {
        return this.inboundNetwork != null;
    }

    public String getOutboundNetwork() {
        return this.outboundNetwork;
    }

    public A withOutboundNetwork(String outboundNetwork) {
        this.outboundNetwork = outboundNetwork;
        return (A)((Object)this);
    }

    public boolean hasOutboundNetwork() {
        return this.outboundNetwork != null;
    }

    public A addToOverrides(int index, BrokerCapacityOverride item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        BrokerCapacityOverrideBuilder builder = new BrokerCapacityOverrideBuilder(item);
        if (index < 0 || index >= this.overrides.size()) {
            this._visitables.get((Object)"overrides").add(builder);
            this.overrides.add(builder);
        } else {
            this._visitables.get((Object)"overrides").add(index, builder);
            this.overrides.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToOverrides(int index, BrokerCapacityOverride item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        BrokerCapacityOverrideBuilder builder = new BrokerCapacityOverrideBuilder(item);
        if (index < 0 || index >= this.overrides.size()) {
            this._visitables.get((Object)"overrides").add(builder);
            this.overrides.add(builder);
        } else {
            this._visitables.get((Object)"overrides").set(index, builder);
            this.overrides.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToOverrides(BrokerCapacityOverride ... items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        for (BrokerCapacityOverride item : items) {
            BrokerCapacityOverrideBuilder builder = new BrokerCapacityOverrideBuilder(item);
            this._visitables.get((Object)"overrides").add(builder);
            this.overrides.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToOverrides(Collection<BrokerCapacityOverride> items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        for (BrokerCapacityOverride item : items) {
            BrokerCapacityOverrideBuilder builder = new BrokerCapacityOverrideBuilder(item);
            this._visitables.get((Object)"overrides").add(builder);
            this.overrides.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromOverrides(BrokerCapacityOverride ... items) {
        if (this.overrides == null) {
            return (A)((Object)this);
        }
        for (BrokerCapacityOverride item : items) {
            BrokerCapacityOverrideBuilder builder = new BrokerCapacityOverrideBuilder(item);
            this._visitables.get((Object)"overrides").remove((Object)builder);
            this.overrides.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOverrides(Collection<BrokerCapacityOverride> items) {
        if (this.overrides == null) {
            return (A)((Object)this);
        }
        for (BrokerCapacityOverride item : items) {
            BrokerCapacityOverrideBuilder builder = new BrokerCapacityOverrideBuilder(item);
            this._visitables.get((Object)"overrides").remove((Object)builder);
            this.overrides.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromOverrides(Predicate<BrokerCapacityOverrideBuilder> predicate) {
        if (this.overrides == null) {
            return (A)((Object)this);
        }
        Iterator<BrokerCapacityOverrideBuilder> each = this.overrides.iterator();
        List visitables = this._visitables.get((Object)"overrides");
        while (each.hasNext()) {
            BrokerCapacityOverrideBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<BrokerCapacityOverride> buildOverrides() {
        return this.overrides != null ? BrokerCapacityFluent.build(this.overrides) : null;
    }

    public BrokerCapacityOverride buildOverride(int index) {
        return this.overrides.get(index).build();
    }

    public BrokerCapacityOverride buildFirstOverride() {
        return this.overrides.get(0).build();
    }

    public BrokerCapacityOverride buildLastOverride() {
        return this.overrides.get(this.overrides.size() - 1).build();
    }

    public BrokerCapacityOverride buildMatchingOverride(Predicate<BrokerCapacityOverrideBuilder> predicate) {
        for (BrokerCapacityOverrideBuilder item : this.overrides) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingOverride(Predicate<BrokerCapacityOverrideBuilder> predicate) {
        for (BrokerCapacityOverrideBuilder item : this.overrides) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOverrides(List<BrokerCapacityOverride> overrides) {
        if (this.overrides != null) {
            this._visitables.get((Object)"overrides").clear();
        }
        if (overrides != null) {
            this.overrides = new ArrayList();
            for (BrokerCapacityOverride item : overrides) {
                this.addToOverrides(item);
            }
        } else {
            this.overrides = null;
        }
        return (A)((Object)this);
    }

    public A withOverrides(BrokerCapacityOverride ... overrides) {
        if (this.overrides != null) {
            this.overrides.clear();
            this._visitables.remove((Object)"overrides");
        }
        if (overrides != null) {
            for (BrokerCapacityOverride item : overrides) {
                this.addToOverrides(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOverrides() {
        return this.overrides != null && !this.overrides.isEmpty();
    }

    public OverridesNested<A> addNewOverride() {
        return new OverridesNested(-1, null);
    }

    public OverridesNested<A> addNewOverrideLike(BrokerCapacityOverride item) {
        return new OverridesNested(-1, item);
    }

    public OverridesNested<A> setNewOverrideLike(int index, BrokerCapacityOverride item) {
        return new OverridesNested(index, item);
    }

    public OverridesNested<A> editOverride(int index) {
        if (this.overrides.size() <= index) {
            throw new RuntimeException("Can't edit overrides. Index exceeds size.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    public OverridesNested<A> editFirstOverride() {
        if (this.overrides.size() == 0) {
            throw new RuntimeException("Can't edit first overrides. The list is empty.");
        }
        return this.setNewOverrideLike(0, this.buildOverride(0));
    }

    public OverridesNested<A> editLastOverride() {
        int index = this.overrides.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last overrides. The list is empty.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    public OverridesNested<A> editMatchingOverride(Predicate<BrokerCapacityOverrideBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.overrides.size(); ++i) {
            if (!predicate.test(this.overrides.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching overrides. No match found.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BrokerCapacityFluent that = (BrokerCapacityFluent)((Object)o);
        if (!Objects.equals(this.disk, that.disk)) {
            return false;
        }
        if (!Objects.equals(this.cpuUtilization, that.cpuUtilization)) {
            return false;
        }
        if (!Objects.equals(this.cpu, that.cpu)) {
            return false;
        }
        if (!Objects.equals(this.inboundNetwork, that.inboundNetwork)) {
            return false;
        }
        if (!Objects.equals(this.outboundNetwork, that.outboundNetwork)) {
            return false;
        }
        return Objects.equals(this.overrides, that.overrides);
    }

    public int hashCode() {
        return Objects.hash(this.disk, this.cpuUtilization, this.cpu, this.inboundNetwork, this.outboundNetwork, this.overrides, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.disk != null) {
            sb.append("disk:");
            sb.append(this.disk + ",");
        }
        if (this.cpuUtilization != null) {
            sb.append("cpuUtilization:");
            sb.append(this.cpuUtilization + ",");
        }
        if (this.cpu != null) {
            sb.append("cpu:");
            sb.append(this.cpu + ",");
        }
        if (this.inboundNetwork != null) {
            sb.append("inboundNetwork:");
            sb.append(this.inboundNetwork + ",");
        }
        if (this.outboundNetwork != null) {
            sb.append("outboundNetwork:");
            sb.append(this.outboundNetwork + ",");
        }
        if (this.overrides != null && !this.overrides.isEmpty()) {
            sb.append("overrides:");
            sb.append(this.overrides);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OverridesNested<N>
    extends BrokerCapacityOverrideFluent<OverridesNested<N>>
    implements Nested<N> {
        BrokerCapacityOverrideBuilder builder;
        int index;

        OverridesNested(int index, BrokerCapacityOverride item) {
            this.index = index;
            this.builder = new BrokerCapacityOverrideBuilder(this, item);
        }

        public N and() {
            return (N)BrokerCapacityFluent.this.setToOverrides(this.index, this.builder.build());
        }

        public N endOverride() {
            return this.and();
        }
    }
}

