/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.listener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.CertAndKeySecretSource;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.common.template.ExternalTrafficPolicy;
import io.strimzi.api.kafka.model.common.template.IpFamily;
import io.strimzi.api.kafka.model.common.template.IpFamilyPolicy;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationBootstrap;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationBroker;
import io.strimzi.api.kafka.model.kafka.listener.NodeAddressType;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.PresentInVersions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DescriptionFile
@JsonPropertyOrder(value={"brokerCertChainAndKey", "class", "preferredAddressType", "externalTrafficPolicy", "loadBalancerSourceRanges", "bootstrap", "brokers", "ipFamilyPolicy", "ipFamilies", "createBootstrapService", "finalizers", "useServiceDnsDomain", "maxConnections", "maxConnectionCreationRate", "preferredNodePortAddressType", "publishNotReadyAddresses"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GenericKafkaListenerConfiguration
implements UnknownPropertyPreserving {
    private CertAndKeySecretSource brokerCertChainAndKey;
    private String controllerClass;
    private NodeAddressType preferredNodePortAddressType;
    private ExternalTrafficPolicy externalTrafficPolicy;
    private List<String> loadBalancerSourceRanges;
    private List<String> finalizers;
    private Boolean useServiceDnsDomain;
    private GenericKafkaListenerConfigurationBootstrap bootstrap;
    private List<GenericKafkaListenerConfigurationBroker> brokers;
    private Integer maxConnections;
    private Integer maxConnectionCreationRate;
    private IpFamilyPolicy ipFamilyPolicy;
    private List<IpFamily> ipFamilies;
    private Boolean createBootstrapService = true;
    private Boolean publishNotReadyAddresses;
    private Map<String, Object> additionalProperties;

    @Description(value="Reference to the `Secret` which holds the certificate and private key pair which will be used for this listener. The certificate can optionally contain the whole chain. This field can be used only with listeners with enabled TLS encryption.")
    public CertAndKeySecretSource getBrokerCertChainAndKey() {
        return this.brokerCertChainAndKey;
    }

    public void setBrokerCertChainAndKey(CertAndKeySecretSource brokerCertChainAndKey) {
        this.brokerCertChainAndKey = brokerCertChainAndKey;
    }

    @Description(value="Configures a specific class for `Ingress` and `LoadBalancer` that defines which controller is used. If not specified, the default controller is used.\n\n* For an `ingress` listener, the operator uses this property to set the `ingressClassName` property in the `Ingress` resources.\n* For a `loadbalancer` listener, the operator uses this property to set the `loadBalancerClass` property  in the `Service` resources.\n\nFor `ingress` and `loadbalancer` listeners only.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="class")
    public String getControllerClass() {
        return this.controllerClass;
    }

    public void setControllerClass(String controllerClass) {
        this.controllerClass = controllerClass;
    }

    @Description(value="Defines which address type should be used as the node address. Available types are: `ExternalDNS`, `ExternalIP`, `InternalDNS`, `InternalIP` and `Hostname`. By default, the addresses are used in the following order (the first one found is used):\n\n* `ExternalDNS`\n* `ExternalIP`\n* `InternalDNS`\n* `InternalIP`\n* `Hostname`\n\nThis property is used to select the preferred address type, which is checked first. If no address is found for this address type, the other types are checked in the default order.For `nodeport` listeners only.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public NodeAddressType getPreferredNodePortAddressType() {
        return this.preferredNodePortAddressType;
    }

    public void setPreferredNodePortAddressType(NodeAddressType preferredNodePortAddressType) {
        this.preferredNodePortAddressType = preferredNodePortAddressType;
    }

    @Description(value="Specifies whether the service routes external traffic to cluster-wide or node-local endpoints:\n\n* `Cluster` may cause a second hop to another node and obscures the client source IP.\n* `Local` avoids a second hop for `LoadBalancer` and `Nodeport` type services and preserves the client source IP (when supported by the infrastructure).\n\nIf unspecified, Kubernetes uses `Cluster` as the default. For `loadbalancer` or `nodeport` listeners only.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ExternalTrafficPolicy getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    public void setExternalTrafficPolicy(ExternalTrafficPolicy externalTrafficPolicy) {
        this.externalTrafficPolicy = externalTrafficPolicy;
    }

    @Description(value="A list of CIDR ranges (for example `10.0.0.0/8` or `130.211.204.1/32`) from which clients can connect to loadbalancer listeners. If supported by the platform, traffic through the loadbalancer is restricted to the specified CIDR ranges. This field is applicable only for loadbalancer type services and is ignored if the cloud provider does not support the feature. For `loadbalancer` listeners only.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    public void setLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        this.loadBalancerSourceRanges = loadBalancerSourceRanges;
    }

    @Description(value="A list of finalizers configured for the `LoadBalancer` type services created for this listener. If supported by the platform, the finalizer `service.kubernetes.io/load-balancer-cleanup` to make sure that the external load balancer is deleted together with the service.For more information, see https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/#garbage-collecting-load-balancers. For `loadbalancer` listeners only.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getFinalizers() {
        return this.finalizers;
    }

    public void setFinalizers(List<String> finalizers) {
        this.finalizers = finalizers;
    }

    @Description(value="Configures whether the Kubernetes service DNS domain should be included in the generated addresses.\n\n* If set to `false`, the generated addresses do not contain the service DNS domain suffix. For example, `my-cluster-kafka-0.my-cluster-kafka-brokers.myproject.svc`.\n* If set to `true`, the generated addresses contain the service DNS domain suffix. For example, `my-cluster-kafka-0.my-cluster-kafka-brokers.myproject.svc.cluster.local`.\n\nThe default is `.cluster.local`, but this is customizable using the environment variable `KUBERNETES_SERVICE_DNS_DOMAIN`. For `internal` and `cluster-ip` listeners only.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getUseServiceDnsDomain() {
        return this.useServiceDnsDomain;
    }

    public void setUseServiceDnsDomain(Boolean useServiceDnsDomain) {
        this.useServiceDnsDomain = useServiceDnsDomain;
    }

    @Description(value="Bootstrap configuration.")
    public GenericKafkaListenerConfigurationBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public void setBootstrap(GenericKafkaListenerConfigurationBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    @Description(value="Per-broker configurations.")
    public List<GenericKafkaListenerConfigurationBroker> getBrokers() {
        return this.brokers;
    }

    public void setBrokers(List<GenericKafkaListenerConfigurationBroker> brokers) {
        this.brokers = brokers;
    }

    @Description(value="The maximum number of connections we allow for this listener in the broker at any time. New connections are blocked if the limit is reached.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Description(value="The maximum connection creation rate we allow in this listener at any time. New connections will be throttled if the limit is reached.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMaxConnectionCreationRate() {
        return this.maxConnectionCreationRate;
    }

    public void setMaxConnectionCreationRate(Integer maxConnectionCreationRate) {
        this.maxConnectionCreationRate = maxConnectionCreationRate;
    }

    @Description(value="Specifies the IP Family Policy used by the service. Available options are `SingleStack`, `PreferDualStack` and `RequireDualStack`:\n\n* `SingleStack` is for a single IP family.\n* `PreferDualStack` is for two IP families on dual-stack configured clusters or a single IP family on single-stack clusters.\n* `RequireDualStack` fails unless there are two IP families on dual-stack configured clusters.\n\nIf unspecified, Kubernetes will choose the default value based on the service type.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @PresentInVersions(value="v1beta2+")
    public IpFamilyPolicy getIpFamilyPolicy() {
        return this.ipFamilyPolicy;
    }

    public void setIpFamilyPolicy(IpFamilyPolicy ipFamilyPolicy) {
        this.ipFamilyPolicy = ipFamilyPolicy;
    }

    @Description(value="Specifies the IP Families used by the service. Available options are `IPv4` and `IPv6`. If unspecified, Kubernetes will choose the default value based on the `ipFamilyPolicy` setting.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @PresentInVersions(value="v1beta2+")
    public List<IpFamily> getIpFamilies() {
        return this.ipFamilies;
    }

    public void setIpFamilies(List<IpFamily> ipFamilies) {
        this.ipFamilies = ipFamilies;
    }

    @Description(value="Whether to create the bootstrap service or not. The bootstrap service is created by default (if not specified differently). This field can be used with the `loadbalancer` listener.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Boolean getCreateBootstrapService() {
        return this.createBootstrapService;
    }

    public void setCreateBootstrapService(Boolean createBootstrapService) {
        this.createBootstrapService = createBootstrapService;
    }

    @Description(value="Configures whether the service endpoints are considered \"ready\" even if the Pods themselves are not. Defaults to `false`. This field can not be used with `internal` listeners.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getPublishNotReadyAddresses() {
        return this.publishNotReadyAddresses;
    }

    public void setPublishNotReadyAddresses(Boolean publishNotReadyAddresses) {
        this.publishNotReadyAddresses = publishNotReadyAddresses;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericKafkaListenerConfiguration)) {
            return false;
        }
        GenericKafkaListenerConfiguration other = (GenericKafkaListenerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$useServiceDnsDomain = this.getUseServiceDnsDomain();
        Boolean other$useServiceDnsDomain = other.getUseServiceDnsDomain();
        if (this$useServiceDnsDomain == null ? other$useServiceDnsDomain != null : !((Object)this$useServiceDnsDomain).equals(other$useServiceDnsDomain)) {
            return false;
        }
        Integer this$maxConnections = this.getMaxConnections();
        Integer other$maxConnections = other.getMaxConnections();
        if (this$maxConnections == null ? other$maxConnections != null : !((Object)this$maxConnections).equals(other$maxConnections)) {
            return false;
        }
        Integer this$maxConnectionCreationRate = this.getMaxConnectionCreationRate();
        Integer other$maxConnectionCreationRate = other.getMaxConnectionCreationRate();
        if (this$maxConnectionCreationRate == null ? other$maxConnectionCreationRate != null : !((Object)this$maxConnectionCreationRate).equals(other$maxConnectionCreationRate)) {
            return false;
        }
        Boolean this$createBootstrapService = this.getCreateBootstrapService();
        Boolean other$createBootstrapService = other.getCreateBootstrapService();
        if (this$createBootstrapService == null ? other$createBootstrapService != null : !((Object)this$createBootstrapService).equals(other$createBootstrapService)) {
            return false;
        }
        Boolean this$publishNotReadyAddresses = this.getPublishNotReadyAddresses();
        Boolean other$publishNotReadyAddresses = other.getPublishNotReadyAddresses();
        if (this$publishNotReadyAddresses == null ? other$publishNotReadyAddresses != null : !((Object)this$publishNotReadyAddresses).equals(other$publishNotReadyAddresses)) {
            return false;
        }
        CertAndKeySecretSource this$brokerCertChainAndKey = this.getBrokerCertChainAndKey();
        CertAndKeySecretSource other$brokerCertChainAndKey = other.getBrokerCertChainAndKey();
        if (this$brokerCertChainAndKey == null ? other$brokerCertChainAndKey != null : !((Object)this$brokerCertChainAndKey).equals(other$brokerCertChainAndKey)) {
            return false;
        }
        String this$controllerClass = this.getControllerClass();
        String other$controllerClass = other.getControllerClass();
        if (this$controllerClass == null ? other$controllerClass != null : !this$controllerClass.equals(other$controllerClass)) {
            return false;
        }
        NodeAddressType this$preferredNodePortAddressType = this.getPreferredNodePortAddressType();
        NodeAddressType other$preferredNodePortAddressType = other.getPreferredNodePortAddressType();
        if (this$preferredNodePortAddressType == null ? other$preferredNodePortAddressType != null : !((Object)((Object)this$preferredNodePortAddressType)).equals((Object)other$preferredNodePortAddressType)) {
            return false;
        }
        ExternalTrafficPolicy this$externalTrafficPolicy = this.getExternalTrafficPolicy();
        ExternalTrafficPolicy other$externalTrafficPolicy = other.getExternalTrafficPolicy();
        if (this$externalTrafficPolicy == null ? other$externalTrafficPolicy != null : !((Object)((Object)this$externalTrafficPolicy)).equals((Object)other$externalTrafficPolicy)) {
            return false;
        }
        List<String> this$loadBalancerSourceRanges = this.getLoadBalancerSourceRanges();
        List<String> other$loadBalancerSourceRanges = other.getLoadBalancerSourceRanges();
        if (this$loadBalancerSourceRanges == null ? other$loadBalancerSourceRanges != null : !((Object)this$loadBalancerSourceRanges).equals(other$loadBalancerSourceRanges)) {
            return false;
        }
        List<String> this$finalizers = this.getFinalizers();
        List<String> other$finalizers = other.getFinalizers();
        if (this$finalizers == null ? other$finalizers != null : !((Object)this$finalizers).equals(other$finalizers)) {
            return false;
        }
        GenericKafkaListenerConfigurationBootstrap this$bootstrap = this.getBootstrap();
        GenericKafkaListenerConfigurationBootstrap other$bootstrap = other.getBootstrap();
        if (this$bootstrap == null ? other$bootstrap != null : !((Object)this$bootstrap).equals(other$bootstrap)) {
            return false;
        }
        List<GenericKafkaListenerConfigurationBroker> this$brokers = this.getBrokers();
        List<GenericKafkaListenerConfigurationBroker> other$brokers = other.getBrokers();
        if (this$brokers == null ? other$brokers != null : !((Object)this$brokers).equals(other$brokers)) {
            return false;
        }
        IpFamilyPolicy this$ipFamilyPolicy = this.getIpFamilyPolicy();
        IpFamilyPolicy other$ipFamilyPolicy = other.getIpFamilyPolicy();
        if (this$ipFamilyPolicy == null ? other$ipFamilyPolicy != null : !((Object)((Object)this$ipFamilyPolicy)).equals((Object)other$ipFamilyPolicy)) {
            return false;
        }
        List<IpFamily> this$ipFamilies = this.getIpFamilies();
        List<IpFamily> other$ipFamilies = other.getIpFamilies();
        if (this$ipFamilies == null ? other$ipFamilies != null : !((Object)this$ipFamilies).equals(other$ipFamilies)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericKafkaListenerConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useServiceDnsDomain = this.getUseServiceDnsDomain();
        result = result * 59 + ($useServiceDnsDomain == null ? 43 : ((Object)$useServiceDnsDomain).hashCode());
        Integer $maxConnections = this.getMaxConnections();
        result = result * 59 + ($maxConnections == null ? 43 : ((Object)$maxConnections).hashCode());
        Integer $maxConnectionCreationRate = this.getMaxConnectionCreationRate();
        result = result * 59 + ($maxConnectionCreationRate == null ? 43 : ((Object)$maxConnectionCreationRate).hashCode());
        Boolean $createBootstrapService = this.getCreateBootstrapService();
        result = result * 59 + ($createBootstrapService == null ? 43 : ((Object)$createBootstrapService).hashCode());
        Boolean $publishNotReadyAddresses = this.getPublishNotReadyAddresses();
        result = result * 59 + ($publishNotReadyAddresses == null ? 43 : ((Object)$publishNotReadyAddresses).hashCode());
        CertAndKeySecretSource $brokerCertChainAndKey = this.getBrokerCertChainAndKey();
        result = result * 59 + ($brokerCertChainAndKey == null ? 43 : ((Object)$brokerCertChainAndKey).hashCode());
        String $controllerClass = this.getControllerClass();
        result = result * 59 + ($controllerClass == null ? 43 : $controllerClass.hashCode());
        NodeAddressType $preferredNodePortAddressType = this.getPreferredNodePortAddressType();
        result = result * 59 + ($preferredNodePortAddressType == null ? 43 : ((Object)((Object)$preferredNodePortAddressType)).hashCode());
        ExternalTrafficPolicy $externalTrafficPolicy = this.getExternalTrafficPolicy();
        result = result * 59 + ($externalTrafficPolicy == null ? 43 : ((Object)((Object)$externalTrafficPolicy)).hashCode());
        List<String> $loadBalancerSourceRanges = this.getLoadBalancerSourceRanges();
        result = result * 59 + ($loadBalancerSourceRanges == null ? 43 : ((Object)$loadBalancerSourceRanges).hashCode());
        List<String> $finalizers = this.getFinalizers();
        result = result * 59 + ($finalizers == null ? 43 : ((Object)$finalizers).hashCode());
        GenericKafkaListenerConfigurationBootstrap $bootstrap = this.getBootstrap();
        result = result * 59 + ($bootstrap == null ? 43 : ((Object)$bootstrap).hashCode());
        List<GenericKafkaListenerConfigurationBroker> $brokers = this.getBrokers();
        result = result * 59 + ($brokers == null ? 43 : ((Object)$brokers).hashCode());
        IpFamilyPolicy $ipFamilyPolicy = this.getIpFamilyPolicy();
        result = result * 59 + ($ipFamilyPolicy == null ? 43 : ((Object)((Object)$ipFamilyPolicy)).hashCode());
        List<IpFamily> $ipFamilies = this.getIpFamilies();
        result = result * 59 + ($ipFamilies == null ? 43 : ((Object)$ipFamilies).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "GenericKafkaListenerConfiguration(brokerCertChainAndKey=" + this.getBrokerCertChainAndKey() + ", controllerClass=" + this.getControllerClass() + ", preferredNodePortAddressType=" + this.getPreferredNodePortAddressType() + ", externalTrafficPolicy=" + this.getExternalTrafficPolicy() + ", loadBalancerSourceRanges=" + this.getLoadBalancerSourceRanges() + ", finalizers=" + this.getFinalizers() + ", useServiceDnsDomain=" + this.getUseServiceDnsDomain() + ", bootstrap=" + this.getBootstrap() + ", brokers=" + this.getBrokers() + ", maxConnections=" + this.getMaxConnections() + ", maxConnectionCreationRate=" + this.getMaxConnectionCreationRate() + ", ipFamilyPolicy=" + this.getIpFamilyPolicy() + ", ipFamilies=" + this.getIpFamilies() + ", createBootstrapService=" + this.getCreateBootstrapService() + ", publishNotReadyAddresses=" + this.getPublishNotReadyAddresses() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }
}

