/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.mirrormaker2;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.connect.AbstractKafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2ClusterSpec;
import io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2ClusterSpecBuilder;
import io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2ClusterSpecFluent;
import io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2MirrorSpec;
import io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2MirrorSpecBuilder;
import io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2MirrorSpecFluent;
import io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2Spec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaMirrorMaker2SpecFluent<A extends KafkaMirrorMaker2SpecFluent<A>>
extends AbstractKafkaConnectSpecFluent<A> {
    private ArrayList<KafkaMirrorMaker2ClusterSpecBuilder> clusters;
    private String connectCluster;
    private ArrayList<KafkaMirrorMaker2MirrorSpecBuilder> mirrors;

    public KafkaMirrorMaker2SpecFluent() {
    }

    public KafkaMirrorMaker2SpecFluent(KafkaMirrorMaker2Spec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaMirrorMaker2Spec instance) {
        KafkaMirrorMaker2Spec kafkaMirrorMaker2Spec = instance = instance != null ? instance : new KafkaMirrorMaker2Spec();
        if (instance != null) {
            this.withClusters(instance.getClusters());
            this.withConnectCluster(instance.getConnectCluster());
            this.withMirrors(instance.getMirrors());
            this.withLogging(instance.getLogging());
            this.withReplicas(instance.getReplicas());
            this.withVersion(instance.getVersion());
            this.withImage(instance.getImage());
            this.withResources(instance.getResources());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withJmxOptions(instance.getJmxOptions());
            this.withJvmOptions(instance.getJvmOptions());
            this.withMetricsConfig(instance.getMetricsConfig());
            this.withTracing(instance.getTracing());
            this.withTemplate(instance.getTemplate());
            this.withExternalConfiguration(instance.getExternalConfiguration());
            this.withClientRackInitImage(instance.getClientRackInitImage());
            this.withRack(instance.getRack());
        }
    }

    public A addToClusters(int index, KafkaMirrorMaker2ClusterSpec item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
        if (index < 0 || index >= this.clusters.size()) {
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        } else {
            this._visitables.get((Object)"clusters").add(index, builder);
            this.clusters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToClusters(int index, KafkaMirrorMaker2ClusterSpec item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
        if (index < 0 || index >= this.clusters.size()) {
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        } else {
            this._visitables.get((Object)"clusters").set(index, builder);
            this.clusters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToClusters(KafkaMirrorMaker2ClusterSpec ... items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        for (KafkaMirrorMaker2ClusterSpec item : items) {
            KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToClusters(Collection<KafkaMirrorMaker2ClusterSpec> items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        for (KafkaMirrorMaker2ClusterSpec item : items) {
            KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromClusters(KafkaMirrorMaker2ClusterSpec ... items) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        for (KafkaMirrorMaker2ClusterSpec item : items) {
            KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
            this._visitables.get((Object)"clusters").remove((Object)builder);
            this.clusters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusters(Collection<KafkaMirrorMaker2ClusterSpec> items) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        for (KafkaMirrorMaker2ClusterSpec item : items) {
            KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
            this._visitables.get((Object)"clusters").remove((Object)builder);
            this.clusters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromClusters(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        Iterator<KafkaMirrorMaker2ClusterSpecBuilder> each = this.clusters.iterator();
        List visitables = this._visitables.get((Object)"clusters");
        while (each.hasNext()) {
            KafkaMirrorMaker2ClusterSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<KafkaMirrorMaker2ClusterSpec> buildClusters() {
        return this.clusters != null ? KafkaMirrorMaker2SpecFluent.build(this.clusters) : null;
    }

    public KafkaMirrorMaker2ClusterSpec buildCluster(int index) {
        return this.clusters.get(index).build();
    }

    public KafkaMirrorMaker2ClusterSpec buildFirstCluster() {
        return this.clusters.get(0).build();
    }

    public KafkaMirrorMaker2ClusterSpec buildLastCluster() {
        return this.clusters.get(this.clusters.size() - 1).build();
    }

    public KafkaMirrorMaker2ClusterSpec buildMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        for (KafkaMirrorMaker2ClusterSpecBuilder item : this.clusters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        for (KafkaMirrorMaker2ClusterSpecBuilder item : this.clusters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusters(List<KafkaMirrorMaker2ClusterSpec> clusters) {
        if (this.clusters != null) {
            this._visitables.get((Object)"clusters").clear();
        }
        if (clusters != null) {
            this.clusters = new ArrayList();
            for (KafkaMirrorMaker2ClusterSpec item : clusters) {
                this.addToClusters(item);
            }
        } else {
            this.clusters = null;
        }
        return (A)((Object)this);
    }

    public A withClusters(KafkaMirrorMaker2ClusterSpec ... clusters) {
        if (this.clusters != null) {
            this.clusters.clear();
            this._visitables.remove((Object)"clusters");
        }
        if (clusters != null) {
            for (KafkaMirrorMaker2ClusterSpec item : clusters) {
                this.addToClusters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusters() {
        return this.clusters != null && !this.clusters.isEmpty();
    }

    public ClustersNested<A> addNewCluster() {
        return new ClustersNested(-1, null);
    }

    public ClustersNested<A> addNewClusterLike(KafkaMirrorMaker2ClusterSpec item) {
        return new ClustersNested(-1, item);
    }

    public ClustersNested<A> setNewClusterLike(int index, KafkaMirrorMaker2ClusterSpec item) {
        return new ClustersNested(index, item);
    }

    public ClustersNested<A> editCluster(int index) {
        if (this.clusters.size() <= index) {
            throw new RuntimeException("Can't edit clusters. Index exceeds size.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public ClustersNested<A> editFirstCluster() {
        if (this.clusters.size() == 0) {
            throw new RuntimeException("Can't edit first clusters. The list is empty.");
        }
        return this.setNewClusterLike(0, this.buildCluster(0));
    }

    public ClustersNested<A> editLastCluster() {
        int index = this.clusters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusters. The list is empty.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public ClustersNested<A> editMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (!predicate.test(this.clusters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusters. No match found.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public String getConnectCluster() {
        return this.connectCluster;
    }

    public A withConnectCluster(String connectCluster) {
        this.connectCluster = connectCluster;
        return (A)((Object)this);
    }

    public boolean hasConnectCluster() {
        return this.connectCluster != null;
    }

    public A addToMirrors(int index, KafkaMirrorMaker2MirrorSpec item) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList();
        }
        KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
        if (index < 0 || index >= this.mirrors.size()) {
            this._visitables.get((Object)"mirrors").add(builder);
            this.mirrors.add(builder);
        } else {
            this._visitables.get((Object)"mirrors").add(index, builder);
            this.mirrors.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMirrors(int index, KafkaMirrorMaker2MirrorSpec item) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList();
        }
        KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
        if (index < 0 || index >= this.mirrors.size()) {
            this._visitables.get((Object)"mirrors").add(builder);
            this.mirrors.add(builder);
        } else {
            this._visitables.get((Object)"mirrors").set(index, builder);
            this.mirrors.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMirrors(KafkaMirrorMaker2MirrorSpec ... items) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList();
        }
        for (KafkaMirrorMaker2MirrorSpec item : items) {
            KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
            this._visitables.get((Object)"mirrors").add(builder);
            this.mirrors.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMirrors(Collection<KafkaMirrorMaker2MirrorSpec> items) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList();
        }
        for (KafkaMirrorMaker2MirrorSpec item : items) {
            KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
            this._visitables.get((Object)"mirrors").add(builder);
            this.mirrors.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMirrors(KafkaMirrorMaker2MirrorSpec ... items) {
        if (this.mirrors == null) {
            return (A)((Object)this);
        }
        for (KafkaMirrorMaker2MirrorSpec item : items) {
            KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
            this._visitables.get((Object)"mirrors").remove((Object)builder);
            this.mirrors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMirrors(Collection<KafkaMirrorMaker2MirrorSpec> items) {
        if (this.mirrors == null) {
            return (A)((Object)this);
        }
        for (KafkaMirrorMaker2MirrorSpec item : items) {
            KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
            this._visitables.get((Object)"mirrors").remove((Object)builder);
            this.mirrors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMirrors(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        if (this.mirrors == null) {
            return (A)((Object)this);
        }
        Iterator<KafkaMirrorMaker2MirrorSpecBuilder> each = this.mirrors.iterator();
        List visitables = this._visitables.get((Object)"mirrors");
        while (each.hasNext()) {
            KafkaMirrorMaker2MirrorSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<KafkaMirrorMaker2MirrorSpec> buildMirrors() {
        return this.mirrors != null ? KafkaMirrorMaker2SpecFluent.build(this.mirrors) : null;
    }

    public KafkaMirrorMaker2MirrorSpec buildMirror(int index) {
        return this.mirrors.get(index).build();
    }

    public KafkaMirrorMaker2MirrorSpec buildFirstMirror() {
        return this.mirrors.get(0).build();
    }

    public KafkaMirrorMaker2MirrorSpec buildLastMirror() {
        return this.mirrors.get(this.mirrors.size() - 1).build();
    }

    public KafkaMirrorMaker2MirrorSpec buildMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        for (KafkaMirrorMaker2MirrorSpecBuilder item : this.mirrors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        for (KafkaMirrorMaker2MirrorSpecBuilder item : this.mirrors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMirrors(List<KafkaMirrorMaker2MirrorSpec> mirrors) {
        if (this.mirrors != null) {
            this._visitables.get((Object)"mirrors").clear();
        }
        if (mirrors != null) {
            this.mirrors = new ArrayList();
            for (KafkaMirrorMaker2MirrorSpec item : mirrors) {
                this.addToMirrors(item);
            }
        } else {
            this.mirrors = null;
        }
        return (A)((Object)this);
    }

    public A withMirrors(KafkaMirrorMaker2MirrorSpec ... mirrors) {
        if (this.mirrors != null) {
            this.mirrors.clear();
            this._visitables.remove((Object)"mirrors");
        }
        if (mirrors != null) {
            for (KafkaMirrorMaker2MirrorSpec item : mirrors) {
                this.addToMirrors(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMirrors() {
        return this.mirrors != null && !this.mirrors.isEmpty();
    }

    public MirrorsNested<A> addNewMirror() {
        return new MirrorsNested(-1, null);
    }

    public MirrorsNested<A> addNewMirrorLike(KafkaMirrorMaker2MirrorSpec item) {
        return new MirrorsNested(-1, item);
    }

    public MirrorsNested<A> setNewMirrorLike(int index, KafkaMirrorMaker2MirrorSpec item) {
        return new MirrorsNested(index, item);
    }

    public MirrorsNested<A> editMirror(int index) {
        if (this.mirrors.size() <= index) {
            throw new RuntimeException("Can't edit mirrors. Index exceeds size.");
        }
        return this.setNewMirrorLike(index, this.buildMirror(index));
    }

    public MirrorsNested<A> editFirstMirror() {
        if (this.mirrors.size() == 0) {
            throw new RuntimeException("Can't edit first mirrors. The list is empty.");
        }
        return this.setNewMirrorLike(0, this.buildMirror(0));
    }

    public MirrorsNested<A> editLastMirror() {
        int index = this.mirrors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last mirrors. The list is empty.");
        }
        return this.setNewMirrorLike(index, this.buildMirror(index));
    }

    public MirrorsNested<A> editMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.mirrors.size(); ++i) {
            if (!predicate.test(this.mirrors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching mirrors. No match found.");
        }
        return this.setNewMirrorLike(index, this.buildMirror(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaMirrorMaker2SpecFluent that = (KafkaMirrorMaker2SpecFluent)((Object)o);
        if (!Objects.equals(this.clusters, that.clusters)) {
            return false;
        }
        if (!Objects.equals(this.connectCluster, that.connectCluster)) {
            return false;
        }
        return Objects.equals(this.mirrors, that.mirrors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusters, this.connectCluster, this.mirrors, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusters != null && !this.clusters.isEmpty()) {
            sb.append("clusters:");
            sb.append(this.clusters + ",");
        }
        if (this.connectCluster != null) {
            sb.append("connectCluster:");
            sb.append(this.connectCluster + ",");
        }
        if (this.mirrors != null && !this.mirrors.isEmpty()) {
            sb.append("mirrors:");
            sb.append(this.mirrors);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClustersNested<N>
    extends KafkaMirrorMaker2ClusterSpecFluent<ClustersNested<N>>
    implements Nested<N> {
        KafkaMirrorMaker2ClusterSpecBuilder builder;
        int index;

        ClustersNested(int index, KafkaMirrorMaker2ClusterSpec item) {
            this.index = index;
            this.builder = new KafkaMirrorMaker2ClusterSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMaker2SpecFluent.this.setToClusters(this.index, this.builder.build());
        }

        public N endCluster() {
            return this.and();
        }
    }

    public class MirrorsNested<N>
    extends KafkaMirrorMaker2MirrorSpecFluent<MirrorsNested<N>>
    implements Nested<N> {
        KafkaMirrorMaker2MirrorSpecBuilder builder;
        int index;

        MirrorsNested(int index, KafkaMirrorMaker2MirrorSpec item) {
            this.index = index;
            this.builder = new KafkaMirrorMaker2MirrorSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMaker2SpecFluent.this.setToMirrors(this.index, this.builder.build());
        }

        public N endMirror() {
            return this.and();
        }
    }
}

