/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.mirrormaker2;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.connect.KafkaConnectStatusFluent;
import io.strimzi.api.kafka.model.connector.AutoRestartStatus;
import io.strimzi.api.kafka.model.connector.AutoRestartStatusBuilder;
import io.strimzi.api.kafka.model.connector.AutoRestartStatusFluent;
import io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaMirrorMaker2StatusFluent<A extends KafkaMirrorMaker2StatusFluent<A>>
extends KafkaConnectStatusFluent<A> {
    private List<Map<String, Object>> connectors;
    private ArrayList<AutoRestartStatusBuilder> autoRestartStatuses;

    public KafkaMirrorMaker2StatusFluent() {
    }

    public KafkaMirrorMaker2StatusFluent(KafkaMirrorMaker2Status instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaMirrorMaker2Status instance) {
        KafkaMirrorMaker2Status kafkaMirrorMaker2Status = instance = instance != null ? instance : new KafkaMirrorMaker2Status();
        if (instance != null) {
            this.withConnectors(instance.getConnectors());
            this.withAutoRestartStatuses(instance.getAutoRestartStatuses());
            this.withUrl(instance.getUrl());
            this.withConnectorPlugins(instance.getConnectorPlugins());
            this.withReplicas(instance.getReplicas());
            this.withLabelSelector(instance.getLabelSelector());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
        }
    }

    public A addToConnectors(int index, Map<String, Object> item) {
        if (this.connectors == null) {
            this.connectors = new ArrayList<Map<String, Object>>();
        }
        this.connectors.add(index, item);
        return (A)((Object)this);
    }

    public A setToConnectors(int index, Map<String, Object> item) {
        if (this.connectors == null) {
            this.connectors = new ArrayList<Map<String, Object>>();
        }
        this.connectors.set(index, item);
        return (A)((Object)this);
    }

    public A addToConnectors(Map<String, Object> ... items) {
        if (this.connectors == null) {
            this.connectors = new ArrayList<Map<String, Object>>();
        }
        for (Map<String, Object> item : items) {
            this.connectors.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConnectors(Collection<Map<String, Object>> items) {
        if (this.connectors == null) {
            this.connectors = new ArrayList<Map<String, Object>>();
        }
        for (Map<String, Object> item : items) {
            this.connectors.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConnectors(Map<String, Object> ... items) {
        if (this.connectors == null) {
            return (A)((Object)this);
        }
        for (Map<String, Object> item : items) {
            this.connectors.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConnectors(Collection<Map<String, Object>> items) {
        if (this.connectors == null) {
            return (A)((Object)this);
        }
        for (Map<String, Object> item : items) {
            this.connectors.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Map<String, Object>> getConnectors() {
        return this.connectors;
    }

    public Map<String, Object> getConnector(int index) {
        return this.connectors.get(index);
    }

    public Map<String, Object> getFirstConnector() {
        return this.connectors.get(0);
    }

    public Map<String, Object> getLastConnector() {
        return this.connectors.get(this.connectors.size() - 1);
    }

    public Map<String, Object> getMatchingConnector(Predicate<Map<String, Object>> predicate) {
        for (Map<String, Object> item : this.connectors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingConnector(Predicate<Map<String, Object>> predicate) {
        for (Map<String, Object> item : this.connectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public <K, V> A withConnectors(List<Map<String, Object>> connectors) {
        if (connectors != null) {
            this.connectors = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> item : connectors) {
                this.addToConnectors(item);
            }
        } else {
            this.connectors = null;
        }
        return (A)((Object)this);
    }

    public A withConnectors(Map<String, Object> ... connectors) {
        if (this.connectors != null) {
            this.connectors.clear();
            this._visitables.remove((Object)"connectors");
        }
        if (connectors != null) {
            for (Map<String, Object> item : connectors) {
                this.addToConnectors(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConnectors() {
        return this.connectors != null && !this.connectors.isEmpty();
    }

    public A addToAutoRestartStatuses(int index, AutoRestartStatus item) {
        if (this.autoRestartStatuses == null) {
            this.autoRestartStatuses = new ArrayList();
        }
        AutoRestartStatusBuilder builder = new AutoRestartStatusBuilder(item);
        if (index < 0 || index >= this.autoRestartStatuses.size()) {
            this._visitables.get((Object)"autoRestartStatuses").add(builder);
            this.autoRestartStatuses.add(builder);
        } else {
            this._visitables.get((Object)"autoRestartStatuses").add(index, builder);
            this.autoRestartStatuses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAutoRestartStatuses(int index, AutoRestartStatus item) {
        if (this.autoRestartStatuses == null) {
            this.autoRestartStatuses = new ArrayList();
        }
        AutoRestartStatusBuilder builder = new AutoRestartStatusBuilder(item);
        if (index < 0 || index >= this.autoRestartStatuses.size()) {
            this._visitables.get((Object)"autoRestartStatuses").add(builder);
            this.autoRestartStatuses.add(builder);
        } else {
            this._visitables.get((Object)"autoRestartStatuses").set(index, builder);
            this.autoRestartStatuses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAutoRestartStatuses(AutoRestartStatus ... items) {
        if (this.autoRestartStatuses == null) {
            this.autoRestartStatuses = new ArrayList();
        }
        for (AutoRestartStatus item : items) {
            AutoRestartStatusBuilder builder = new AutoRestartStatusBuilder(item);
            this._visitables.get((Object)"autoRestartStatuses").add(builder);
            this.autoRestartStatuses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAutoRestartStatuses(Collection<AutoRestartStatus> items) {
        if (this.autoRestartStatuses == null) {
            this.autoRestartStatuses = new ArrayList();
        }
        for (AutoRestartStatus item : items) {
            AutoRestartStatusBuilder builder = new AutoRestartStatusBuilder(item);
            this._visitables.get((Object)"autoRestartStatuses").add(builder);
            this.autoRestartStatuses.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAutoRestartStatuses(AutoRestartStatus ... items) {
        if (this.autoRestartStatuses == null) {
            return (A)((Object)this);
        }
        for (AutoRestartStatus item : items) {
            AutoRestartStatusBuilder builder = new AutoRestartStatusBuilder(item);
            this._visitables.get((Object)"autoRestartStatuses").remove((Object)builder);
            this.autoRestartStatuses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAutoRestartStatuses(Collection<AutoRestartStatus> items) {
        if (this.autoRestartStatuses == null) {
            return (A)((Object)this);
        }
        for (AutoRestartStatus item : items) {
            AutoRestartStatusBuilder builder = new AutoRestartStatusBuilder(item);
            this._visitables.get((Object)"autoRestartStatuses").remove((Object)builder);
            this.autoRestartStatuses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAutoRestartStatuses(Predicate<AutoRestartStatusBuilder> predicate) {
        if (this.autoRestartStatuses == null) {
            return (A)((Object)this);
        }
        Iterator<AutoRestartStatusBuilder> each = this.autoRestartStatuses.iterator();
        List visitables = this._visitables.get((Object)"autoRestartStatuses");
        while (each.hasNext()) {
            AutoRestartStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AutoRestartStatus> buildAutoRestartStatuses() {
        return this.autoRestartStatuses != null ? KafkaMirrorMaker2StatusFluent.build(this.autoRestartStatuses) : null;
    }

    public AutoRestartStatus buildAutoRestartStatus(int index) {
        return this.autoRestartStatuses.get(index).build();
    }

    public AutoRestartStatus buildFirstAutoRestartStatus() {
        return this.autoRestartStatuses.get(0).build();
    }

    public AutoRestartStatus buildLastAutoRestartStatus() {
        return this.autoRestartStatuses.get(this.autoRestartStatuses.size() - 1).build();
    }

    public AutoRestartStatus buildMatchingAutoRestartStatus(Predicate<AutoRestartStatusBuilder> predicate) {
        for (AutoRestartStatusBuilder item : this.autoRestartStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAutoRestartStatus(Predicate<AutoRestartStatusBuilder> predicate) {
        for (AutoRestartStatusBuilder item : this.autoRestartStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAutoRestartStatuses(List<AutoRestartStatus> autoRestartStatuses) {
        if (this.autoRestartStatuses != null) {
            this._visitables.get((Object)"autoRestartStatuses").clear();
        }
        if (autoRestartStatuses != null) {
            this.autoRestartStatuses = new ArrayList();
            for (AutoRestartStatus item : autoRestartStatuses) {
                this.addToAutoRestartStatuses(item);
            }
        } else {
            this.autoRestartStatuses = null;
        }
        return (A)((Object)this);
    }

    public A withAutoRestartStatuses(AutoRestartStatus ... autoRestartStatuses) {
        if (this.autoRestartStatuses != null) {
            this.autoRestartStatuses.clear();
            this._visitables.remove((Object)"autoRestartStatuses");
        }
        if (autoRestartStatuses != null) {
            for (AutoRestartStatus item : autoRestartStatuses) {
                this.addToAutoRestartStatuses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAutoRestartStatuses() {
        return this.autoRestartStatuses != null && !this.autoRestartStatuses.isEmpty();
    }

    public AutoRestartStatusesNested<A> addNewAutoRestartStatus() {
        return new AutoRestartStatusesNested(-1, null);
    }

    public AutoRestartStatusesNested<A> addNewAutoRestartStatusLike(AutoRestartStatus item) {
        return new AutoRestartStatusesNested(-1, item);
    }

    public AutoRestartStatusesNested<A> setNewAutoRestartStatusLike(int index, AutoRestartStatus item) {
        return new AutoRestartStatusesNested(index, item);
    }

    public AutoRestartStatusesNested<A> editAutoRestartStatus(int index) {
        if (this.autoRestartStatuses.size() <= index) {
            throw new RuntimeException("Can't edit autoRestartStatuses. Index exceeds size.");
        }
        return this.setNewAutoRestartStatusLike(index, this.buildAutoRestartStatus(index));
    }

    public AutoRestartStatusesNested<A> editFirstAutoRestartStatus() {
        if (this.autoRestartStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first autoRestartStatuses. The list is empty.");
        }
        return this.setNewAutoRestartStatusLike(0, this.buildAutoRestartStatus(0));
    }

    public AutoRestartStatusesNested<A> editLastAutoRestartStatus() {
        int index = this.autoRestartStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last autoRestartStatuses. The list is empty.");
        }
        return this.setNewAutoRestartStatusLike(index, this.buildAutoRestartStatus(index));
    }

    public AutoRestartStatusesNested<A> editMatchingAutoRestartStatus(Predicate<AutoRestartStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.autoRestartStatuses.size(); ++i) {
            if (!predicate.test(this.autoRestartStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching autoRestartStatuses. No match found.");
        }
        return this.setNewAutoRestartStatusLike(index, this.buildAutoRestartStatus(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaMirrorMaker2StatusFluent that = (KafkaMirrorMaker2StatusFluent)((Object)o);
        if (!Objects.equals(this.connectors, that.connectors)) {
            return false;
        }
        return Objects.equals(this.autoRestartStatuses, that.autoRestartStatuses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.connectors, this.autoRestartStatuses, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.connectors != null && !this.connectors.isEmpty()) {
            sb.append("connectors:");
            sb.append(this.connectors + ",");
        }
        if (this.autoRestartStatuses != null && !this.autoRestartStatuses.isEmpty()) {
            sb.append("autoRestartStatuses:");
            sb.append(this.autoRestartStatuses);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AutoRestartStatusesNested<N>
    extends AutoRestartStatusFluent<AutoRestartStatusesNested<N>>
    implements Nested<N> {
        AutoRestartStatusBuilder builder;
        int index;

        AutoRestartStatusesNested(int index, AutoRestartStatus item) {
            this.index = index;
            this.builder = new AutoRestartStatusBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMaker2StatusFluent.this.setToAutoRestartStatuses(this.index, this.builder.build());
        }

        public N endAutoRestartStatus() {
            return this.and();
        }
    }
}

