/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.nodepool;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.kafka.Status;
import io.strimzi.api.kafka.model.nodepool.ProcessRoles;
import io.strimzi.crdgenerator.annotations.AddedIn;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"conditions", "observedGeneration", "nodeIds", "clusterId", "roles", "replicas", "labelSelector"})
public class KafkaNodePoolStatus
extends Status {
    private List<Integer> nodeIds;
    private String clusterId;
    private List<ProcessRoles> roles;
    private int replicas;
    private String labelSelector;

    @Description(value="Node IDs used by Kafka nodes in this pool")
    public List<Integer> getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(List<Integer> nodeIds) {
        this.nodeIds = nodeIds;
    }

    @Description(value="Kafka cluster ID")
    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @AddedIn(value="0.39.0")
    @Description(value="The roles currently assigned to this pool.")
    public List<ProcessRoles> getRoles() {
        return this.roles;
    }

    public void setRoles(List<ProcessRoles> roles) {
        this.roles = roles;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="The current number of pods being used to provide this resource.")
    public int getReplicas() {
        return this.replicas;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="Label selector for pods providing this resource.")
    public String getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(String labelSelector) {
        this.labelSelector = labelSelector;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaNodePoolStatus)) {
            return false;
        }
        KafkaNodePoolStatus other = (KafkaNodePoolStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getReplicas() != other.getReplicas()) {
            return false;
        }
        List<Integer> this$nodeIds = this.getNodeIds();
        List<Integer> other$nodeIds = other.getNodeIds();
        if (this$nodeIds == null ? other$nodeIds != null : !((Object)this$nodeIds).equals(other$nodeIds)) {
            return false;
        }
        String this$clusterId = this.getClusterId();
        String other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        List<ProcessRoles> this$roles = this.getRoles();
        List<ProcessRoles> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        String this$labelSelector = this.getLabelSelector();
        String other$labelSelector = other.getLabelSelector();
        return !(this$labelSelector == null ? other$labelSelector != null : !this$labelSelector.equals(other$labelSelector));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaNodePoolStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getReplicas();
        List<Integer> $nodeIds = this.getNodeIds();
        result = result * 59 + ($nodeIds == null ? 43 : ((Object)$nodeIds).hashCode());
        String $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        List<ProcessRoles> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        String $labelSelector = this.getLabelSelector();
        result = result * 59 + ($labelSelector == null ? 43 : $labelSelector.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaNodePoolStatus(super=" + super.toString() + ", nodeIds=" + this.getNodeIds() + ", clusterId=" + this.getClusterId() + ", roles=" + this.getRoles() + ", replicas=" + this.getReplicas() + ", labelSelector=" + this.getLabelSelector() + ")";
    }
}

