/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.rebalance;

import io.strimzi.api.kafka.model.rebalance.KafkaRebalanceAnnotation;
import java.util.List;

public enum KafkaRebalanceState {
    New(List.of()),
    PendingProposal(List.of(KafkaRebalanceAnnotation.stop, KafkaRebalanceAnnotation.refresh)),
    ProposalReady(List.of(KafkaRebalanceAnnotation.approve, KafkaRebalanceAnnotation.refresh)),
    Rebalancing(List.of(KafkaRebalanceAnnotation.stop, KafkaRebalanceAnnotation.refresh)),
    Stopped(List.of(KafkaRebalanceAnnotation.refresh)),
    NotReady(List.of(KafkaRebalanceAnnotation.refresh)),
    Ready(List.of(KafkaRebalanceAnnotation.refresh)),
    ReconciliationPaused(List.of());

    private final List<KafkaRebalanceAnnotation> validAnnotations;

    private KafkaRebalanceState(List<KafkaRebalanceAnnotation> validAnnotations) {
        this.validAnnotations = validAnnotations;
    }

    public boolean isValidateAnnotation(KafkaRebalanceAnnotation annotation) {
        return this.validAnnotations.contains((Object)annotation);
    }

    public List<KafkaRebalanceAnnotation> getValidAnnotations() {
        return this.validAnnotations;
    }
}

