/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.topic;

import io.strimzi.api.kafka.model.common.SpecFluent;
import io.strimzi.api.kafka.model.topic.KafkaTopicSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class KafkaTopicSpecFluent<A extends KafkaTopicSpecFluent<A>>
extends SpecFluent<A> {
    private String topicName;
    private Integer partitions;
    private Integer replicas;
    private Map<String, Object> config;

    public KafkaTopicSpecFluent() {
    }

    public KafkaTopicSpecFluent(KafkaTopicSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaTopicSpec instance) {
        KafkaTopicSpec kafkaTopicSpec = instance = instance != null ? instance : new KafkaTopicSpec();
        if (instance != null) {
            this.withTopicName(instance.getTopicName());
            this.withPartitions(instance.getPartitions());
            this.withReplicas(instance.getReplicas());
            this.withConfig(instance.getConfig());
        }
    }

    public String getTopicName() {
        return this.topicName;
    }

    public A withTopicName(String topicName) {
        this.topicName = topicName;
        return (A)((Object)this);
    }

    public boolean hasTopicName() {
        return this.topicName != null;
    }

    public Integer getPartitions() {
        return this.partitions;
    }

    public A withPartitions(Integer partitions) {
        this.partitions = partitions;
        return (A)((Object)this);
    }

    public boolean hasPartitions() {
        return this.partitions != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public <K, V> A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaTopicSpecFluent that = (KafkaTopicSpecFluent)((Object)o);
        if (!Objects.equals(this.topicName, that.topicName)) {
            return false;
        }
        if (!Objects.equals(this.partitions, that.partitions)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        return Objects.equals(this.config, that.config);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.topicName, this.partitions, this.replicas, this.config, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.topicName != null) {
            sb.append("topicName:");
            sb.append(this.topicName + ",");
        }
        if (this.partitions != null) {
            sb.append("partitions:");
            sb.append(this.partitions + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.config != null && !this.config.isEmpty()) {
            sb.append("config:");
            sb.append(this.config);
        }
        sb.append("}");
        return sb.toString();
    }
}

