/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.user;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.Spec;
import io.strimzi.api.kafka.model.user.KafkaUserAuthentication;
import io.strimzi.api.kafka.model.user.KafkaUserAuthorization;
import io.strimzi.api.kafka.model.user.KafkaUserQuotas;
import io.strimzi.api.kafka.model.user.KafkaUserTemplate;
import io.strimzi.crdgenerator.annotations.Description;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"authentication", "authorization", "quotas", "template"})
public class KafkaUserSpec
extends Spec {
    private KafkaUserAuthentication authentication;
    private KafkaUserAuthorization authorization;
    private KafkaUserQuotas quotas;
    private KafkaUserTemplate template;

    @Description(value="Authentication mechanism enabled for this Kafka user. The supported authentication mechanisms are `scram-sha-512`, `tls`, and `tls-external`. \n\n* `scram-sha-512` generates a secret with SASL SCRAM-SHA-512 credentials.\n* `tls` generates a secret with user certificate for mutual TLS authentication.\n* `tls-external` does not generate a user certificate.   But prepares the user for using mutual TLS authentication using a user certificate generated outside the User Operator.\n  ACLs and quotas set for this user are configured in the `CN=<username>` format.\n\nAuthentication is optional. If authentication is not configured, no credentials are generated. ACLs and quotas set for the user are configured in the `<username>` format suitable for SASL authentication.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaUserAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(KafkaUserAuthentication authentication) {
        this.authentication = authentication;
    }

    @Description(value="Authorization rules for this Kafka user.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaUserAuthorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(KafkaUserAuthorization authorization) {
        this.authorization = authorization;
    }

    @Description(value="Quotas on requests to control the broker resources used by clients. Network bandwidth and request rate quotas can be enforced.Kafka documentation for Kafka User quotas can be found at http://kafka.apache.org/documentation/#design_quotas.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaUserQuotas getQuotas() {
        return this.quotas;
    }

    public void setQuotas(KafkaUserQuotas kafkaUserQuotas) {
        this.quotas = kafkaUserQuotas;
    }

    @Description(value="Template to specify how Kafka User `Secrets` are generated.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaUserTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(KafkaUserTemplate template) {
        this.template = template;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaUserSpec)) {
            return false;
        }
        KafkaUserSpec other = (KafkaUserSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaUserAuthentication this$authentication = this.getAuthentication();
        KafkaUserAuthentication other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication)) {
            return false;
        }
        KafkaUserAuthorization this$authorization = this.getAuthorization();
        KafkaUserAuthorization other$authorization = other.getAuthorization();
        if (this$authorization == null ? other$authorization != null : !((Object)this$authorization).equals(other$authorization)) {
            return false;
        }
        KafkaUserQuotas this$quotas = this.getQuotas();
        KafkaUserQuotas other$quotas = other.getQuotas();
        if (this$quotas == null ? other$quotas != null : !((Object)this$quotas).equals(other$quotas)) {
            return false;
        }
        KafkaUserTemplate this$template = this.getTemplate();
        KafkaUserTemplate other$template = other.getTemplate();
        return !(this$template == null ? other$template != null : !((Object)this$template).equals(other$template));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaUserSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        KafkaUserAuthentication $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
        KafkaUserAuthorization $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : ((Object)$authorization).hashCode());
        KafkaUserQuotas $quotas = this.getQuotas();
        result = result * 59 + ($quotas == null ? 43 : ((Object)$quotas).hashCode());
        KafkaUserTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaUserSpec(super=" + super.toString() + ", authentication=" + this.getAuthentication() + ", authorization=" + this.getAuthorization() + ", quotas=" + this.getQuotas() + ", template=" + this.getTemplate() + ")";
    }
}

