/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.zookeeper;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateFluent;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplate;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplate;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.PodTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplate;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplateFluent;
import io.strimzi.api.kafka.model.zookeeper.ZookeeperClusterTemplate;
import java.util.Objects;
import java.util.Optional;

public class ZookeeperClusterTemplateFluent<A extends ZookeeperClusterTemplateFluent<A>>
extends BaseFluent<A> {
    private StatefulSetTemplateBuilder statefulset;
    private ResourceTemplateBuilder podSet;
    private PodTemplateBuilder pod;
    private InternalServiceTemplateBuilder clientService;
    private InternalServiceTemplateBuilder nodesService;
    private ResourceTemplateBuilder persistentVolumeClaim;
    private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private ContainerTemplateBuilder zookeeperContainer;
    private ResourceTemplateBuilder serviceAccount;
    private ResourceTemplateBuilder jmxSecret;

    public ZookeeperClusterTemplateFluent() {
    }

    public ZookeeperClusterTemplateFluent(ZookeeperClusterTemplate instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ZookeeperClusterTemplate instance) {
        ZookeeperClusterTemplate zookeeperClusterTemplate = instance = instance != null ? instance : new ZookeeperClusterTemplate();
        if (instance != null) {
            this.withStatefulset(instance.getStatefulset());
            this.withPodSet(instance.getPodSet());
            this.withPod(instance.getPod());
            this.withClientService(instance.getClientService());
            this.withNodesService(instance.getNodesService());
            this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
            this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
            this.withZookeeperContainer(instance.getZookeeperContainer());
            this.withServiceAccount(instance.getServiceAccount());
            this.withJmxSecret(instance.getJmxSecret());
        }
    }

    public StatefulSetTemplate buildStatefulset() {
        return this.statefulset != null ? this.statefulset.build() : null;
    }

    public A withStatefulset(StatefulSetTemplate statefulset) {
        this._visitables.remove((Object)"statefulset");
        if (statefulset != null) {
            this.statefulset = new StatefulSetTemplateBuilder(statefulset);
            this._visitables.get((Object)"statefulset").add(this.statefulset);
        } else {
            this.statefulset = null;
            this._visitables.get((Object)"statefulset").remove((Object)this.statefulset);
        }
        return (A)((Object)this);
    }

    public boolean hasStatefulset() {
        return this.statefulset != null;
    }

    public StatefulsetNested<A> withNewStatefulset() {
        return new StatefulsetNested(null);
    }

    public StatefulsetNested<A> withNewStatefulsetLike(StatefulSetTemplate item) {
        return new StatefulsetNested(item);
    }

    public StatefulsetNested<A> editStatefulset() {
        return this.withNewStatefulsetLike(Optional.ofNullable(this.buildStatefulset()).orElse(null));
    }

    public StatefulsetNested<A> editOrNewStatefulset() {
        return this.withNewStatefulsetLike(Optional.ofNullable(this.buildStatefulset()).orElse(new StatefulSetTemplateBuilder().build()));
    }

    public StatefulsetNested<A> editOrNewStatefulsetLike(StatefulSetTemplate item) {
        return this.withNewStatefulsetLike(Optional.ofNullable(this.buildStatefulset()).orElse(item));
    }

    public ResourceTemplate buildPodSet() {
        return this.podSet != null ? this.podSet.build() : null;
    }

    public A withPodSet(ResourceTemplate podSet) {
        this._visitables.remove((Object)"podSet");
        if (podSet != null) {
            this.podSet = new ResourceTemplateBuilder(podSet);
            this._visitables.get((Object)"podSet").add(this.podSet);
        } else {
            this.podSet = null;
            this._visitables.get((Object)"podSet").remove((Object)this.podSet);
        }
        return (A)((Object)this);
    }

    public boolean hasPodSet() {
        return this.podSet != null;
    }

    public PodSetNested<A> withNewPodSet() {
        return new PodSetNested(null);
    }

    public PodSetNested<A> withNewPodSetLike(ResourceTemplate item) {
        return new PodSetNested(item);
    }

    public PodSetNested<A> editPodSet() {
        return this.withNewPodSetLike(Optional.ofNullable(this.buildPodSet()).orElse(null));
    }

    public PodSetNested<A> editOrNewPodSet() {
        return this.withNewPodSetLike(Optional.ofNullable(this.buildPodSet()).orElse(new ResourceTemplateBuilder().build()));
    }

    public PodSetNested<A> editOrNewPodSetLike(ResourceTemplate item) {
        return this.withNewPodSetLike(Optional.ofNullable(this.buildPodSet()).orElse(item));
    }

    public PodTemplate buildPod() {
        return this.pod != null ? this.pod.build() : null;
    }

    public A withPod(PodTemplate pod) {
        this._visitables.remove((Object)"pod");
        if (pod != null) {
            this.pod = new PodTemplateBuilder(pod);
            this._visitables.get((Object)"pod").add(this.pod);
        } else {
            this.pod = null;
            this._visitables.get((Object)"pod").remove((Object)this.pod);
        }
        return (A)((Object)this);
    }

    public boolean hasPod() {
        return this.pod != null;
    }

    public PodNested<A> withNewPod() {
        return new PodNested(null);
    }

    public PodNested<A> withNewPodLike(PodTemplate item) {
        return new PodNested(item);
    }

    public PodNested<A> editPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(null));
    }

    public PodNested<A> editOrNewPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(new PodTemplateBuilder().build()));
    }

    public PodNested<A> editOrNewPodLike(PodTemplate item) {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(item));
    }

    public InternalServiceTemplate buildClientService() {
        return this.clientService != null ? this.clientService.build() : null;
    }

    public A withClientService(InternalServiceTemplate clientService) {
        this._visitables.remove((Object)"clientService");
        if (clientService != null) {
            this.clientService = new InternalServiceTemplateBuilder(clientService);
            this._visitables.get((Object)"clientService").add(this.clientService);
        } else {
            this.clientService = null;
            this._visitables.get((Object)"clientService").remove((Object)this.clientService);
        }
        return (A)((Object)this);
    }

    public boolean hasClientService() {
        return this.clientService != null;
    }

    public ClientServiceNested<A> withNewClientService() {
        return new ClientServiceNested(null);
    }

    public ClientServiceNested<A> withNewClientServiceLike(InternalServiceTemplate item) {
        return new ClientServiceNested(item);
    }

    public ClientServiceNested<A> editClientService() {
        return this.withNewClientServiceLike(Optional.ofNullable(this.buildClientService()).orElse(null));
    }

    public ClientServiceNested<A> editOrNewClientService() {
        return this.withNewClientServiceLike(Optional.ofNullable(this.buildClientService()).orElse(new InternalServiceTemplateBuilder().build()));
    }

    public ClientServiceNested<A> editOrNewClientServiceLike(InternalServiceTemplate item) {
        return this.withNewClientServiceLike(Optional.ofNullable(this.buildClientService()).orElse(item));
    }

    public InternalServiceTemplate buildNodesService() {
        return this.nodesService != null ? this.nodesService.build() : null;
    }

    public A withNodesService(InternalServiceTemplate nodesService) {
        this._visitables.remove((Object)"nodesService");
        if (nodesService != null) {
            this.nodesService = new InternalServiceTemplateBuilder(nodesService);
            this._visitables.get((Object)"nodesService").add(this.nodesService);
        } else {
            this.nodesService = null;
            this._visitables.get((Object)"nodesService").remove((Object)this.nodesService);
        }
        return (A)((Object)this);
    }

    public boolean hasNodesService() {
        return this.nodesService != null;
    }

    public NodesServiceNested<A> withNewNodesService() {
        return new NodesServiceNested(null);
    }

    public NodesServiceNested<A> withNewNodesServiceLike(InternalServiceTemplate item) {
        return new NodesServiceNested(item);
    }

    public NodesServiceNested<A> editNodesService() {
        return this.withNewNodesServiceLike(Optional.ofNullable(this.buildNodesService()).orElse(null));
    }

    public NodesServiceNested<A> editOrNewNodesService() {
        return this.withNewNodesServiceLike(Optional.ofNullable(this.buildNodesService()).orElse(new InternalServiceTemplateBuilder().build()));
    }

    public NodesServiceNested<A> editOrNewNodesServiceLike(InternalServiceTemplate item) {
        return this.withNewNodesServiceLike(Optional.ofNullable(this.buildNodesService()).orElse(item));
    }

    public ResourceTemplate buildPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null ? this.persistentVolumeClaim.build() : null;
    }

    public A withPersistentVolumeClaim(ResourceTemplate persistentVolumeClaim) {
        this._visitables.remove((Object)"persistentVolumeClaim");
        if (persistentVolumeClaim != null) {
            this.persistentVolumeClaim = new ResourceTemplateBuilder(persistentVolumeClaim);
            this._visitables.get((Object)"persistentVolumeClaim").add(this.persistentVolumeClaim);
        } else {
            this.persistentVolumeClaim = null;
            this._visitables.get((Object)"persistentVolumeClaim").remove((Object)this.persistentVolumeClaim);
        }
        return (A)((Object)this);
    }

    public boolean hasPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null;
    }

    public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
        return new PersistentVolumeClaimNested(null);
    }

    public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(ResourceTemplate item) {
        return new PersistentVolumeClaimNested(item);
    }

    public PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
        return this.withNewPersistentVolumeClaimLike(Optional.ofNullable(this.buildPersistentVolumeClaim()).orElse(null));
    }

    public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
        return this.withNewPersistentVolumeClaimLike(Optional.ofNullable(this.buildPersistentVolumeClaim()).orElse(new ResourceTemplateBuilder().build()));
    }

    public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(ResourceTemplate item) {
        return this.withNewPersistentVolumeClaimLike(Optional.ofNullable(this.buildPersistentVolumeClaim()).orElse(item));
    }

    public PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
        return this.podDisruptionBudget != null ? this.podDisruptionBudget.build() : null;
    }

    public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
        this._visitables.remove((Object)"podDisruptionBudget");
        if (podDisruptionBudget != null) {
            this.podDisruptionBudget = new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget);
            this._visitables.get((Object)"podDisruptionBudget").add(this.podDisruptionBudget);
        } else {
            this.podDisruptionBudget = null;
            this._visitables.get((Object)"podDisruptionBudget").remove((Object)this.podDisruptionBudget);
        }
        return (A)((Object)this);
    }

    public boolean hasPodDisruptionBudget() {
        return this.podDisruptionBudget != null;
    }

    public PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
        return new PodDisruptionBudgetNested(null);
    }

    public PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return new PodDisruptionBudgetNested(item);
    }

    public PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(null));
    }

    public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(new PodDisruptionBudgetTemplateBuilder().build()));
    }

    public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(item));
    }

    public ContainerTemplate buildZookeeperContainer() {
        return this.zookeeperContainer != null ? this.zookeeperContainer.build() : null;
    }

    public A withZookeeperContainer(ContainerTemplate zookeeperContainer) {
        this._visitables.remove((Object)"zookeeperContainer");
        if (zookeeperContainer != null) {
            this.zookeeperContainer = new ContainerTemplateBuilder(zookeeperContainer);
            this._visitables.get((Object)"zookeeperContainer").add(this.zookeeperContainer);
        } else {
            this.zookeeperContainer = null;
            this._visitables.get((Object)"zookeeperContainer").remove((Object)this.zookeeperContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasZookeeperContainer() {
        return this.zookeeperContainer != null;
    }

    public ZookeeperContainerNested<A> withNewZookeeperContainer() {
        return new ZookeeperContainerNested(null);
    }

    public ZookeeperContainerNested<A> withNewZookeeperContainerLike(ContainerTemplate item) {
        return new ZookeeperContainerNested(item);
    }

    public ZookeeperContainerNested<A> editZookeeperContainer() {
        return this.withNewZookeeperContainerLike(Optional.ofNullable(this.buildZookeeperContainer()).orElse(null));
    }

    public ZookeeperContainerNested<A> editOrNewZookeeperContainer() {
        return this.withNewZookeeperContainerLike(Optional.ofNullable(this.buildZookeeperContainer()).orElse(new ContainerTemplateBuilder().build()));
    }

    public ZookeeperContainerNested<A> editOrNewZookeeperContainerLike(ContainerTemplate item) {
        return this.withNewZookeeperContainerLike(Optional.ofNullable(this.buildZookeeperContainer()).orElse(item));
    }

    public ResourceTemplate buildServiceAccount() {
        return this.serviceAccount != null ? this.serviceAccount.build() : null;
    }

    public A withServiceAccount(ResourceTemplate serviceAccount) {
        this._visitables.remove((Object)"serviceAccount");
        if (serviceAccount != null) {
            this.serviceAccount = new ResourceTemplateBuilder(serviceAccount);
            this._visitables.get((Object)"serviceAccount").add(this.serviceAccount);
        } else {
            this.serviceAccount = null;
            this._visitables.get((Object)"serviceAccount").remove((Object)this.serviceAccount);
        }
        return (A)((Object)this);
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public ServiceAccountNested<A> withNewServiceAccount() {
        return new ServiceAccountNested(null);
    }

    public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
        return new ServiceAccountNested(item);
    }

    public ServiceAccountNested<A> editServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(null));
    }

    public ServiceAccountNested<A> editOrNewServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
    }

    public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(item));
    }

    public ResourceTemplate buildJmxSecret() {
        return this.jmxSecret != null ? this.jmxSecret.build() : null;
    }

    public A withJmxSecret(ResourceTemplate jmxSecret) {
        this._visitables.remove((Object)"jmxSecret");
        if (jmxSecret != null) {
            this.jmxSecret = new ResourceTemplateBuilder(jmxSecret);
            this._visitables.get((Object)"jmxSecret").add(this.jmxSecret);
        } else {
            this.jmxSecret = null;
            this._visitables.get((Object)"jmxSecret").remove((Object)this.jmxSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasJmxSecret() {
        return this.jmxSecret != null;
    }

    public JmxSecretNested<A> withNewJmxSecret() {
        return new JmxSecretNested(null);
    }

    public JmxSecretNested<A> withNewJmxSecretLike(ResourceTemplate item) {
        return new JmxSecretNested(item);
    }

    public JmxSecretNested<A> editJmxSecret() {
        return this.withNewJmxSecretLike(Optional.ofNullable(this.buildJmxSecret()).orElse(null));
    }

    public JmxSecretNested<A> editOrNewJmxSecret() {
        return this.withNewJmxSecretLike(Optional.ofNullable(this.buildJmxSecret()).orElse(new ResourceTemplateBuilder().build()));
    }

    public JmxSecretNested<A> editOrNewJmxSecretLike(ResourceTemplate item) {
        return this.withNewJmxSecretLike(Optional.ofNullable(this.buildJmxSecret()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ZookeeperClusterTemplateFluent that = (ZookeeperClusterTemplateFluent)((Object)o);
        if (!Objects.equals((Object)this.statefulset, (Object)that.statefulset)) {
            return false;
        }
        if (!Objects.equals((Object)this.podSet, (Object)that.podSet)) {
            return false;
        }
        if (!Objects.equals((Object)this.pod, (Object)that.pod)) {
            return false;
        }
        if (!Objects.equals((Object)this.clientService, (Object)that.clientService)) {
            return false;
        }
        if (!Objects.equals((Object)this.nodesService, (Object)that.nodesService)) {
            return false;
        }
        if (!Objects.equals((Object)this.persistentVolumeClaim, (Object)that.persistentVolumeClaim)) {
            return false;
        }
        if (!Objects.equals((Object)this.podDisruptionBudget, (Object)that.podDisruptionBudget)) {
            return false;
        }
        if (!Objects.equals((Object)this.zookeeperContainer, (Object)that.zookeeperContainer)) {
            return false;
        }
        if (!Objects.equals((Object)this.serviceAccount, (Object)that.serviceAccount)) {
            return false;
        }
        return Objects.equals((Object)this.jmxSecret, (Object)that.jmxSecret);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.statefulset, this.podSet, this.pod, this.clientService, this.nodesService, this.persistentVolumeClaim, this.podDisruptionBudget, this.zookeeperContainer, this.serviceAccount, this.jmxSecret, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.statefulset != null) {
            sb.append("statefulset:");
            sb.append(this.statefulset + ",");
        }
        if (this.podSet != null) {
            sb.append("podSet:");
            sb.append(this.podSet + ",");
        }
        if (this.pod != null) {
            sb.append("pod:");
            sb.append(this.pod + ",");
        }
        if (this.clientService != null) {
            sb.append("clientService:");
            sb.append(this.clientService + ",");
        }
        if (this.nodesService != null) {
            sb.append("nodesService:");
            sb.append(this.nodesService + ",");
        }
        if (this.persistentVolumeClaim != null) {
            sb.append("persistentVolumeClaim:");
            sb.append(this.persistentVolumeClaim + ",");
        }
        if (this.podDisruptionBudget != null) {
            sb.append("podDisruptionBudget:");
            sb.append(this.podDisruptionBudget + ",");
        }
        if (this.zookeeperContainer != null) {
            sb.append("zookeeperContainer:");
            sb.append(this.zookeeperContainer + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.jmxSecret != null) {
            sb.append("jmxSecret:");
            sb.append((Object)this.jmxSecret);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StatefulsetNested<N>
    extends StatefulSetTemplateFluent<StatefulsetNested<N>>
    implements Nested<N> {
        StatefulSetTemplateBuilder builder;

        StatefulsetNested(StatefulSetTemplate item) {
            this.builder = new StatefulSetTemplateBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterTemplateFluent.this.withStatefulset(this.builder.build());
        }

        public N endStatefulset() {
            return this.and();
        }
    }

    public class PodSetNested<N>
    extends ResourceTemplateFluent<PodSetNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        PodSetNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterTemplateFluent.this.withPodSet(this.builder.build());
        }

        public N endPodSet() {
            return this.and();
        }
    }

    public class PodNested<N>
    extends PodTemplateFluent<PodNested<N>>
    implements Nested<N> {
        PodTemplateBuilder builder;

        PodNested(PodTemplate item) {
            this.builder = new PodTemplateBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterTemplateFluent.this.withPod(this.builder.build());
        }

        public N endPod() {
            return this.and();
        }
    }

    public class ClientServiceNested<N>
    extends InternalServiceTemplateFluent<ClientServiceNested<N>>
    implements Nested<N> {
        InternalServiceTemplateBuilder builder;

        ClientServiceNested(InternalServiceTemplate item) {
            this.builder = new InternalServiceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterTemplateFluent.this.withClientService(this.builder.build());
        }

        public N endClientService() {
            return this.and();
        }
    }

    public class NodesServiceNested<N>
    extends InternalServiceTemplateFluent<NodesServiceNested<N>>
    implements Nested<N> {
        InternalServiceTemplateBuilder builder;

        NodesServiceNested(InternalServiceTemplate item) {
            this.builder = new InternalServiceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterTemplateFluent.this.withNodesService(this.builder.build());
        }

        public N endNodesService() {
            return this.and();
        }
    }

    public class PersistentVolumeClaimNested<N>
    extends ResourceTemplateFluent<PersistentVolumeClaimNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        PersistentVolumeClaimNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterTemplateFluent.this.withPersistentVolumeClaim(this.builder.build());
        }

        public N endPersistentVolumeClaim() {
            return this.and();
        }
    }

    public class PodDisruptionBudgetNested<N>
    extends PodDisruptionBudgetTemplateFluent<PodDisruptionBudgetNested<N>>
    implements Nested<N> {
        PodDisruptionBudgetTemplateBuilder builder;

        PodDisruptionBudgetNested(PodDisruptionBudgetTemplate item) {
            this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterTemplateFluent.this.withPodDisruptionBudget(this.builder.build());
        }

        public N endPodDisruptionBudget() {
            return this.and();
        }
    }

    public class ZookeeperContainerNested<N>
    extends ContainerTemplateFluent<ZookeeperContainerNested<N>>
    implements Nested<N> {
        ContainerTemplateBuilder builder;

        ZookeeperContainerNested(ContainerTemplate item) {
            this.builder = new ContainerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterTemplateFluent.this.withZookeeperContainer(this.builder.build());
        }

        public N endZookeeperContainer() {
            return this.and();
        }
    }

    public class ServiceAccountNested<N>
    extends ResourceTemplateFluent<ServiceAccountNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        ServiceAccountNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterTemplateFluent.this.withServiceAccount(this.builder.build());
        }

        public N endServiceAccount() {
            return this.and();
        }
    }

    public class JmxSecretNested<N>
    extends ResourceTemplateFluent<JmxSecretNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        JmxSecretNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)ZookeeperClusterTemplateFluent.this.withJmxSecret(this.builder.build());
        }

        public N endJmxSecret() {
            return this.and();
        }
    }
}

