/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.plugin.security.profiles.impl;

import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.PodSecurityContextBuilder;
import io.strimzi.api.kafka.model.kafka.JbodStorage;
import io.strimzi.api.kafka.model.kafka.PersistentClaimStorage;
import io.strimzi.api.kafka.model.kafka.Storage;
import io.strimzi.platform.PlatformFeatures;
import io.strimzi.plugin.security.profiles.PodSecurityProvider;
import io.strimzi.plugin.security.profiles.PodSecurityProviderContext;

public class BaselinePodSecurityProvider
implements PodSecurityProvider {
    protected static final Long DEFAULT_FS_GROUP_ID = 0L;
    protected boolean isOpenShift = false;

    @Override
    public void configure(PlatformFeatures platformFeatures) {
        this.isOpenShift = platformFeatures.isOpenshift();
    }

    private boolean usesPersistentStorage(Storage storage) {
        if (storage instanceof JbodStorage) {
            JbodStorage jbodStorage = (JbodStorage)storage;
            for (Storage storage2 : jbodStorage.getVolumes()) {
                if (!(storage2 instanceof PersistentClaimStorage)) continue;
                return true;
            }
            return false;
        }
        return storage instanceof PersistentClaimStorage;
    }

    private PodSecurityContext createStatefulPodSecurityContext(PodSecurityProviderContext context) {
        if (context == null) {
            return null;
        }
        if (context.userSuppliedSecurityContext() != null) {
            return context.userSuppliedSecurityContext();
        }
        if (this.isOpenShift) {
            return null;
        }
        if (this.usesPersistentStorage(context.storage())) {
            return ((PodSecurityContextBuilder)new PodSecurityContextBuilder().withFsGroup(DEFAULT_FS_GROUP_ID)).build();
        }
        return null;
    }

    @Override
    public PodSecurityContext zooKeeperPodSecurityContext(PodSecurityProviderContext context) {
        return this.createStatefulPodSecurityContext(context);
    }

    @Override
    public PodSecurityContext kafkaPodSecurityContext(PodSecurityProviderContext context) {
        return this.createStatefulPodSecurityContext(context);
    }
}

