/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.bridge;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeHttpCors;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.util.HashMap;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"port", "cors"})
public class KafkaBridgeHttpConfig
implements UnknownPropertyPreserving {
    public static final int HTTP_DEFAULT_PORT = 8080;
    public static final String HTTP_DEFAULT_HOST = "0.0.0.0";
    private int port = 8080;
    private KafkaBridgeHttpCors cors;
    private Map<String, Object> additionalProperties;

    public KafkaBridgeHttpConfig() {
    }

    public KafkaBridgeHttpConfig(int port) {
        this.port = port;
    }

    @Description(value="The port which is the server listening on.")
    @JsonProperty(defaultValue="8080")
    @Minimum(value=1023)
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Description(value="CORS configuration for the HTTP Bridge.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaBridgeHttpCors getCors() {
        return this.cors;
    }

    public void setCors(KafkaBridgeHttpCors cors) {
        this.cors = cors;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaBridgeHttpConfig)) {
            return false;
        }
        KafkaBridgeHttpConfig other = (KafkaBridgeHttpConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        KafkaBridgeHttpCors this$cors = this.getCors();
        KafkaBridgeHttpCors other$cors = other.getCors();
        if (this$cors == null ? other$cors != null : !((Object)this$cors).equals(other$cors)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaBridgeHttpConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        KafkaBridgeHttpCors $cors = this.getCors();
        result = result * 59 + ($cors == null ? 43 : ((Object)$cors).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaBridgeHttpConfig(port=" + this.getPort() + ", cors=" + this.getCors() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }
}

