/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.bridge;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeAdminClientSpec;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeConsumerSpec;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeHttpConfig;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeProducerSpec;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeTemplate;
import io.strimzi.api.kafka.model.common.ClientTls;
import io.strimzi.api.kafka.model.common.HasConfigurableLogging;
import io.strimzi.api.kafka.model.common.HasLivenessProbe;
import io.strimzi.api.kafka.model.common.HasReadinessProbe;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.common.Rack;
import io.strimzi.api.kafka.model.common.Spec;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.common.tracing.Tracing;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.KubeLink;
import io.strimzi.crdgenerator.annotations.Minimum;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"replicas", "image", "bootstrapServers", "tls", "authentication", "http", "adminClient", "consumer", "producer", "resources", "jvmOptions", "logging", "clientRackInitImage", "rack", "enableMetrics", "livenessProbe", "readinessProbe", "template", "tracing"})
public class KafkaBridgeSpec
extends Spec
implements HasConfigurableLogging,
HasLivenessProbe,
HasReadinessProbe {
    private static final int DEFAULT_REPLICAS = 1;
    private int replicas = 1;
    private String image;
    private KafkaBridgeHttpConfig http;
    private String bootstrapServers;
    private ClientTls tls;
    private KafkaClientAuthentication authentication;
    private KafkaBridgeConsumerSpec consumer;
    private KafkaBridgeProducerSpec producer;
    private KafkaBridgeAdminClientSpec adminClient;
    private ResourceRequirements resources;
    private JvmOptions jvmOptions;
    private Logging logging;
    private boolean enableMetrics;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private KafkaBridgeTemplate template;
    private Tracing tracing;
    private String clientRackInitImage;
    private Rack rack;

    @Description(value="The number of pods in the `Deployment`.  Defaults to `1`.")
    @Minimum(value=0)
    @JsonProperty(defaultValue="1")
    public int getReplicas() {
        return this.replicas;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="Enable the metrics for the Kafka Bridge. Default is false.")
    public boolean getEnableMetrics() {
        return this.enableMetrics;
    }

    public void setEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
    }

    @Override
    @Description(value="Logging configuration for Kafka Bridge.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Logging getLogging() {
        return this.logging;
    }

    @Override
    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="**Currently not supported** JVM Options for pods")
    public JvmOptions getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(JvmOptions jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @KubeLink(group="core", version="v1", kind="resourcerequirements")
    @Description(value="CPU and memory resources to reserve.")
    public ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    @Description(value="Authentication configuration for connecting to the cluster.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public KafkaClientAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(KafkaClientAuthentication authentication) {
        this.authentication = authentication;
    }

    @Description(value="TLS configuration for connecting Kafka Bridge to the cluster.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ClientTls getTls() {
        return this.tls;
    }

    public void setTls(ClientTls tls) {
        this.tls = tls;
    }

    @Description(value="A list of host:port pairs for establishing the initial connection to the Kafka cluster.")
    @JsonProperty(required=true)
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    @Description(value="Kafka AdminClient related configuration.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaBridgeAdminClientSpec getAdminClient() {
        return this.adminClient;
    }

    public void setAdminClient(KafkaBridgeAdminClientSpec adminClient) {
        this.adminClient = adminClient;
    }

    @Description(value="Kafka producer related configuration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaBridgeProducerSpec getProducer() {
        return this.producer;
    }

    public void setProducer(KafkaBridgeProducerSpec producer) {
        this.producer = producer;
    }

    @Description(value="Kafka consumer related configuration.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaBridgeConsumerSpec getConsumer() {
        return this.consumer;
    }

    public void setConsumer(KafkaBridgeConsumerSpec consumer) {
        this.consumer = consumer;
    }

    @Description(value="The HTTP related configuration.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaBridgeHttpConfig getHttp() {
        return this.http;
    }

    public void setHttp(KafkaBridgeHttpConfig http) {
        this.http = http;
    }

    @Description(value="The container image used for Kafka Bridge pods. If no image name is explicitly specified, the image name corresponds to the image specified in the Cluster Operator configuration. If an image name is not defined in the Cluster Operator configuration, a default value is used.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Description(value="Template for Kafka Bridge resources. The template allows users to specify how a `Deployment` and `Pod` is generated.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public KafkaBridgeTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(KafkaBridgeTemplate template) {
        this.template = template;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod liveness checking.")
    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    @Override
    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @Description(value="Pod readiness checking.")
    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    @Override
    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="The configuration of tracing in Kafka Bridge.")
    public Tracing getTracing() {
        return this.tracing;
    }

    public void setTracing(Tracing tracing) {
        this.tracing = tracing;
    }

    @Description(value="The image of the init container used for initializing the `client.rack`.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientRackInitImage() {
        return this.clientRackInitImage;
    }

    public void setClientRackInitImage(String brokerRackInitImage) {
        this.clientRackInitImage = brokerRackInitImage;
    }

    @Description(value="Configuration of the node label which will be used as the client.rack consumer configuration.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Rack getRack() {
        return this.rack;
    }

    public void setRack(Rack rack) {
        this.rack = rack;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaBridgeSpec)) {
            return false;
        }
        KafkaBridgeSpec other = (KafkaBridgeSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getReplicas() != other.getReplicas()) {
            return false;
        }
        if (this.getEnableMetrics() != other.getEnableMetrics()) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        KafkaBridgeHttpConfig this$http = this.getHttp();
        KafkaBridgeHttpConfig other$http = other.getHttp();
        if (this$http == null ? other$http != null : !((Object)this$http).equals(other$http)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        ClientTls this$tls = this.getTls();
        ClientTls other$tls = other.getTls();
        if (this$tls == null ? other$tls != null : !((Object)this$tls).equals(other$tls)) {
            return false;
        }
        KafkaClientAuthentication this$authentication = this.getAuthentication();
        KafkaClientAuthentication other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication)) {
            return false;
        }
        KafkaBridgeConsumerSpec this$consumer = this.getConsumer();
        KafkaBridgeConsumerSpec other$consumer = other.getConsumer();
        if (this$consumer == null ? other$consumer != null : !((Object)this$consumer).equals(other$consumer)) {
            return false;
        }
        KafkaBridgeProducerSpec this$producer = this.getProducer();
        KafkaBridgeProducerSpec other$producer = other.getProducer();
        if (this$producer == null ? other$producer != null : !((Object)this$producer).equals(other$producer)) {
            return false;
        }
        KafkaBridgeAdminClientSpec this$adminClient = this.getAdminClient();
        KafkaBridgeAdminClientSpec other$adminClient = other.getAdminClient();
        if (this$adminClient == null ? other$adminClient != null : !((Object)this$adminClient).equals(other$adminClient)) {
            return false;
        }
        ResourceRequirements this$resources = this.getResources();
        ResourceRequirements other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) {
            return false;
        }
        JvmOptions this$jvmOptions = this.getJvmOptions();
        JvmOptions other$jvmOptions = other.getJvmOptions();
        if (this$jvmOptions == null ? other$jvmOptions != null : !((Object)this$jvmOptions).equals(other$jvmOptions)) {
            return false;
        }
        Logging this$logging = this.getLogging();
        Logging other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !((Object)this$logging).equals(other$logging)) {
            return false;
        }
        Probe this$livenessProbe = this.getLivenessProbe();
        Probe other$livenessProbe = other.getLivenessProbe();
        if (this$livenessProbe == null ? other$livenessProbe != null : !((Object)this$livenessProbe).equals(other$livenessProbe)) {
            return false;
        }
        Probe this$readinessProbe = this.getReadinessProbe();
        Probe other$readinessProbe = other.getReadinessProbe();
        if (this$readinessProbe == null ? other$readinessProbe != null : !((Object)this$readinessProbe).equals(other$readinessProbe)) {
            return false;
        }
        KafkaBridgeTemplate this$template = this.getTemplate();
        KafkaBridgeTemplate other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        Tracing this$tracing = this.getTracing();
        Tracing other$tracing = other.getTracing();
        if (this$tracing == null ? other$tracing != null : !((Object)this$tracing).equals(other$tracing)) {
            return false;
        }
        String this$clientRackInitImage = this.getClientRackInitImage();
        String other$clientRackInitImage = other.getClientRackInitImage();
        if (this$clientRackInitImage == null ? other$clientRackInitImage != null : !this$clientRackInitImage.equals(other$clientRackInitImage)) {
            return false;
        }
        Rack this$rack = this.getRack();
        Rack other$rack = other.getRack();
        return !(this$rack == null ? other$rack != null : !((Object)this$rack).equals(other$rack));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaBridgeSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getReplicas();
        result = result * 59 + (this.getEnableMetrics() ? 79 : 97);
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        KafkaBridgeHttpConfig $http = this.getHttp();
        result = result * 59 + ($http == null ? 43 : ((Object)$http).hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        ClientTls $tls = this.getTls();
        result = result * 59 + ($tls == null ? 43 : ((Object)$tls).hashCode());
        KafkaClientAuthentication $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
        KafkaBridgeConsumerSpec $consumer = this.getConsumer();
        result = result * 59 + ($consumer == null ? 43 : ((Object)$consumer).hashCode());
        KafkaBridgeProducerSpec $producer = this.getProducer();
        result = result * 59 + ($producer == null ? 43 : ((Object)$producer).hashCode());
        KafkaBridgeAdminClientSpec $adminClient = this.getAdminClient();
        result = result * 59 + ($adminClient == null ? 43 : ((Object)$adminClient).hashCode());
        ResourceRequirements $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
        JvmOptions $jvmOptions = this.getJvmOptions();
        result = result * 59 + ($jvmOptions == null ? 43 : ((Object)$jvmOptions).hashCode());
        Logging $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : ((Object)$logging).hashCode());
        Probe $livenessProbe = this.getLivenessProbe();
        result = result * 59 + ($livenessProbe == null ? 43 : ((Object)$livenessProbe).hashCode());
        Probe $readinessProbe = this.getReadinessProbe();
        result = result * 59 + ($readinessProbe == null ? 43 : ((Object)$readinessProbe).hashCode());
        KafkaBridgeTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        Tracing $tracing = this.getTracing();
        result = result * 59 + ($tracing == null ? 43 : ((Object)$tracing).hashCode());
        String $clientRackInitImage = this.getClientRackInitImage();
        result = result * 59 + ($clientRackInitImage == null ? 43 : $clientRackInitImage.hashCode());
        Rack $rack = this.getRack();
        result = result * 59 + ($rack == null ? 43 : ((Object)$rack).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaBridgeSpec(super=" + super.toString() + ", replicas=" + this.getReplicas() + ", image=" + this.getImage() + ", http=" + this.getHttp() + ", bootstrapServers=" + this.getBootstrapServers() + ", tls=" + this.getTls() + ", authentication=" + this.getAuthentication() + ", consumer=" + this.getConsumer() + ", producer=" + this.getProducer() + ", adminClient=" + this.getAdminClient() + ", resources=" + this.getResources() + ", jvmOptions=" + this.getJvmOptions() + ", logging=" + this.getLogging() + ", enableMetrics=" + this.getEnableMetrics() + ", livenessProbe=" + this.getLivenessProbe() + ", readinessProbe=" + this.getReadinessProbe() + ", template=" + this.getTemplate() + ", tracing=" + this.getTracing() + ", clientRackInitImage=" + this.getClientRackInitImage() + ", rack=" + this.getRack() + ")";
    }
}

