/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.client.CustomResource;
import io.strimzi.api.kafka.model.kafka.Status;
import java.util.function.Predicate;

public class CustomResourceConditions {
    private CustomResourceConditions() {
    }

    public static <Y extends Status, T extends CustomResource<?, Y>> Predicate<T> isReady() {
        return CustomResourceConditions.isLatestGenerationAndAnyConditionMatches("Ready", "True");
    }

    public static <Y extends Status, T extends CustomResource<?, Y>> Predicate<T> isLatestGenerationAndAnyConditionMatches(String type, String status) {
        return CustomResourceConditions.isStatusLatestGenerationAndMatches(CustomResourceConditions.anyCondition(type, status));
    }

    private static <Y extends Status> Predicate<Y> anyCondition(String expectedType, String expectedStatus) {
        return status -> {
            if (status.getConditions() == null) {
                return false;
            }
            return status.getConditions().stream().anyMatch(condition -> expectedType.equals(condition.getType()) && expectedStatus.equals(condition.getStatus()));
        };
    }

    private static <Y extends Status, T extends CustomResource<?, Y>> Predicate<T> isStatusLatestGenerationAndMatches(Predicate<Y> predicate) {
        return resource -> {
            if (resource.getStatus() == null) {
                return false;
            }
            boolean expectedGeneration = resource.getMetadata().getGeneration().longValue() == ((Status)resource.getStatus()).getObservedGeneration();
            return expectedGeneration && predicate.test((Status)resource.getStatus());
        };
    }
}

