/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common.authentication;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.PasswordSecretSource;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthentication;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "username", "passwordSecret"})
public class KafkaClientAuthenticationPlain
extends KafkaClientAuthentication {
    public static final String TYPE_PLAIN = "plain";
    private String username;
    private PasswordSecretSource passwordSecret;

    @Override
    @Description(value="Must be `plain`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return TYPE_PLAIN;
    }

    @Description(value="Reference to the `Secret` which holds the password.")
    public PasswordSecretSource getPasswordSecret() {
        return this.passwordSecret;
    }

    public void setPasswordSecret(PasswordSecretSource passwordSecret) {
        this.passwordSecret = passwordSecret;
    }

    @Description(value="Username used for the authentication.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaClientAuthenticationPlain)) {
            return false;
        }
        KafkaClientAuthenticationPlain other = (KafkaClientAuthenticationPlain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        PasswordSecretSource this$passwordSecret = this.getPasswordSecret();
        PasswordSecretSource other$passwordSecret = other.getPasswordSecret();
        return !(this$passwordSecret == null ? other$passwordSecret != null : !((Object)this$passwordSecret).equals(other$passwordSecret));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaClientAuthenticationPlain;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        PasswordSecretSource $passwordSecret = this.getPasswordSecret();
        result = result * 59 + ($passwordSecret == null ? 43 : ((Object)$passwordSecret).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaClientAuthenticationPlain(super=" + super.toString() + ", username=" + this.getUsername() + ", passwordSecret=" + this.getPasswordSecret() + ")";
    }
}

