/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common.template;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.common.template.ContainerEnvVar;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.KubeLink;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"env", "securityContext", "volumeMounts"})
@DescriptionFile
public class ContainerTemplate
implements UnknownPropertyPreserving {
    private List<ContainerEnvVar> env;
    private SecurityContext securityContext;
    private Map<String, Object> additionalProperties;
    private List<VolumeMount> volumeMounts;

    @Description(value="Additional volume mounts which should be applied to the container")
    @KubeLink(group="core", version="v1", kind="volumemount")
    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    @Description(value="Environment variables which should be applied to the container.")
    public List<ContainerEnvVar> getEnv() {
        return this.env;
    }

    public void setEnv(List<ContainerEnvVar> env) {
        this.env = env;
    }

    @Description(value="Security context for the container")
    @KubeLink(group="core", version="v1", kind="securitycontext")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerTemplate)) {
            return false;
        }
        ContainerTemplate other = (ContainerTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ContainerEnvVar> this$env = this.getEnv();
        List<ContainerEnvVar> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        SecurityContext this$securityContext = this.getSecurityContext();
        SecurityContext other$securityContext = other.getSecurityContext();
        if (this$securityContext == null ? other$securityContext != null : !this$securityContext.equals(other$securityContext)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        if (this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties)) {
            return false;
        }
        List<VolumeMount> this$volumeMounts = this.getVolumeMounts();
        List<VolumeMount> other$volumeMounts = other.getVolumeMounts();
        return !(this$volumeMounts == null ? other$volumeMounts != null : !((Object)this$volumeMounts).equals(other$volumeMounts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ContainerEnvVar> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        SecurityContext $securityContext = this.getSecurityContext();
        result = result * 59 + ($securityContext == null ? 43 : $securityContext.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        List<VolumeMount> $volumeMounts = this.getVolumeMounts();
        result = result * 59 + ($volumeMounts == null ? 43 : ((Object)$volumeMounts).hashCode());
        return result;
    }

    public String toString() {
        return "ContainerTemplate(env=" + this.getEnv() + ", securityContext=" + this.getSecurityContext() + ", additionalProperties=" + this.getAdditionalProperties() + ", volumeMounts=" + this.getVolumeMounts() + ")";
    }
}

