/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.strimzi.api.kafka.model.common.template.ContainerEnvVar;
import io.strimzi.api.kafka.model.common.template.ContainerEnvVarBuilder;
import io.strimzi.api.kafka.model.common.template.ContainerEnvVarFluent;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ContainerTemplateFluent<A extends ContainerTemplateFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ContainerEnvVarBuilder> env;
    private SecurityContext securityContext;
    private List<VolumeMount> volumeMounts;

    public ContainerTemplateFluent() {
    }

    public ContainerTemplateFluent(ContainerTemplate instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ContainerTemplate instance) {
        ContainerTemplate containerTemplate = instance = instance != null ? instance : new ContainerTemplate();
        if (instance != null) {
            this.withEnv(instance.getEnv());
            this.withSecurityContext(instance.getSecurityContext());
            this.withVolumeMounts(instance.getVolumeMounts());
        }
    }

    public A addToEnv(int index, ContainerEnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(index, builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnv(int index, ContainerEnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").set(index, builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(ContainerEnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (ContainerEnvVar item : items) {
            ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnv(Collection<ContainerEnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (ContainerEnvVar item : items) {
            ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(ContainerEnvVar ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (ContainerEnvVar item : items) {
            ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnv(Collection<ContainerEnvVar> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (ContainerEnvVar item : items) {
            ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnv(Predicate<ContainerEnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerEnvVarBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            ContainerEnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ContainerEnvVar> buildEnv() {
        return this.env != null ? ContainerTemplateFluent.build(this.env) : null;
    }

    public ContainerEnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public ContainerEnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public ContainerEnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public ContainerEnvVar buildMatchingEnv(Predicate<ContainerEnvVarBuilder> predicate) {
        for (ContainerEnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<ContainerEnvVarBuilder> predicate) {
        for (ContainerEnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<ContainerEnvVar> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (ContainerEnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(ContainerEnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (ContainerEnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(ContainerEnvVar item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, ContainerEnvVar item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<ContainerEnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public A withSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
        return (A)((Object)this);
    }

    public boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public A addToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        this.volumeMounts.add(index, item);
        return (A)((Object)this);
    }

    public A setToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        this.volumeMounts.set(index, item);
        return (A)((Object)this);
    }

    public A addToVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        for (VolumeMount item : items) {
            this.volumeMounts.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
        }
        for (VolumeMount item : items) {
            this.volumeMounts.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        for (VolumeMount item : items) {
            this.volumeMounts.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        for (VolumeMount item : items) {
            this.volumeMounts.remove(item);
        }
        return (A)((Object)this);
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public VolumeMount getVolumeMount(int index) {
        return this.volumeMounts.get(index);
    }

    public VolumeMount getFirstVolumeMount() {
        return this.volumeMounts.get(0);
    }

    public VolumeMount getLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1);
    }

    public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList<VolumeMount>();
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)((Object)this);
    }

    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
            this._visitables.remove((Object)"volumeMounts");
        }
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerTemplateFluent that = (ContainerTemplateFluent)((Object)o);
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.securityContext, that.securityContext)) {
            return false;
        }
        return Objects.equals(this.volumeMounts, that.volumeMounts);
    }

    public int hashCode() {
        return Objects.hash(this.env, this.securityContext, this.volumeMounts, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(this.securityContext + ",");
        }
        if (this.volumeMounts != null && !this.volumeMounts.isEmpty()) {
            sb.append("volumeMounts:");
            sb.append(this.volumeMounts);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EnvNested<N>
    extends ContainerEnvVarFluent<EnvNested<N>>
    implements Nested<N> {
        ContainerEnvVarBuilder builder;
        int index;

        EnvNested(int index, ContainerEnvVar item) {
            this.index = index;
            this.builder = new ContainerEnvVarBuilder(this, item);
        }

        public N and() {
            return (N)ContainerTemplateFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endEnv() {
            return this.and();
        }
    }
}

