/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.common.HasConfigurableLogging;
import io.strimzi.api.kafka.model.common.HasConfigurableMetrics;
import io.strimzi.api.kafka.model.common.HasLivenessProbe;
import io.strimzi.api.kafka.model.common.HasReadinessProbe;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.common.Rack;
import io.strimzi.api.kafka.model.common.Spec;
import io.strimzi.api.kafka.model.common.jmx.HasJmxOptions;
import io.strimzi.api.kafka.model.common.jmx.KafkaJmxOptions;
import io.strimzi.api.kafka.model.common.metrics.MetricsConfig;
import io.strimzi.api.kafka.model.common.tracing.Tracing;
import io.strimzi.api.kafka.model.connect.ExternalConfiguration;
import io.strimzi.api.kafka.model.connect.KafkaConnectTemplate;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"replicas", "version", "image", "resources", "livenessProbe", "readinessProbe", "jvmOptions", "jmxOptions", "logging", "clientRackInitImage", "rack", "metricsConfig", "tracing", "template", "externalConfiguration"})
public abstract class AbstractKafkaConnectSpec
extends Spec
implements HasConfigurableMetrics,
HasConfigurableLogging,
HasJmxOptions,
HasLivenessProbe,
HasReadinessProbe {
    private Logging logging;
    private int replicas = 3;
    private String version;
    private String image;
    private ResourceRequirements resources;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private KafkaJmxOptions jmxOptions;
    private JvmOptions jvmOptions;
    private MetricsConfig metricsConfig;
    private Tracing tracing;
    private KafkaConnectTemplate template;
    private ExternalConfiguration externalConfiguration;
    private String clientRackInitImage;
    private Rack rack;

    @Description(value="The number of pods in the Kafka Connect group. Defaults to `3`.")
    @JsonProperty(defaultValue="3")
    public int getReplicas() {
        return this.replicas;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    @Override
    @Description(value="Logging configuration for Kafka Connect")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Logging getLogging() {
        return this.logging;
    }

    @Override
    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    @Description(value="The Kafka Connect version. Defaults to the latest version. Consult the user documentation to understand the process required to upgrade or downgrade the version.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Description(value="The container image used for Kafka Connect pods. If no image name is explicitly specified, it is determined based on the `spec.version` configuration. The image names are specifically mapped to corresponding versions in the Cluster Operator configuration.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @KubeLink(group="core", version="v1", kind="resourcerequirements")
    @Description(value="The maximum limits for CPU and memory resources and the requested initial resources.")
    public ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod liveness checking.")
    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    @Override
    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod readiness checking.")
    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    @Override
    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="JVM Options for pods")
    public JvmOptions getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(JvmOptions jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="JMX Options")
    @JsonProperty(value="jmxOptions")
    public KafkaJmxOptions getJmxOptions() {
        return this.jmxOptions;
    }

    @Override
    public void setJmxOptions(KafkaJmxOptions jmxOptions) {
        this.jmxOptions = jmxOptions;
    }

    @Override
    @Description(value="Metrics configuration.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public MetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    @Override
    public void setMetricsConfig(MetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="The configuration of tracing in Kafka Connect.")
    public Tracing getTracing() {
        return this.tracing;
    }

    public void setTracing(Tracing tracing) {
        this.tracing = tracing;
    }

    @Override
    @Description(value="Template for Kafka Connect and Kafka MirrorMaker 2 resources. The template allows users to specify how the `Pods`, `Service`, and other services are generated.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public KafkaConnectTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(KafkaConnectTemplate template) {
        this.template = template;
    }

    @Description(value="Pass data from Secrets or ConfigMaps to the Kafka Connect pods and use them to configure connectors.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Deprecated
    @DeprecatedProperty(description="The external configuration is deprecated and will be removed in the future. Please use the template section instead to configure additional environment variables or volumes.")
    public ExternalConfiguration getExternalConfiguration() {
        return this.externalConfiguration;
    }

    public void setExternalConfiguration(ExternalConfiguration externalConfiguration) {
        this.externalConfiguration = externalConfiguration;
    }

    @Description(value="The image of the init container used for initializing the `client.rack`.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientRackInitImage() {
        return this.clientRackInitImage;
    }

    public void setClientRackInitImage(String brokerRackInitImage) {
        this.clientRackInitImage = brokerRackInitImage;
    }

    @Description(value="Configuration of the node label which will be used as the `client.rack` consumer configuration.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Rack getRack() {
        return this.rack;
    }

    public void setRack(Rack rack) {
        this.rack = rack;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractKafkaConnectSpec)) {
            return false;
        }
        AbstractKafkaConnectSpec other = (AbstractKafkaConnectSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.replicas != other.replicas) {
            return false;
        }
        Logging this$logging = this.logging;
        Logging other$logging = other.logging;
        if (this$logging == null ? other$logging != null : !((Object)this$logging).equals(other$logging)) {
            return false;
        }
        String this$version = this.version;
        String other$version = other.version;
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$image = this.image;
        String other$image = other.image;
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        ResourceRequirements this$resources = this.resources;
        ResourceRequirements other$resources = other.resources;
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) {
            return false;
        }
        Probe this$livenessProbe = this.livenessProbe;
        Probe other$livenessProbe = other.livenessProbe;
        if (this$livenessProbe == null ? other$livenessProbe != null : !((Object)this$livenessProbe).equals(other$livenessProbe)) {
            return false;
        }
        Probe this$readinessProbe = this.readinessProbe;
        Probe other$readinessProbe = other.readinessProbe;
        if (this$readinessProbe == null ? other$readinessProbe != null : !((Object)this$readinessProbe).equals(other$readinessProbe)) {
            return false;
        }
        KafkaJmxOptions this$jmxOptions = this.jmxOptions;
        KafkaJmxOptions other$jmxOptions = other.jmxOptions;
        if (this$jmxOptions == null ? other$jmxOptions != null : !((Object)this$jmxOptions).equals(other$jmxOptions)) {
            return false;
        }
        JvmOptions this$jvmOptions = this.jvmOptions;
        JvmOptions other$jvmOptions = other.jvmOptions;
        if (this$jvmOptions == null ? other$jvmOptions != null : !((Object)this$jvmOptions).equals(other$jvmOptions)) {
            return false;
        }
        MetricsConfig this$metricsConfig = this.metricsConfig;
        MetricsConfig other$metricsConfig = other.metricsConfig;
        if (this$metricsConfig == null ? other$metricsConfig != null : !((Object)this$metricsConfig).equals(other$metricsConfig)) {
            return false;
        }
        Tracing this$tracing = this.tracing;
        Tracing other$tracing = other.tracing;
        if (this$tracing == null ? other$tracing != null : !((Object)this$tracing).equals(other$tracing)) {
            return false;
        }
        KafkaConnectTemplate this$template = this.template;
        KafkaConnectTemplate other$template = other.template;
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        ExternalConfiguration this$externalConfiguration = this.externalConfiguration;
        ExternalConfiguration other$externalConfiguration = other.externalConfiguration;
        if (this$externalConfiguration == null ? other$externalConfiguration != null : !((Object)this$externalConfiguration).equals(other$externalConfiguration)) {
            return false;
        }
        String this$clientRackInitImage = this.clientRackInitImage;
        String other$clientRackInitImage = other.clientRackInitImage;
        if (this$clientRackInitImage == null ? other$clientRackInitImage != null : !this$clientRackInitImage.equals(other$clientRackInitImage)) {
            return false;
        }
        Rack this$rack = this.rack;
        Rack other$rack = other.rack;
        return !(this$rack == null ? other$rack != null : !((Object)this$rack).equals(other$rack));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractKafkaConnectSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.replicas;
        Logging $logging = this.logging;
        result = result * 59 + ($logging == null ? 43 : ((Object)$logging).hashCode());
        String $version = this.version;
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $image = this.image;
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        ResourceRequirements $resources = this.resources;
        result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
        Probe $livenessProbe = this.livenessProbe;
        result = result * 59 + ($livenessProbe == null ? 43 : ((Object)$livenessProbe).hashCode());
        Probe $readinessProbe = this.readinessProbe;
        result = result * 59 + ($readinessProbe == null ? 43 : ((Object)$readinessProbe).hashCode());
        KafkaJmxOptions $jmxOptions = this.jmxOptions;
        result = result * 59 + ($jmxOptions == null ? 43 : ((Object)$jmxOptions).hashCode());
        JvmOptions $jvmOptions = this.jvmOptions;
        result = result * 59 + ($jvmOptions == null ? 43 : ((Object)$jvmOptions).hashCode());
        MetricsConfig $metricsConfig = this.metricsConfig;
        result = result * 59 + ($metricsConfig == null ? 43 : ((Object)$metricsConfig).hashCode());
        Tracing $tracing = this.tracing;
        result = result * 59 + ($tracing == null ? 43 : ((Object)$tracing).hashCode());
        KafkaConnectTemplate $template = this.template;
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        ExternalConfiguration $externalConfiguration = this.externalConfiguration;
        result = result * 59 + ($externalConfiguration == null ? 43 : ((Object)$externalConfiguration).hashCode());
        String $clientRackInitImage = this.clientRackInitImage;
        result = result * 59 + ($clientRackInitImage == null ? 43 : $clientRackInitImage.hashCode());
        Rack $rack = this.rack;
        result = result * 59 + ($rack == null ? 43 : ((Object)$rack).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AbstractKafkaConnectSpec(super=" + super.toString() + ", logging=" + this.getLogging() + ", replicas=" + this.getReplicas() + ", version=" + this.getVersion() + ", image=" + this.getImage() + ", resources=" + this.getResources() + ", livenessProbe=" + this.getLivenessProbe() + ", readinessProbe=" + this.getReadinessProbe() + ", jmxOptions=" + this.getJmxOptions() + ", jvmOptions=" + this.getJvmOptions() + ", metricsConfig=" + this.getMetricsConfig() + ", tracing=" + this.getTracing() + ", template=" + this.getTemplate() + ", externalConfiguration=" + this.getExternalConfiguration() + ", clientRackInitImage=" + this.getClientRackInitImage() + ", rack=" + this.getRack() + ")";
    }
}

