/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.connect.build.Output;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"image", "pushSecret", "additionalKanikoOptions", "type"})
public class DockerOutput
extends Output {
    public static final String ALLOWED_KANIKO_OPTIONS = "--customPlatform, --custom-platform, --insecure, --insecure-pull, --insecure-registry, --log-format, --log-timestamp, --registry-mirror, --reproducible, --single-snapshot, --skip-tls-verify, --skip-tls-verify-pull, --skip-tls-verify-registry, --verbosity, --snapshotMode, --use-new-run, --registry-certificate, --registry-client-cert";
    private String pushSecret;
    private List<String> additionalKanikoOptions;

    @Override
    @Description(value="Must be `docker`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return "docker";
    }

    @Override
    @Description(value="The full name which should be used for tagging and pushing the newly built image. For example `quay.io/my-organization/my-custom-connect:latest`. Required")
    @JsonProperty(required=true)
    public String getImage() {
        return super.getImage();
    }

    @Override
    public void setImage(String image) {
        super.setImage(image);
    }

    @Description(value="Container Registry Secret with the credentials for pushing the newly built image.")
    public String getPushSecret() {
        return this.pushSecret;
    }

    public void setPushSecret(String pushSecret) {
        this.pushSecret = pushSecret;
    }

    @Description(value="Configures additional options which will be passed to the Kaniko executor when building the new Connect image. Allowed options are: --customPlatform, --custom-platform, --insecure, --insecure-pull, --insecure-registry, --log-format, --log-timestamp, --registry-mirror, --reproducible, --single-snapshot, --skip-tls-verify, --skip-tls-verify-pull, --skip-tls-verify-registry, --verbosity, --snapshotMode, --use-new-run, --registry-certificate, --registry-client-cert. These options will be used only on Kubernetes where the Kaniko executor is used. They will be ignored on OpenShift. The options are described in the link:https://github.com/GoogleContainerTools/kaniko[Kaniko GitHub repository^]. Changing this field does not trigger new build of the Kafka Connect image.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getAdditionalKanikoOptions() {
        return this.additionalKanikoOptions;
    }

    public void setAdditionalKanikoOptions(List<String> additionalKanikoOptions) {
        this.additionalKanikoOptions = additionalKanikoOptions;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerOutput)) {
            return false;
        }
        DockerOutput other = (DockerOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pushSecret = this.getPushSecret();
        String other$pushSecret = other.getPushSecret();
        if (this$pushSecret == null ? other$pushSecret != null : !this$pushSecret.equals(other$pushSecret)) {
            return false;
        }
        List<String> this$additionalKanikoOptions = this.getAdditionalKanikoOptions();
        List<String> other$additionalKanikoOptions = other.getAdditionalKanikoOptions();
        return !(this$additionalKanikoOptions == null ? other$additionalKanikoOptions != null : !((Object)this$additionalKanikoOptions).equals(other$additionalKanikoOptions));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DockerOutput;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pushSecret = this.getPushSecret();
        result = result * 59 + ($pushSecret == null ? 43 : $pushSecret.hashCode());
        List<String> $additionalKanikoOptions = this.getAdditionalKanikoOptions();
        result = result * 59 + ($additionalKanikoOptions == null ? 43 : ((Object)$additionalKanikoOptions).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DockerOutput(super=" + super.toString() + ", pushSecret=" + this.getPushSecret() + ", additionalKanikoOptions=" + this.getAdditionalKanikoOptions() + ")";
    }
}

