/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.kafka.KafkaAuthorizationCustom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaAuthorizationCustomFluent<A extends KafkaAuthorizationCustomFluent<A>>
extends BaseFluent<A> {
    private String authorizerClass;
    private List<String> superUsers;
    private boolean supportsAdminApi;

    public KafkaAuthorizationCustomFluent() {
    }

    public KafkaAuthorizationCustomFluent(KafkaAuthorizationCustom instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaAuthorizationCustom instance) {
        KafkaAuthorizationCustom kafkaAuthorizationCustom = instance = instance != null ? instance : new KafkaAuthorizationCustom();
        if (instance != null) {
            this.withAuthorizerClass(instance.getAuthorizerClass());
            this.withSuperUsers(instance.getSuperUsers());
            this.withSupportsAdminApi(instance.isSupportsAdminApi());
        }
    }

    public String getAuthorizerClass() {
        return this.authorizerClass;
    }

    public A withAuthorizerClass(String authorizerClass) {
        this.authorizerClass = authorizerClass;
        return (A)((Object)this);
    }

    public boolean hasAuthorizerClass() {
        return this.authorizerClass != null;
    }

    public A addToSuperUsers(int index, String item) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        this.superUsers.add(index, item);
        return (A)((Object)this);
    }

    public A setToSuperUsers(int index, String item) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        this.superUsers.set(index, item);
        return (A)((Object)this);
    }

    public A addToSuperUsers(String ... items) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSuperUsers(Collection<String> items) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSuperUsers(String ... items) {
        if (this.superUsers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.superUsers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSuperUsers(Collection<String> items) {
        if (this.superUsers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.superUsers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSuperUsers() {
        return this.superUsers;
    }

    public String getSuperUser(int index) {
        return this.superUsers.get(index);
    }

    public String getFirstSuperUser() {
        return this.superUsers.get(0);
    }

    public String getLastSuperUser() {
        return this.superUsers.get(this.superUsers.size() - 1);
    }

    public String getMatchingSuperUser(Predicate<String> predicate) {
        for (String item : this.superUsers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSuperUser(Predicate<String> predicate) {
        for (String item : this.superUsers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSuperUsers(List<String> superUsers) {
        if (superUsers != null) {
            this.superUsers = new ArrayList<String>();
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        } else {
            this.superUsers = null;
        }
        return (A)((Object)this);
    }

    public A withSuperUsers(String ... superUsers) {
        if (this.superUsers != null) {
            this.superUsers.clear();
            this._visitables.remove((Object)"superUsers");
        }
        if (superUsers != null) {
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSuperUsers() {
        return this.superUsers != null && !this.superUsers.isEmpty();
    }

    public boolean isSupportsAdminApi() {
        return this.supportsAdminApi;
    }

    public A withSupportsAdminApi(boolean supportsAdminApi) {
        this.supportsAdminApi = supportsAdminApi;
        return (A)((Object)this);
    }

    public boolean hasSupportsAdminApi() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaAuthorizationCustomFluent that = (KafkaAuthorizationCustomFluent)((Object)o);
        if (!Objects.equals(this.authorizerClass, that.authorizerClass)) {
            return false;
        }
        if (!Objects.equals(this.superUsers, that.superUsers)) {
            return false;
        }
        return this.supportsAdminApi == that.supportsAdminApi;
    }

    public int hashCode() {
        return Objects.hash(this.authorizerClass, this.superUsers, this.supportsAdminApi, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorizerClass != null) {
            sb.append("authorizerClass:");
            sb.append(this.authorizerClass + ",");
        }
        if (this.superUsers != null && !this.superUsers.isEmpty()) {
            sb.append("superUsers:");
            sb.append(this.superUsers + ",");
        }
        sb.append("supportsAdminApi:");
        sb.append(this.supportsAdminApi);
        sb.append("}");
        return sb.toString();
    }

    public A withSupportsAdminApi() {
        return this.withSupportsAdminApi(true);
    }
}

