/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceMode;

public class KafkaResources {
    private KafkaResources() {
    }

    public static String clusterCaCertificateSecretName(String clusterName) {
        return clusterName + "-cluster-ca-cert";
    }

    public static String clusterCaKeySecretName(String clusterName) {
        return clusterName + "-cluster-ca";
    }

    public static String clientsCaCertificateSecretName(String clusterName) {
        return clusterName + "-clients-ca-cert";
    }

    public static String clientsCaKeySecretName(String clusterName) {
        return clusterName + "-clients-ca";
    }

    public static String kafkaComponentName(String clusterName) {
        return clusterName + "-kafka";
    }

    public static String kafkaPodName(String clusterName, int podNum) {
        return KafkaResources.kafkaComponentName(clusterName) + "-" + podNum;
    }

    public static String kafkaPodName(String clusterName, String nodePoolName, int podNum) {
        return clusterName + "-" + nodePoolName + "-" + podNum;
    }

    public static String bootstrapServiceName(String clusterName) {
        return clusterName + "-kafka-bootstrap";
    }

    public static String plainBootstrapAddress(String clusterName) {
        return KafkaResources.bootstrapServiceName(clusterName) + ":9092";
    }

    public static String tlsBootstrapAddress(String clusterName) {
        return KafkaResources.bootstrapServiceName(clusterName) + ":9093";
    }

    public static String brokersServiceName(String clusterName) {
        return clusterName + "-kafka-brokers";
    }

    public static String externalBootstrapServiceName(String clusterName) {
        return clusterName + "-kafka-external-bootstrap";
    }

    public static String brokerSpecificService(String clusterName, int podNum) {
        return clusterName + "-kafka-" + podNum;
    }

    public static String kafkaMetricsAndLogConfigMapName(String clusterName) {
        return clusterName + "-kafka-config";
    }

    public static String initContainerClusterRoleBindingName(String cluster, String namespace) {
        return "strimzi-" + namespace + "-" + cluster + "-kafka-init";
    }

    public static String kafkaSecretName(String clusterName) {
        return clusterName + "-kafka-brokers";
    }

    public static String kafkaJmxSecretName(String clusterName) {
        return clusterName + "-kafka-jmx";
    }

    public static String kafkaNetworkPolicyName(String clusterName) {
        return clusterName + "-network-policy-kafka";
    }

    public static String zookeeperComponentName(String clusterName) {
        return clusterName + "-zookeeper";
    }

    public static String zookeeperPodName(String clusterName, int podNum) {
        return KafkaResources.zookeeperComponentName(clusterName) + "-" + podNum;
    }

    public static String zookeeperMetricsAndLogConfigMapName(String clusterName) {
        return clusterName + "-zookeeper-config";
    }

    public static String zookeeperServiceName(String clusterName) {
        return clusterName + "-zookeeper-client";
    }

    public static String zookeeperHeadlessServiceName(String clusterName) {
        return clusterName + "-zookeeper-nodes";
    }

    public static String zookeeperSecretName(String clusterName) {
        return clusterName + "-zookeeper-nodes";
    }

    public static String zookeeperJmxSecretName(String clusterName) {
        return clusterName + "-zookeeper-jmx";
    }

    public static String zookeeperNetworkPolicyName(String clusterName) {
        return clusterName + "-network-policy-zookeeper";
    }

    public static String entityOperatorDeploymentName(String clusterName) {
        return clusterName + "-entity-operator";
    }

    @Deprecated
    public static String entityOperatorSecretName(String clusterName) {
        return KafkaResources.entityOperatorDeploymentName(clusterName) + "-certs";
    }

    public static String entityTopicOperatorSecretName(String clusterName) {
        return clusterName + "-entity-topic-operator-certs";
    }

    public static String entityTopicOperatorCcApiSecretName(String clusterName) {
        return clusterName + "-entity-topic-operator-cc-api";
    }

    public static String entityTopicOperatorLoggingConfigMapName(String clusterName) {
        return clusterName + "-entity-topic-operator-config";
    }

    public static String entityTopicOperatorRoleBinding(String clusterName) {
        return clusterName + "-entity-topic-operator-role";
    }

    public static String entityUserOperatorSecretName(String clusterName) {
        return clusterName + "-entity-user-operator-certs";
    }

    public static String entityUserOperatorLoggingConfigMapName(String clusterName) {
        return clusterName + "-entity-user-operator-config";
    }

    public static String entityUserOperatorRoleBinding(String clusterName) {
        return clusterName + "-entity-user-operator-role";
    }

    public static String clusterOperatorCertsSecretName(String cluster) {
        return cluster + "-cluster-operator-certs";
    }

    public static String autoRebalancingKafkaRebalanceResourceName(String cluster, KafkaAutoRebalanceMode kafkaAutoRebalanceMode) {
        return cluster + "-auto-rebalancing-" + kafkaAutoRebalanceMode.toValue();
    }
}

