/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.common.ExternalLogging;
import io.strimzi.api.kafka.model.common.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.common.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.common.InlineLogging;
import io.strimzi.api.kafka.model.common.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.common.InlineLoggingFluent;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.common.JvmOptionsFluent;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.common.ProbeBuilder;
import io.strimzi.api.kafka.model.common.ProbeFluent;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetrics;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsBuilder;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsFluent;
import io.strimzi.api.kafka.model.common.metrics.MetricsConfig;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.BrokerCapacity;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.BrokerCapacityBuilder;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.BrokerCapacityFluent;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.CruiseControlApiUsers;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.CruiseControlSpec;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.CruiseControlTemplate;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.CruiseControlTemplateBuilder;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.CruiseControlTemplateFluent;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.HashLoginServiceApiUsers;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.HashLoginServiceApiUsersBuilder;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.HashLoginServiceApiUsersFluent;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceConfiguration;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceConfigurationBuilder;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceConfigurationFluent;
import io.strimzi.api.kafka.model.kafka.entityoperator.TlsSidecar;
import io.strimzi.api.kafka.model.kafka.entityoperator.TlsSidecarBuilder;
import io.strimzi.api.kafka.model.kafka.entityoperator.TlsSidecarFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CruiseControlSpecFluent<A extends CruiseControlSpecFluent<A>>
extends BaseFluent<A> {
    private String image;
    private TlsSidecarBuilder tlsSidecar;
    private ResourceRequirements resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private JvmOptionsBuilder jvmOptions;
    private VisitableBuilder<? extends Logging, ?> logging;
    private CruiseControlTemplateBuilder template;
    private BrokerCapacityBuilder brokerCapacity;
    private Map<String, Object> config;
    private VisitableBuilder<? extends MetricsConfig, ?> metricsConfig;
    private VisitableBuilder<? extends CruiseControlApiUsers, ?> apiUsers;
    private ArrayList<KafkaAutoRebalanceConfigurationBuilder> autoRebalance;

    public CruiseControlSpecFluent() {
    }

    public CruiseControlSpecFluent(CruiseControlSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CruiseControlSpec instance) {
        CruiseControlSpec cruiseControlSpec = instance = instance != null ? instance : new CruiseControlSpec();
        if (instance != null) {
            this.withImage(instance.getImage());
            this.withTlsSidecar(instance.getTlsSidecar());
            this.withResources(instance.getResources());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withJvmOptions(instance.getJvmOptions());
            this.withLogging(instance.getLogging());
            this.withTemplate(instance.getTemplate());
            this.withBrokerCapacity(instance.getBrokerCapacity());
            this.withConfig(instance.getConfig());
            this.withMetricsConfig(instance.getMetricsConfig());
            this.withApiUsers(instance.getApiUsers());
            this.withAutoRebalance(instance.getAutoRebalance());
        }
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public TlsSidecar buildTlsSidecar() {
        return this.tlsSidecar != null ? this.tlsSidecar.build() : null;
    }

    public A withTlsSidecar(TlsSidecar tlsSidecar) {
        this._visitables.remove((Object)"tlsSidecar");
        if (tlsSidecar != null) {
            this.tlsSidecar = new TlsSidecarBuilder(tlsSidecar);
            this._visitables.get((Object)"tlsSidecar").add(this.tlsSidecar);
        } else {
            this.tlsSidecar = null;
            this._visitables.get((Object)"tlsSidecar").remove((Object)this.tlsSidecar);
        }
        return (A)((Object)this);
    }

    public boolean hasTlsSidecar() {
        return this.tlsSidecar != null;
    }

    public TlsSidecarNested<A> withNewTlsSidecar() {
        return new TlsSidecarNested(null);
    }

    public TlsSidecarNested<A> withNewTlsSidecarLike(TlsSidecar item) {
        return new TlsSidecarNested(item);
    }

    public TlsSidecarNested<A> editTlsSidecar() {
        return this.withNewTlsSidecarLike(Optional.ofNullable(this.buildTlsSidecar()).orElse(null));
    }

    public TlsSidecarNested<A> editOrNewTlsSidecar() {
        return this.withNewTlsSidecarLike(Optional.ofNullable(this.buildTlsSidecar()).orElse(new TlsSidecarBuilder().build()));
    }

    public TlsSidecarNested<A> editOrNewTlsSidecarLike(TlsSidecar item) {
        return this.withNewTlsSidecarLike(Optional.ofNullable(this.buildTlsSidecar()).orElse(item));
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.remove((Object)"livenessProbe");
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.remove((Object)"readinessProbe");
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.remove((Object)"jvmOptions");
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.get((Object)"jvmOptions").add(this.jvmOptions);
        } else {
            this.jvmOptions = null;
            this._visitables.get((Object)"jvmOptions").remove((Object)this.jvmOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNested(null);
    }

    public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNested(item);
    }

    public JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(null));
    }

    public JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
    }

    public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(item));
    }

    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    public A withLogging(Logging logging) {
        if (logging == null) {
            this.logging = null;
            this._visitables.remove((Object)"logging");
            return (A)((Object)this);
        }
        VisitableBuilder builder = CruiseControlSpecFluent.builder(logging);
        this._visitables.get((Object)"logging").clear();
        this._visitables.get((Object)"logging").add(builder);
        this.logging = builder;
        return (A)((Object)this);
    }

    public boolean hasLogging() {
        return this.logging != null;
    }

    public InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNested(null);
    }

    public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNested(item);
    }

    public ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNested(null);
    }

    public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNested(item);
    }

    public CruiseControlTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(CruiseControlTemplate template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new CruiseControlTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(CruiseControlTemplate item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new CruiseControlTemplateBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(CruiseControlTemplate item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public BrokerCapacity buildBrokerCapacity() {
        return this.brokerCapacity != null ? this.brokerCapacity.build() : null;
    }

    public A withBrokerCapacity(BrokerCapacity brokerCapacity) {
        this._visitables.remove((Object)"brokerCapacity");
        if (brokerCapacity != null) {
            this.brokerCapacity = new BrokerCapacityBuilder(brokerCapacity);
            this._visitables.get((Object)"brokerCapacity").add(this.brokerCapacity);
        } else {
            this.brokerCapacity = null;
            this._visitables.get((Object)"brokerCapacity").remove((Object)this.brokerCapacity);
        }
        return (A)((Object)this);
    }

    public boolean hasBrokerCapacity() {
        return this.brokerCapacity != null;
    }

    public BrokerCapacityNested<A> withNewBrokerCapacity() {
        return new BrokerCapacityNested(null);
    }

    public BrokerCapacityNested<A> withNewBrokerCapacityLike(BrokerCapacity item) {
        return new BrokerCapacityNested(item);
    }

    public BrokerCapacityNested<A> editBrokerCapacity() {
        return this.withNewBrokerCapacityLike(Optional.ofNullable(this.buildBrokerCapacity()).orElse(null));
    }

    public BrokerCapacityNested<A> editOrNewBrokerCapacity() {
        return this.withNewBrokerCapacityLike(Optional.ofNullable(this.buildBrokerCapacity()).orElse(new BrokerCapacityBuilder().build()));
    }

    public BrokerCapacityNested<A> editOrNewBrokerCapacityLike(BrokerCapacity item) {
        return this.withNewBrokerCapacityLike(Optional.ofNullable(this.buildBrokerCapacity()).orElse(item));
    }

    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public <K, V> A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public MetricsConfig buildMetricsConfig() {
        return this.metricsConfig != null ? (MetricsConfig)this.metricsConfig.build() : null;
    }

    public A withMetricsConfig(MetricsConfig metricsConfig) {
        if (metricsConfig == null) {
            this.metricsConfig = null;
            this._visitables.remove((Object)"metricsConfig");
            return (A)((Object)this);
        }
        VisitableBuilder builder = CruiseControlSpecFluent.builder(metricsConfig);
        this._visitables.get((Object)"metricsConfig").clear();
        this._visitables.get((Object)"metricsConfig").add(builder);
        this.metricsConfig = builder;
        return (A)((Object)this);
    }

    public boolean hasMetricsConfig() {
        return this.metricsConfig != null;
    }

    public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
        return new JmxPrometheusExporterMetricsConfigNested(null);
    }

    public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item) {
        return new JmxPrometheusExporterMetricsConfigNested(item);
    }

    public CruiseControlApiUsers buildApiUsers() {
        return this.apiUsers != null ? (CruiseControlApiUsers)this.apiUsers.build() : null;
    }

    public A withApiUsers(CruiseControlApiUsers apiUsers) {
        if (apiUsers == null) {
            this.apiUsers = null;
            this._visitables.remove((Object)"apiUsers");
            return (A)((Object)this);
        }
        VisitableBuilder builder = CruiseControlSpecFluent.builder(apiUsers);
        this._visitables.get((Object)"apiUsers").clear();
        this._visitables.get((Object)"apiUsers").add(builder);
        this.apiUsers = builder;
        return (A)((Object)this);
    }

    public boolean hasApiUsers() {
        return this.apiUsers != null;
    }

    public HashLoginServiceApiUsersNested<A> withNewHashLoginServiceApiUsers() {
        return new HashLoginServiceApiUsersNested(null);
    }

    public HashLoginServiceApiUsersNested<A> withNewHashLoginServiceApiUsersLike(HashLoginServiceApiUsers item) {
        return new HashLoginServiceApiUsersNested(item);
    }

    public A addToAutoRebalance(int index, KafkaAutoRebalanceConfiguration item) {
        if (this.autoRebalance == null) {
            this.autoRebalance = new ArrayList();
        }
        KafkaAutoRebalanceConfigurationBuilder builder = new KafkaAutoRebalanceConfigurationBuilder(item);
        if (index < 0 || index >= this.autoRebalance.size()) {
            this._visitables.get((Object)"autoRebalance").add(builder);
            this.autoRebalance.add(builder);
        } else {
            this._visitables.get((Object)"autoRebalance").add(index, builder);
            this.autoRebalance.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAutoRebalance(int index, KafkaAutoRebalanceConfiguration item) {
        if (this.autoRebalance == null) {
            this.autoRebalance = new ArrayList();
        }
        KafkaAutoRebalanceConfigurationBuilder builder = new KafkaAutoRebalanceConfigurationBuilder(item);
        if (index < 0 || index >= this.autoRebalance.size()) {
            this._visitables.get((Object)"autoRebalance").add(builder);
            this.autoRebalance.add(builder);
        } else {
            this._visitables.get((Object)"autoRebalance").set(index, builder);
            this.autoRebalance.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAutoRebalance(KafkaAutoRebalanceConfiguration ... items) {
        if (this.autoRebalance == null) {
            this.autoRebalance = new ArrayList();
        }
        for (KafkaAutoRebalanceConfiguration item : items) {
            KafkaAutoRebalanceConfigurationBuilder builder = new KafkaAutoRebalanceConfigurationBuilder(item);
            this._visitables.get((Object)"autoRebalance").add(builder);
            this.autoRebalance.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAutoRebalance(Collection<KafkaAutoRebalanceConfiguration> items) {
        if (this.autoRebalance == null) {
            this.autoRebalance = new ArrayList();
        }
        for (KafkaAutoRebalanceConfiguration item : items) {
            KafkaAutoRebalanceConfigurationBuilder builder = new KafkaAutoRebalanceConfigurationBuilder(item);
            this._visitables.get((Object)"autoRebalance").add(builder);
            this.autoRebalance.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAutoRebalance(KafkaAutoRebalanceConfiguration ... items) {
        if (this.autoRebalance == null) {
            return (A)((Object)this);
        }
        for (KafkaAutoRebalanceConfiguration item : items) {
            KafkaAutoRebalanceConfigurationBuilder builder = new KafkaAutoRebalanceConfigurationBuilder(item);
            this._visitables.get((Object)"autoRebalance").remove((Object)builder);
            this.autoRebalance.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAutoRebalance(Collection<KafkaAutoRebalanceConfiguration> items) {
        if (this.autoRebalance == null) {
            return (A)((Object)this);
        }
        for (KafkaAutoRebalanceConfiguration item : items) {
            KafkaAutoRebalanceConfigurationBuilder builder = new KafkaAutoRebalanceConfigurationBuilder(item);
            this._visitables.get((Object)"autoRebalance").remove((Object)builder);
            this.autoRebalance.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAutoRebalance(Predicate<KafkaAutoRebalanceConfigurationBuilder> predicate) {
        if (this.autoRebalance == null) {
            return (A)((Object)this);
        }
        Iterator<KafkaAutoRebalanceConfigurationBuilder> each = this.autoRebalance.iterator();
        List visitables = this._visitables.get((Object)"autoRebalance");
        while (each.hasNext()) {
            KafkaAutoRebalanceConfigurationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<KafkaAutoRebalanceConfiguration> buildAutoRebalance() {
        return this.autoRebalance != null ? CruiseControlSpecFluent.build(this.autoRebalance) : null;
    }

    public KafkaAutoRebalanceConfiguration buildAutoRebalance(int index) {
        return this.autoRebalance.get(index).build();
    }

    public KafkaAutoRebalanceConfiguration buildFirstAutoRebalance() {
        return this.autoRebalance.get(0).build();
    }

    public KafkaAutoRebalanceConfiguration buildLastAutoRebalance() {
        return this.autoRebalance.get(this.autoRebalance.size() - 1).build();
    }

    public KafkaAutoRebalanceConfiguration buildMatchingAutoRebalance(Predicate<KafkaAutoRebalanceConfigurationBuilder> predicate) {
        for (KafkaAutoRebalanceConfigurationBuilder item : this.autoRebalance) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAutoRebalance(Predicate<KafkaAutoRebalanceConfigurationBuilder> predicate) {
        for (KafkaAutoRebalanceConfigurationBuilder item : this.autoRebalance) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAutoRebalance(List<KafkaAutoRebalanceConfiguration> autoRebalance) {
        if (this.autoRebalance != null) {
            this._visitables.get((Object)"autoRebalance").clear();
        }
        if (autoRebalance != null) {
            this.autoRebalance = new ArrayList();
            for (KafkaAutoRebalanceConfiguration item : autoRebalance) {
                this.addToAutoRebalance(item);
            }
        } else {
            this.autoRebalance = null;
        }
        return (A)((Object)this);
    }

    public A withAutoRebalance(KafkaAutoRebalanceConfiguration ... autoRebalance) {
        if (this.autoRebalance != null) {
            this.autoRebalance.clear();
            this._visitables.remove((Object)"autoRebalance");
        }
        if (autoRebalance != null) {
            for (KafkaAutoRebalanceConfiguration item : autoRebalance) {
                this.addToAutoRebalance(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAutoRebalance() {
        return this.autoRebalance != null && !this.autoRebalance.isEmpty();
    }

    public AutoRebalanceNested<A> addNewAutoRebalance() {
        return new AutoRebalanceNested(-1, null);
    }

    public AutoRebalanceNested<A> addNewAutoRebalanceLike(KafkaAutoRebalanceConfiguration item) {
        return new AutoRebalanceNested(-1, item);
    }

    public AutoRebalanceNested<A> setNewAutoRebalanceLike(int index, KafkaAutoRebalanceConfiguration item) {
        return new AutoRebalanceNested(index, item);
    }

    public AutoRebalanceNested<A> editAutoRebalance(int index) {
        if (this.autoRebalance.size() <= index) {
            throw new RuntimeException("Can't edit autoRebalance. Index exceeds size.");
        }
        return this.setNewAutoRebalanceLike(index, this.buildAutoRebalance(index));
    }

    public AutoRebalanceNested<A> editFirstAutoRebalance() {
        if (this.autoRebalance.size() == 0) {
            throw new RuntimeException("Can't edit first autoRebalance. The list is empty.");
        }
        return this.setNewAutoRebalanceLike(0, this.buildAutoRebalance(0));
    }

    public AutoRebalanceNested<A> editLastAutoRebalance() {
        int index = this.autoRebalance.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last autoRebalance. The list is empty.");
        }
        return this.setNewAutoRebalanceLike(index, this.buildAutoRebalance(index));
    }

    public AutoRebalanceNested<A> editMatchingAutoRebalance(Predicate<KafkaAutoRebalanceConfigurationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.autoRebalance.size(); ++i) {
            if (!predicate.test(this.autoRebalance.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching autoRebalance. No match found.");
        }
        return this.setNewAutoRebalanceLike(index, this.buildAutoRebalance(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CruiseControlSpecFluent that = (CruiseControlSpecFluent)((Object)o);
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsSidecar, (Object)that.tlsSidecar)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals((Object)this.livenessProbe, (Object)that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.readinessProbe, (Object)that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.jvmOptions, (Object)that.jvmOptions)) {
            return false;
        }
        if (!Objects.equals(this.logging, that.logging)) {
            return false;
        }
        if (!Objects.equals((Object)this.template, (Object)that.template)) {
            return false;
        }
        if (!Objects.equals((Object)this.brokerCapacity, (Object)that.brokerCapacity)) {
            return false;
        }
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.metricsConfig, that.metricsConfig)) {
            return false;
        }
        if (!Objects.equals(this.apiUsers, that.apiUsers)) {
            return false;
        }
        return Objects.equals(this.autoRebalance, that.autoRebalance);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.image, this.tlsSidecar, this.resources, this.livenessProbe, this.readinessProbe, this.jvmOptions, this.logging, this.template, this.brokerCapacity, this.config, this.metricsConfig, this.apiUsers, this.autoRebalance, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.tlsSidecar != null) {
            sb.append("tlsSidecar:");
            sb.append(this.tlsSidecar + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append(this.livenessProbe + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append(this.readinessProbe + ",");
        }
        if (this.jvmOptions != null) {
            sb.append("jvmOptions:");
            sb.append(this.jvmOptions + ",");
        }
        if (this.logging != null) {
            sb.append("logging:");
            sb.append(this.logging + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.brokerCapacity != null) {
            sb.append("brokerCapacity:");
            sb.append(this.brokerCapacity + ",");
        }
        if (this.config != null && !this.config.isEmpty()) {
            sb.append("config:");
            sb.append(this.config + ",");
        }
        if (this.metricsConfig != null) {
            sb.append("metricsConfig:");
            sb.append(this.metricsConfig + ",");
        }
        if (this.apiUsers != null) {
            sb.append("apiUsers:");
            sb.append(this.apiUsers + ",");
        }
        if (this.autoRebalance != null && !this.autoRebalance.isEmpty()) {
            sb.append("autoRebalance:");
            sb.append(this.autoRebalance);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.common.InlineLogging": {
                return new InlineLoggingBuilder((InlineLogging)item);
            }
            case "io.strimzi.api.kafka.model.common.ExternalLogging": {
                return new ExternalLoggingBuilder((ExternalLogging)item);
            }
            case "io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetrics": {
                return new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics)item);
            }
            case "io.strimzi.api.kafka.model.kafka.cruisecontrol.HashLoginServiceApiUsers": {
                return new HashLoginServiceApiUsersBuilder((HashLoginServiceApiUsers)item);
            }
        }
        return CruiseControlSpecFluent.builderOf((Object)item);
    }

    public class TlsSidecarNested<N>
    extends TlsSidecarFluent<TlsSidecarNested<N>>
    implements Nested<N> {
        TlsSidecarBuilder builder;

        TlsSidecarNested(TlsSidecar item) {
            this.builder = new TlsSidecarBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlSpecFluent.this.withTlsSidecar(this.builder.build());
        }

        public N endTlsSidecar() {
            return this.and();
        }
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlSpecFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlSpecFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class JvmOptionsNested<N>
    extends JvmOptionsFluent<JvmOptionsNested<N>>
    implements Nested<N> {
        JvmOptionsBuilder builder;

        JvmOptionsNested(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlSpecFluent.this.withJvmOptions(this.builder.build());
        }

        public N endJvmOptions() {
            return this.and();
        }
    }

    public class InlineLoggingNested<N>
    extends InlineLoggingFluent<InlineLoggingNested<N>>
    implements Nested<N> {
        InlineLoggingBuilder builder;

        InlineLoggingNested(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlSpecFluent.this.withLogging(this.builder.build());
        }

        public N endInlineLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingNested<N>
    extends ExternalLoggingFluent<ExternalLoggingNested<N>>
    implements Nested<N> {
        ExternalLoggingBuilder builder;

        ExternalLoggingNested(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlSpecFluent.this.withLogging(this.builder.build());
        }

        public N endExternalLogging() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends CruiseControlTemplateFluent<TemplateNested<N>>
    implements Nested<N> {
        CruiseControlTemplateBuilder builder;

        TemplateNested(CruiseControlTemplate item) {
            this.builder = new CruiseControlTemplateBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class BrokerCapacityNested<N>
    extends BrokerCapacityFluent<BrokerCapacityNested<N>>
    implements Nested<N> {
        BrokerCapacityBuilder builder;

        BrokerCapacityNested(BrokerCapacity item) {
            this.builder = new BrokerCapacityBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlSpecFluent.this.withBrokerCapacity(this.builder.build());
        }

        public N endBrokerCapacity() {
            return this.and();
        }
    }

    public class JmxPrometheusExporterMetricsConfigNested<N>
    extends JmxPrometheusExporterMetricsFluent<JmxPrometheusExporterMetricsConfigNested<N>>
    implements Nested<N> {
        JmxPrometheusExporterMetricsBuilder builder;

        JmxPrometheusExporterMetricsConfigNested(JmxPrometheusExporterMetrics item) {
            this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlSpecFluent.this.withMetricsConfig(this.builder.build());
        }

        public N endJmxPrometheusExporterMetricsConfig() {
            return this.and();
        }
    }

    public class HashLoginServiceApiUsersNested<N>
    extends HashLoginServiceApiUsersFluent<HashLoginServiceApiUsersNested<N>>
    implements Nested<N> {
        HashLoginServiceApiUsersBuilder builder;

        HashLoginServiceApiUsersNested(HashLoginServiceApiUsers item) {
            this.builder = new HashLoginServiceApiUsersBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlSpecFluent.this.withApiUsers(this.builder.build());
        }

        public N endHashLoginServiceApiUsers() {
            return this.and();
        }
    }

    public class AutoRebalanceNested<N>
    extends KafkaAutoRebalanceConfigurationFluent<AutoRebalanceNested<N>>
    implements Nested<N> {
        KafkaAutoRebalanceConfigurationBuilder builder;
        int index;

        AutoRebalanceNested(int index, KafkaAutoRebalanceConfiguration item) {
            this.index = index;
            this.builder = new KafkaAutoRebalanceConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlSpecFluent.this.setToAutoRebalance(this.index, this.builder.build());
        }

        public N endAutoRebalance() {
            return this.and();
        }
    }
}

