/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceState;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceStatus;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceStatusBrokers;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceStatusBrokersBuilder;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceStatusBrokersFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaAutoRebalanceStatusFluent<A extends KafkaAutoRebalanceStatusFluent<A>>
extends BaseFluent<A> {
    private KafkaAutoRebalanceState state;
    private String lastTransitionTime;
    private ArrayList<KafkaAutoRebalanceStatusBrokersBuilder> modes;

    public KafkaAutoRebalanceStatusFluent() {
    }

    public KafkaAutoRebalanceStatusFluent(KafkaAutoRebalanceStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaAutoRebalanceStatus instance) {
        KafkaAutoRebalanceStatus kafkaAutoRebalanceStatus = instance = instance != null ? instance : new KafkaAutoRebalanceStatus();
        if (instance != null) {
            this.withState(instance.getState());
            this.withLastTransitionTime(instance.getLastTransitionTime());
            this.withModes(instance.getModes());
        }
    }

    public KafkaAutoRebalanceState getState() {
        return this.state;
    }

    public A withState(KafkaAutoRebalanceState state) {
        this.state = state;
        return (A)((Object)this);
    }

    public boolean hasState() {
        return this.state != null;
    }

    public String getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public A withLastTransitionTime(String lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return (A)((Object)this);
    }

    public boolean hasLastTransitionTime() {
        return this.lastTransitionTime != null;
    }

    public A addToModes(int index, KafkaAutoRebalanceStatusBrokers item) {
        if (this.modes == null) {
            this.modes = new ArrayList();
        }
        KafkaAutoRebalanceStatusBrokersBuilder builder = new KafkaAutoRebalanceStatusBrokersBuilder(item);
        if (index < 0 || index >= this.modes.size()) {
            this._visitables.get((Object)"modes").add(builder);
            this.modes.add(builder);
        } else {
            this._visitables.get((Object)"modes").add(index, builder);
            this.modes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToModes(int index, KafkaAutoRebalanceStatusBrokers item) {
        if (this.modes == null) {
            this.modes = new ArrayList();
        }
        KafkaAutoRebalanceStatusBrokersBuilder builder = new KafkaAutoRebalanceStatusBrokersBuilder(item);
        if (index < 0 || index >= this.modes.size()) {
            this._visitables.get((Object)"modes").add(builder);
            this.modes.add(builder);
        } else {
            this._visitables.get((Object)"modes").set(index, builder);
            this.modes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToModes(KafkaAutoRebalanceStatusBrokers ... items) {
        if (this.modes == null) {
            this.modes = new ArrayList();
        }
        for (KafkaAutoRebalanceStatusBrokers item : items) {
            KafkaAutoRebalanceStatusBrokersBuilder builder = new KafkaAutoRebalanceStatusBrokersBuilder(item);
            this._visitables.get((Object)"modes").add(builder);
            this.modes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToModes(Collection<KafkaAutoRebalanceStatusBrokers> items) {
        if (this.modes == null) {
            this.modes = new ArrayList();
        }
        for (KafkaAutoRebalanceStatusBrokers item : items) {
            KafkaAutoRebalanceStatusBrokersBuilder builder = new KafkaAutoRebalanceStatusBrokersBuilder(item);
            this._visitables.get((Object)"modes").add(builder);
            this.modes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromModes(KafkaAutoRebalanceStatusBrokers ... items) {
        if (this.modes == null) {
            return (A)((Object)this);
        }
        for (KafkaAutoRebalanceStatusBrokers item : items) {
            KafkaAutoRebalanceStatusBrokersBuilder builder = new KafkaAutoRebalanceStatusBrokersBuilder(item);
            this._visitables.get((Object)"modes").remove((Object)builder);
            this.modes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromModes(Collection<KafkaAutoRebalanceStatusBrokers> items) {
        if (this.modes == null) {
            return (A)((Object)this);
        }
        for (KafkaAutoRebalanceStatusBrokers item : items) {
            KafkaAutoRebalanceStatusBrokersBuilder builder = new KafkaAutoRebalanceStatusBrokersBuilder(item);
            this._visitables.get((Object)"modes").remove((Object)builder);
            this.modes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromModes(Predicate<KafkaAutoRebalanceStatusBrokersBuilder> predicate) {
        if (this.modes == null) {
            return (A)((Object)this);
        }
        Iterator<KafkaAutoRebalanceStatusBrokersBuilder> each = this.modes.iterator();
        List visitables = this._visitables.get((Object)"modes");
        while (each.hasNext()) {
            KafkaAutoRebalanceStatusBrokersBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<KafkaAutoRebalanceStatusBrokers> buildModes() {
        return this.modes != null ? KafkaAutoRebalanceStatusFluent.build(this.modes) : null;
    }

    public KafkaAutoRebalanceStatusBrokers buildMode(int index) {
        return this.modes.get(index).build();
    }

    public KafkaAutoRebalanceStatusBrokers buildFirstMode() {
        return this.modes.get(0).build();
    }

    public KafkaAutoRebalanceStatusBrokers buildLastMode() {
        return this.modes.get(this.modes.size() - 1).build();
    }

    public KafkaAutoRebalanceStatusBrokers buildMatchingMode(Predicate<KafkaAutoRebalanceStatusBrokersBuilder> predicate) {
        for (KafkaAutoRebalanceStatusBrokersBuilder item : this.modes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMode(Predicate<KafkaAutoRebalanceStatusBrokersBuilder> predicate) {
        for (KafkaAutoRebalanceStatusBrokersBuilder item : this.modes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withModes(List<KafkaAutoRebalanceStatusBrokers> modes) {
        if (this.modes != null) {
            this._visitables.get((Object)"modes").clear();
        }
        if (modes != null) {
            this.modes = new ArrayList();
            for (KafkaAutoRebalanceStatusBrokers item : modes) {
                this.addToModes(item);
            }
        } else {
            this.modes = null;
        }
        return (A)((Object)this);
    }

    public A withModes(KafkaAutoRebalanceStatusBrokers ... modes) {
        if (this.modes != null) {
            this.modes.clear();
            this._visitables.remove((Object)"modes");
        }
        if (modes != null) {
            for (KafkaAutoRebalanceStatusBrokers item : modes) {
                this.addToModes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasModes() {
        return this.modes != null && !this.modes.isEmpty();
    }

    public ModesNested<A> addNewMode() {
        return new ModesNested(-1, null);
    }

    public ModesNested<A> addNewModeLike(KafkaAutoRebalanceStatusBrokers item) {
        return new ModesNested(-1, item);
    }

    public ModesNested<A> setNewModeLike(int index, KafkaAutoRebalanceStatusBrokers item) {
        return new ModesNested(index, item);
    }

    public ModesNested<A> editMode(int index) {
        if (this.modes.size() <= index) {
            throw new RuntimeException("Can't edit modes. Index exceeds size.");
        }
        return this.setNewModeLike(index, this.buildMode(index));
    }

    public ModesNested<A> editFirstMode() {
        if (this.modes.size() == 0) {
            throw new RuntimeException("Can't edit first modes. The list is empty.");
        }
        return this.setNewModeLike(0, this.buildMode(0));
    }

    public ModesNested<A> editLastMode() {
        int index = this.modes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last modes. The list is empty.");
        }
        return this.setNewModeLike(index, this.buildMode(index));
    }

    public ModesNested<A> editMatchingMode(Predicate<KafkaAutoRebalanceStatusBrokersBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.modes.size(); ++i) {
            if (!predicate.test(this.modes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching modes. No match found.");
        }
        return this.setNewModeLike(index, this.buildMode(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaAutoRebalanceStatusFluent that = (KafkaAutoRebalanceStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.state, (Object)that.state)) {
            return false;
        }
        if (!Objects.equals(this.lastTransitionTime, that.lastTransitionTime)) {
            return false;
        }
        return Objects.equals(this.modes, that.modes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.lastTransitionTime, this.modes, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.state != null) {
            sb.append("state:");
            sb.append(this.state + ",");
        }
        if (this.lastTransitionTime != null) {
            sb.append("lastTransitionTime:");
            sb.append(this.lastTransitionTime + ",");
        }
        if (this.modes != null && !this.modes.isEmpty()) {
            sb.append("modes:");
            sb.append(this.modes);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ModesNested<N>
    extends KafkaAutoRebalanceStatusBrokersFluent<ModesNested<N>>
    implements Nested<N> {
        KafkaAutoRebalanceStatusBrokersBuilder builder;
        int index;

        ModesNested(int index, KafkaAutoRebalanceStatusBrokers item) {
            this.index = index;
            this.builder = new KafkaAutoRebalanceStatusBrokersBuilder(this, item);
        }

        public N and() {
            return (N)KafkaAutoRebalanceStatusFluent.this.setToModes(this.index, this.builder.build());
        }

        public N endMode() {
            return this.and();
        }
    }
}

