/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.entityoperator;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateFluent;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplate;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.PodTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateFluent;
import io.strimzi.api.kafka.model.kafka.entityoperator.EntityOperatorTemplate;
import java.util.Objects;
import java.util.Optional;

public class EntityOperatorTemplateFluent<A extends EntityOperatorTemplateFluent<A>>
extends BaseFluent<A> {
    private DeploymentTemplateBuilder deployment;
    private PodTemplateBuilder pod;
    private ResourceTemplateBuilder entityOperatorRole;
    private ResourceTemplateBuilder topicOperatorRoleBinding;
    private ResourceTemplateBuilder userOperatorRoleBinding;
    private ContainerTemplateBuilder topicOperatorContainer;
    private ContainerTemplateBuilder userOperatorContainer;
    private ContainerTemplateBuilder tlsSidecarContainer;
    private ResourceTemplateBuilder serviceAccount;

    public EntityOperatorTemplateFluent() {
    }

    public EntityOperatorTemplateFluent(EntityOperatorTemplate instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EntityOperatorTemplate instance) {
        EntityOperatorTemplate entityOperatorTemplate = instance = instance != null ? instance : new EntityOperatorTemplate();
        if (instance != null) {
            this.withDeployment(instance.getDeployment());
            this.withPod(instance.getPod());
            this.withEntityOperatorRole(instance.getEntityOperatorRole());
            this.withTopicOperatorRoleBinding(instance.getTopicOperatorRoleBinding());
            this.withUserOperatorRoleBinding(instance.getUserOperatorRoleBinding());
            this.withTopicOperatorContainer(instance.getTopicOperatorContainer());
            this.withUserOperatorContainer(instance.getUserOperatorContainer());
            this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
            this.withServiceAccount(instance.getServiceAccount());
        }
    }

    public DeploymentTemplate buildDeployment() {
        return this.deployment != null ? this.deployment.build() : null;
    }

    public A withDeployment(DeploymentTemplate deployment) {
        this._visitables.remove((Object)"deployment");
        if (deployment != null) {
            this.deployment = new DeploymentTemplateBuilder(deployment);
            this._visitables.get((Object)"deployment").add(this.deployment);
        } else {
            this.deployment = null;
            this._visitables.get((Object)"deployment").remove((Object)this.deployment);
        }
        return (A)((Object)this);
    }

    public boolean hasDeployment() {
        return this.deployment != null;
    }

    public DeploymentNested<A> withNewDeployment() {
        return new DeploymentNested(null);
    }

    public DeploymentNested<A> withNewDeploymentLike(DeploymentTemplate item) {
        return new DeploymentNested(item);
    }

    public DeploymentNested<A> editDeployment() {
        return this.withNewDeploymentLike(Optional.ofNullable(this.buildDeployment()).orElse(null));
    }

    public DeploymentNested<A> editOrNewDeployment() {
        return this.withNewDeploymentLike(Optional.ofNullable(this.buildDeployment()).orElse(new DeploymentTemplateBuilder().build()));
    }

    public DeploymentNested<A> editOrNewDeploymentLike(DeploymentTemplate item) {
        return this.withNewDeploymentLike(Optional.ofNullable(this.buildDeployment()).orElse(item));
    }

    public PodTemplate buildPod() {
        return this.pod != null ? this.pod.build() : null;
    }

    public A withPod(PodTemplate pod) {
        this._visitables.remove((Object)"pod");
        if (pod != null) {
            this.pod = new PodTemplateBuilder(pod);
            this._visitables.get((Object)"pod").add(this.pod);
        } else {
            this.pod = null;
            this._visitables.get((Object)"pod").remove((Object)this.pod);
        }
        return (A)((Object)this);
    }

    public boolean hasPod() {
        return this.pod != null;
    }

    public PodNested<A> withNewPod() {
        return new PodNested(null);
    }

    public PodNested<A> withNewPodLike(PodTemplate item) {
        return new PodNested(item);
    }

    public PodNested<A> editPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(null));
    }

    public PodNested<A> editOrNewPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(new PodTemplateBuilder().build()));
    }

    public PodNested<A> editOrNewPodLike(PodTemplate item) {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(item));
    }

    public ResourceTemplate buildEntityOperatorRole() {
        return this.entityOperatorRole != null ? this.entityOperatorRole.build() : null;
    }

    public A withEntityOperatorRole(ResourceTemplate entityOperatorRole) {
        this._visitables.remove((Object)"entityOperatorRole");
        if (entityOperatorRole != null) {
            this.entityOperatorRole = new ResourceTemplateBuilder(entityOperatorRole);
            this._visitables.get((Object)"entityOperatorRole").add(this.entityOperatorRole);
        } else {
            this.entityOperatorRole = null;
            this._visitables.get((Object)"entityOperatorRole").remove((Object)this.entityOperatorRole);
        }
        return (A)((Object)this);
    }

    public boolean hasEntityOperatorRole() {
        return this.entityOperatorRole != null;
    }

    public EntityOperatorRoleNested<A> withNewEntityOperatorRole() {
        return new EntityOperatorRoleNested(null);
    }

    public EntityOperatorRoleNested<A> withNewEntityOperatorRoleLike(ResourceTemplate item) {
        return new EntityOperatorRoleNested(item);
    }

    public EntityOperatorRoleNested<A> editEntityOperatorRole() {
        return this.withNewEntityOperatorRoleLike(Optional.ofNullable(this.buildEntityOperatorRole()).orElse(null));
    }

    public EntityOperatorRoleNested<A> editOrNewEntityOperatorRole() {
        return this.withNewEntityOperatorRoleLike(Optional.ofNullable(this.buildEntityOperatorRole()).orElse(new ResourceTemplateBuilder().build()));
    }

    public EntityOperatorRoleNested<A> editOrNewEntityOperatorRoleLike(ResourceTemplate item) {
        return this.withNewEntityOperatorRoleLike(Optional.ofNullable(this.buildEntityOperatorRole()).orElse(item));
    }

    public ResourceTemplate buildTopicOperatorRoleBinding() {
        return this.topicOperatorRoleBinding != null ? this.topicOperatorRoleBinding.build() : null;
    }

    public A withTopicOperatorRoleBinding(ResourceTemplate topicOperatorRoleBinding) {
        this._visitables.remove((Object)"topicOperatorRoleBinding");
        if (topicOperatorRoleBinding != null) {
            this.topicOperatorRoleBinding = new ResourceTemplateBuilder(topicOperatorRoleBinding);
            this._visitables.get((Object)"topicOperatorRoleBinding").add(this.topicOperatorRoleBinding);
        } else {
            this.topicOperatorRoleBinding = null;
            this._visitables.get((Object)"topicOperatorRoleBinding").remove((Object)this.topicOperatorRoleBinding);
        }
        return (A)((Object)this);
    }

    public boolean hasTopicOperatorRoleBinding() {
        return this.topicOperatorRoleBinding != null;
    }

    public TopicOperatorRoleBindingNested<A> withNewTopicOperatorRoleBinding() {
        return new TopicOperatorRoleBindingNested(null);
    }

    public TopicOperatorRoleBindingNested<A> withNewTopicOperatorRoleBindingLike(ResourceTemplate item) {
        return new TopicOperatorRoleBindingNested(item);
    }

    public TopicOperatorRoleBindingNested<A> editTopicOperatorRoleBinding() {
        return this.withNewTopicOperatorRoleBindingLike(Optional.ofNullable(this.buildTopicOperatorRoleBinding()).orElse(null));
    }

    public TopicOperatorRoleBindingNested<A> editOrNewTopicOperatorRoleBinding() {
        return this.withNewTopicOperatorRoleBindingLike(Optional.ofNullable(this.buildTopicOperatorRoleBinding()).orElse(new ResourceTemplateBuilder().build()));
    }

    public TopicOperatorRoleBindingNested<A> editOrNewTopicOperatorRoleBindingLike(ResourceTemplate item) {
        return this.withNewTopicOperatorRoleBindingLike(Optional.ofNullable(this.buildTopicOperatorRoleBinding()).orElse(item));
    }

    public ResourceTemplate buildUserOperatorRoleBinding() {
        return this.userOperatorRoleBinding != null ? this.userOperatorRoleBinding.build() : null;
    }

    public A withUserOperatorRoleBinding(ResourceTemplate userOperatorRoleBinding) {
        this._visitables.remove((Object)"userOperatorRoleBinding");
        if (userOperatorRoleBinding != null) {
            this.userOperatorRoleBinding = new ResourceTemplateBuilder(userOperatorRoleBinding);
            this._visitables.get((Object)"userOperatorRoleBinding").add(this.userOperatorRoleBinding);
        } else {
            this.userOperatorRoleBinding = null;
            this._visitables.get((Object)"userOperatorRoleBinding").remove((Object)this.userOperatorRoleBinding);
        }
        return (A)((Object)this);
    }

    public boolean hasUserOperatorRoleBinding() {
        return this.userOperatorRoleBinding != null;
    }

    public UserOperatorRoleBindingNested<A> withNewUserOperatorRoleBinding() {
        return new UserOperatorRoleBindingNested(null);
    }

    public UserOperatorRoleBindingNested<A> withNewUserOperatorRoleBindingLike(ResourceTemplate item) {
        return new UserOperatorRoleBindingNested(item);
    }

    public UserOperatorRoleBindingNested<A> editUserOperatorRoleBinding() {
        return this.withNewUserOperatorRoleBindingLike(Optional.ofNullable(this.buildUserOperatorRoleBinding()).orElse(null));
    }

    public UserOperatorRoleBindingNested<A> editOrNewUserOperatorRoleBinding() {
        return this.withNewUserOperatorRoleBindingLike(Optional.ofNullable(this.buildUserOperatorRoleBinding()).orElse(new ResourceTemplateBuilder().build()));
    }

    public UserOperatorRoleBindingNested<A> editOrNewUserOperatorRoleBindingLike(ResourceTemplate item) {
        return this.withNewUserOperatorRoleBindingLike(Optional.ofNullable(this.buildUserOperatorRoleBinding()).orElse(item));
    }

    public ContainerTemplate buildTopicOperatorContainer() {
        return this.topicOperatorContainer != null ? this.topicOperatorContainer.build() : null;
    }

    public A withTopicOperatorContainer(ContainerTemplate topicOperatorContainer) {
        this._visitables.remove((Object)"topicOperatorContainer");
        if (topicOperatorContainer != null) {
            this.topicOperatorContainer = new ContainerTemplateBuilder(topicOperatorContainer);
            this._visitables.get((Object)"topicOperatorContainer").add(this.topicOperatorContainer);
        } else {
            this.topicOperatorContainer = null;
            this._visitables.get((Object)"topicOperatorContainer").remove((Object)this.topicOperatorContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasTopicOperatorContainer() {
        return this.topicOperatorContainer != null;
    }

    public TopicOperatorContainerNested<A> withNewTopicOperatorContainer() {
        return new TopicOperatorContainerNested(null);
    }

    public TopicOperatorContainerNested<A> withNewTopicOperatorContainerLike(ContainerTemplate item) {
        return new TopicOperatorContainerNested(item);
    }

    public TopicOperatorContainerNested<A> editTopicOperatorContainer() {
        return this.withNewTopicOperatorContainerLike(Optional.ofNullable(this.buildTopicOperatorContainer()).orElse(null));
    }

    public TopicOperatorContainerNested<A> editOrNewTopicOperatorContainer() {
        return this.withNewTopicOperatorContainerLike(Optional.ofNullable(this.buildTopicOperatorContainer()).orElse(new ContainerTemplateBuilder().build()));
    }

    public TopicOperatorContainerNested<A> editOrNewTopicOperatorContainerLike(ContainerTemplate item) {
        return this.withNewTopicOperatorContainerLike(Optional.ofNullable(this.buildTopicOperatorContainer()).orElse(item));
    }

    public ContainerTemplate buildUserOperatorContainer() {
        return this.userOperatorContainer != null ? this.userOperatorContainer.build() : null;
    }

    public A withUserOperatorContainer(ContainerTemplate userOperatorContainer) {
        this._visitables.remove((Object)"userOperatorContainer");
        if (userOperatorContainer != null) {
            this.userOperatorContainer = new ContainerTemplateBuilder(userOperatorContainer);
            this._visitables.get((Object)"userOperatorContainer").add(this.userOperatorContainer);
        } else {
            this.userOperatorContainer = null;
            this._visitables.get((Object)"userOperatorContainer").remove((Object)this.userOperatorContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasUserOperatorContainer() {
        return this.userOperatorContainer != null;
    }

    public UserOperatorContainerNested<A> withNewUserOperatorContainer() {
        return new UserOperatorContainerNested(null);
    }

    public UserOperatorContainerNested<A> withNewUserOperatorContainerLike(ContainerTemplate item) {
        return new UserOperatorContainerNested(item);
    }

    public UserOperatorContainerNested<A> editUserOperatorContainer() {
        return this.withNewUserOperatorContainerLike(Optional.ofNullable(this.buildUserOperatorContainer()).orElse(null));
    }

    public UserOperatorContainerNested<A> editOrNewUserOperatorContainer() {
        return this.withNewUserOperatorContainerLike(Optional.ofNullable(this.buildUserOperatorContainer()).orElse(new ContainerTemplateBuilder().build()));
    }

    public UserOperatorContainerNested<A> editOrNewUserOperatorContainerLike(ContainerTemplate item) {
        return this.withNewUserOperatorContainerLike(Optional.ofNullable(this.buildUserOperatorContainer()).orElse(item));
    }

    public ContainerTemplate buildTlsSidecarContainer() {
        return this.tlsSidecarContainer != null ? this.tlsSidecarContainer.build() : null;
    }

    public A withTlsSidecarContainer(ContainerTemplate tlsSidecarContainer) {
        this._visitables.remove((Object)"tlsSidecarContainer");
        if (tlsSidecarContainer != null) {
            this.tlsSidecarContainer = new ContainerTemplateBuilder(tlsSidecarContainer);
            this._visitables.get((Object)"tlsSidecarContainer").add(this.tlsSidecarContainer);
        } else {
            this.tlsSidecarContainer = null;
            this._visitables.get((Object)"tlsSidecarContainer").remove((Object)this.tlsSidecarContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasTlsSidecarContainer() {
        return this.tlsSidecarContainer != null;
    }

    public TlsSidecarContainerNested<A> withNewTlsSidecarContainer() {
        return new TlsSidecarContainerNested(null);
    }

    public TlsSidecarContainerNested<A> withNewTlsSidecarContainerLike(ContainerTemplate item) {
        return new TlsSidecarContainerNested(item);
    }

    public TlsSidecarContainerNested<A> editTlsSidecarContainer() {
        return this.withNewTlsSidecarContainerLike(Optional.ofNullable(this.buildTlsSidecarContainer()).orElse(null));
    }

    public TlsSidecarContainerNested<A> editOrNewTlsSidecarContainer() {
        return this.withNewTlsSidecarContainerLike(Optional.ofNullable(this.buildTlsSidecarContainer()).orElse(new ContainerTemplateBuilder().build()));
    }

    public TlsSidecarContainerNested<A> editOrNewTlsSidecarContainerLike(ContainerTemplate item) {
        return this.withNewTlsSidecarContainerLike(Optional.ofNullable(this.buildTlsSidecarContainer()).orElse(item));
    }

    public ResourceTemplate buildServiceAccount() {
        return this.serviceAccount != null ? this.serviceAccount.build() : null;
    }

    public A withServiceAccount(ResourceTemplate serviceAccount) {
        this._visitables.remove((Object)"serviceAccount");
        if (serviceAccount != null) {
            this.serviceAccount = new ResourceTemplateBuilder(serviceAccount);
            this._visitables.get((Object)"serviceAccount").add(this.serviceAccount);
        } else {
            this.serviceAccount = null;
            this._visitables.get((Object)"serviceAccount").remove((Object)this.serviceAccount);
        }
        return (A)((Object)this);
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public ServiceAccountNested<A> withNewServiceAccount() {
        return new ServiceAccountNested(null);
    }

    public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
        return new ServiceAccountNested(item);
    }

    public ServiceAccountNested<A> editServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(null));
    }

    public ServiceAccountNested<A> editOrNewServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
    }

    public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntityOperatorTemplateFluent that = (EntityOperatorTemplateFluent)((Object)o);
        if (!Objects.equals((Object)this.deployment, (Object)that.deployment)) {
            return false;
        }
        if (!Objects.equals((Object)this.pod, (Object)that.pod)) {
            return false;
        }
        if (!Objects.equals((Object)this.entityOperatorRole, (Object)that.entityOperatorRole)) {
            return false;
        }
        if (!Objects.equals((Object)this.topicOperatorRoleBinding, (Object)that.topicOperatorRoleBinding)) {
            return false;
        }
        if (!Objects.equals((Object)this.userOperatorRoleBinding, (Object)that.userOperatorRoleBinding)) {
            return false;
        }
        if (!Objects.equals((Object)this.topicOperatorContainer, (Object)that.topicOperatorContainer)) {
            return false;
        }
        if (!Objects.equals((Object)this.userOperatorContainer, (Object)that.userOperatorContainer)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsSidecarContainer, (Object)that.tlsSidecarContainer)) {
            return false;
        }
        return Objects.equals((Object)this.serviceAccount, (Object)that.serviceAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deployment, this.pod, this.entityOperatorRole, this.topicOperatorRoleBinding, this.userOperatorRoleBinding, this.topicOperatorContainer, this.userOperatorContainer, this.tlsSidecarContainer, this.serviceAccount, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deployment != null) {
            sb.append("deployment:");
            sb.append(this.deployment + ",");
        }
        if (this.pod != null) {
            sb.append("pod:");
            sb.append(this.pod + ",");
        }
        if (this.entityOperatorRole != null) {
            sb.append("entityOperatorRole:");
            sb.append(this.entityOperatorRole + ",");
        }
        if (this.topicOperatorRoleBinding != null) {
            sb.append("topicOperatorRoleBinding:");
            sb.append(this.topicOperatorRoleBinding + ",");
        }
        if (this.userOperatorRoleBinding != null) {
            sb.append("userOperatorRoleBinding:");
            sb.append(this.userOperatorRoleBinding + ",");
        }
        if (this.topicOperatorContainer != null) {
            sb.append("topicOperatorContainer:");
            sb.append(this.topicOperatorContainer + ",");
        }
        if (this.userOperatorContainer != null) {
            sb.append("userOperatorContainer:");
            sb.append(this.userOperatorContainer + ",");
        }
        if (this.tlsSidecarContainer != null) {
            sb.append("tlsSidecarContainer:");
            sb.append(this.tlsSidecarContainer + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append((Object)this.serviceAccount);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DeploymentNested<N>
    extends DeploymentTemplateFluent<DeploymentNested<N>>
    implements Nested<N> {
        DeploymentTemplateBuilder builder;

        DeploymentNested(DeploymentTemplate item) {
            this.builder = new DeploymentTemplateBuilder(this, item);
        }

        public N and() {
            return (N)EntityOperatorTemplateFluent.this.withDeployment(this.builder.build());
        }

        public N endDeployment() {
            return this.and();
        }
    }

    public class PodNested<N>
    extends PodTemplateFluent<PodNested<N>>
    implements Nested<N> {
        PodTemplateBuilder builder;

        PodNested(PodTemplate item) {
            this.builder = new PodTemplateBuilder(this, item);
        }

        public N and() {
            return (N)EntityOperatorTemplateFluent.this.withPod(this.builder.build());
        }

        public N endPod() {
            return this.and();
        }
    }

    public class EntityOperatorRoleNested<N>
    extends ResourceTemplateFluent<EntityOperatorRoleNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        EntityOperatorRoleNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)EntityOperatorTemplateFluent.this.withEntityOperatorRole(this.builder.build());
        }

        public N endEntityOperatorRole() {
            return this.and();
        }
    }

    public class TopicOperatorRoleBindingNested<N>
    extends ResourceTemplateFluent<TopicOperatorRoleBindingNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        TopicOperatorRoleBindingNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)EntityOperatorTemplateFluent.this.withTopicOperatorRoleBinding(this.builder.build());
        }

        public N endTopicOperatorRoleBinding() {
            return this.and();
        }
    }

    public class UserOperatorRoleBindingNested<N>
    extends ResourceTemplateFluent<UserOperatorRoleBindingNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        UserOperatorRoleBindingNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)EntityOperatorTemplateFluent.this.withUserOperatorRoleBinding(this.builder.build());
        }

        public N endUserOperatorRoleBinding() {
            return this.and();
        }
    }

    public class TopicOperatorContainerNested<N>
    extends ContainerTemplateFluent<TopicOperatorContainerNested<N>>
    implements Nested<N> {
        ContainerTemplateBuilder builder;

        TopicOperatorContainerNested(ContainerTemplate item) {
            this.builder = new ContainerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)EntityOperatorTemplateFluent.this.withTopicOperatorContainer(this.builder.build());
        }

        public N endTopicOperatorContainer() {
            return this.and();
        }
    }

    public class UserOperatorContainerNested<N>
    extends ContainerTemplateFluent<UserOperatorContainerNested<N>>
    implements Nested<N> {
        ContainerTemplateBuilder builder;

        UserOperatorContainerNested(ContainerTemplate item) {
            this.builder = new ContainerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)EntityOperatorTemplateFluent.this.withUserOperatorContainer(this.builder.build());
        }

        public N endUserOperatorContainer() {
            return this.and();
        }
    }

    public class TlsSidecarContainerNested<N>
    extends ContainerTemplateFluent<TlsSidecarContainerNested<N>>
    implements Nested<N> {
        ContainerTemplateBuilder builder;

        TlsSidecarContainerNested(ContainerTemplate item) {
            this.builder = new ContainerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)EntityOperatorTemplateFluent.this.withTlsSidecarContainer(this.builder.build());
        }

        public N endTlsSidecarContainer() {
            return this.and();
        }
    }

    public class ServiceAccountNested<N>
    extends ResourceTemplateFluent<ServiceAccountNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        ServiceAccountNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)EntityOperatorTemplateFluent.this.withServiceAccount(this.builder.build());
        }

        public N endServiceAccount() {
            return this.and();
        }
    }
}

