/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.listener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.common.CertSecretSource;
import io.strimzi.api.kafka.model.common.GenericSecretSource;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerAuthentication;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.strimzi.crdgenerator.annotations.PresentInVersions;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "clientId", "clientSecret", "validIssuerUri", "checkIssuer", "checkAudience", "jwksEndpointUri", "jwksRefreshSeconds", "jwksMinRefreshPauseSeconds", "jwksExpirySeconds", "jwksIgnoreKeyUse", "introspectionEndpointUri", "userNameClaim", "fallbackUserNameClaim", "fallbackUserNamePrefix", "groupsClaim", "groupsClaimDelimiter", "userInfoEndpointUri", "checkAccessTokenType", "validTokenType", "accessTokenIsJwt", "tlsTrustedCertificates", "disableTlsHostnameVerification", "enableECDSA", "maxSecondsWithoutReauthentication", "enablePlain", "tokenEndpointUri", "enableOauthBearer", "customClaimCheck", "connectTimeoutSeconds", "readTimeoutSeconds", "httpRetries", "httpRetryPauseMs", "clientScope", "clientAudience", "enableMetrics", "failFast", "includeAcceptHeader", "serverBearerTokenLocation", "userNamePrefix"})
public class KafkaListenerAuthenticationOAuth
extends KafkaListenerAuthentication {
    public static final String TYPE_OAUTH = "oauth";
    public static final int DEFAULT_JWKS_EXPIRY_SECONDS = 360;
    public static final int DEFAULT_JWKS_REFRESH_SECONDS = 300;
    public static final String PRINCIPAL_BUILDER_CLASS_NAME = "io.strimzi.kafka.oauth.server.OAuthKafkaPrincipalBuilder";
    private String clientId;
    private GenericSecretSource clientSecret;
    private String validIssuerUri;
    private boolean checkIssuer = true;
    private boolean checkAudience = false;
    private String jwksEndpointUri;
    private Integer jwksRefreshSeconds;
    private Integer jwksMinRefreshPauseSeconds;
    private Integer jwksExpirySeconds;
    private boolean jwksIgnoreKeyUse = false;
    private String introspectionEndpointUri;
    private String serverBearerTokenLocation;
    private String userNameClaim;
    private String userNamePrefix;
    private String fallbackUserNameClaim;
    private String fallbackUserNamePrefix;
    private String groupsClaim;
    private String groupsClaimDelimiter;
    private String userInfoEndpointUri;
    private boolean checkAccessTokenType = true;
    private String validTokenType;
    private boolean accessTokenIsJwt = true;
    private List<CertSecretSource> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification = false;
    private Boolean enableECDSA;
    private Integer maxSecondsWithoutReauthentication;
    private boolean enablePlain = false;
    private String tokenEndpointUri;
    private boolean enableOauthBearer = true;
    private String customClaimCheck;
    private Integer connectTimeoutSeconds;
    private Integer readTimeoutSeconds;
    private Integer httpRetries;
    private Integer httpRetryPauseMs;
    private String clientScope = null;
    private String clientAudience = null;
    private boolean enableMetrics = false;
    private boolean failFast = true;
    private boolean includeAcceptHeader = true;

    @Override
    @Description(value="Must be `oauth`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return TYPE_OAUTH;
    }

    @Description(value="OAuth Client ID which the Kafka broker can use to authenticate against the authorization server and use the introspect endpoint URI.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Description(value="Link to Kubernetes Secret containing the OAuth client secret which the Kafka broker can use to authenticate against the authorization server and use the introspect endpoint URI.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GenericSecretSource getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(GenericSecretSource clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Description(value="URI of the token issuer used for authentication.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getValidIssuerUri() {
        return this.validIssuerUri;
    }

    public void setValidIssuerUri(String validIssuerUri) {
        this.validIssuerUri = validIssuerUri;
    }

    @Description(value="Enable or disable issuer checking. By default issuer is checked using the value configured by `validIssuerUri`. Default value is `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isCheckIssuer() {
        return this.checkIssuer;
    }

    public void setCheckIssuer(boolean checkIssuer) {
        this.checkIssuer = checkIssuer;
    }

    @Description(value="Enable or disable audience checking. Audience checks identify the recipients of tokens. If audience checking is enabled, the OAuth Client ID also has to be configured using the `clientId` property. The Kafka broker will reject tokens that do not have its `clientId` in their `aud` (audience) claim.Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isCheckAudience() {
        return this.checkAudience;
    }

    public void setCheckAudience(boolean checkAudience) {
        this.checkAudience = checkAudience;
    }

    @Description(value="JsonPath filter query to be applied to the JWT token or to the response of the introspection endpoint for additional token validation. Not set by default.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomClaimCheck() {
        return this.customClaimCheck;
    }

    public void setCustomClaimCheck(String customClaimCheck) {
        this.customClaimCheck = customClaimCheck;
    }

    @Description(value="The connect timeout in seconds when connecting to authorization server. If not set, the effective connect timeout is 60 seconds.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public void setConnectTimeoutSeconds(Integer connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    @Description(value="The read timeout in seconds when connecting to authorization server. If not set, the effective read timeout is 60 seconds.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public void setReadTimeoutSeconds(Integer readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
    }

    @Description(value="The maximum number of retries to attempt if an initial HTTP request fails. If not set, the default is to not attempt any retries.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getHttpRetries() {
        return this.httpRetries;
    }

    public void setHttpRetries(Integer httpRetries) {
        this.httpRetries = httpRetries;
    }

    @Description(value="The pause to take before retrying a failed HTTP request. If not set, the default is to not pause at all but to immediately repeat a request.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getHttpRetryPauseMs() {
        return this.httpRetryPauseMs;
    }

    public void setHttpRetryPauseMs(Integer httpRetryPauseMs) {
        this.httpRetryPauseMs = httpRetryPauseMs;
    }

    @Description(value="The scope to use when making requests to the authorization server's token endpoint. Used for inter-broker authentication and for configuring OAuth 2.0 over PLAIN using the `clientId` and `secret` method.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientScope() {
        return this.clientScope;
    }

    public void setClientScope(String scope) {
        this.clientScope = scope;
    }

    @Description(value="The audience to use when making requests to the authorization server's token endpoint. Used for inter-broker authentication and for configuring OAuth 2.0 over PLAIN using the `clientId` and `secret` method.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientAudience() {
        return this.clientAudience;
    }

    public void setClientAudience(String audience) {
        this.clientAudience = audience;
    }

    @Description(value="URI of the JWKS certificate endpoint, which can be used for local JWT validation.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getJwksEndpointUri() {
        return this.jwksEndpointUri;
    }

    public void setJwksEndpointUri(String jwksEndpointUri) {
        this.jwksEndpointUri = jwksEndpointUri;
    }

    @Description(value="Configures how often are the JWKS certificates refreshed. The refresh interval has to be at least 60 seconds shorter then the expiry interval specified in `jwksExpirySeconds`. Defaults to 300 seconds.")
    @Minimum(value=1)
    @JsonProperty(defaultValue="300")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getJwksRefreshSeconds() {
        return this.jwksRefreshSeconds;
    }

    public void setJwksRefreshSeconds(Integer jwksRefreshSeconds) {
        this.jwksRefreshSeconds = jwksRefreshSeconds;
    }

    @Description(value="The minimum pause between two consecutive refreshes. When an unknown signing key is encountered the refresh is scheduled immediately, but will always wait for this minimum pause. Defaults to 1 second.")
    @Minimum(value=0)
    @JsonProperty(defaultValue="1")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getJwksMinRefreshPauseSeconds() {
        return this.jwksMinRefreshPauseSeconds;
    }

    public void setJwksMinRefreshPauseSeconds(Integer jwksMinRefreshPauseSeconds) {
        this.jwksMinRefreshPauseSeconds = jwksMinRefreshPauseSeconds;
    }

    @Description(value="Configures how often are the JWKS certificates considered valid. The expiry interval has to be at least 60 seconds longer then the refresh interval specified in `jwksRefreshSeconds`. Defaults to 360 seconds.")
    @Minimum(value=1)
    @JsonProperty(defaultValue="360")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getJwksExpirySeconds() {
        return this.jwksExpirySeconds;
    }

    public void setJwksExpirySeconds(Integer jwksExpirySeconds) {
        this.jwksExpirySeconds = jwksExpirySeconds;
    }

    @Description(value="Flag to ignore the 'use' attribute of `key` declarations in a JWKS endpoint response. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean getJwksIgnoreKeyUse() {
        return this.jwksIgnoreKeyUse;
    }

    public void setJwksIgnoreKeyUse(boolean jwksIgnoreKeyUse) {
        this.jwksIgnoreKeyUse = jwksIgnoreKeyUse;
    }

    @Description(value="URI of the token introspection endpoint which can be used to validate opaque non-JWT tokens.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIntrospectionEndpointUri() {
        return this.introspectionEndpointUri;
    }

    public void setIntrospectionEndpointUri(String introspectionEndpointUri) {
        this.introspectionEndpointUri = introspectionEndpointUri;
    }

    @Description(value="Path to the file on the local filesystem that contains a bearer token to be used instead of client ID and secret when authenticating to authorization server.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getServerBearerTokenLocation() {
        return this.serverBearerTokenLocation;
    }

    public void setServerBearerTokenLocation(String serverBearerTokenLocation) {
        this.serverBearerTokenLocation = serverBearerTokenLocation;
    }

    @Description(value="Name of the claim from the JWT authentication token, Introspection Endpoint response or User Info Endpoint response which will be used to extract the user id. Defaults to `sub`.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUserNameClaim() {
        return this.userNameClaim;
    }

    public void setUserNameClaim(String userNameClaim) {
        this.userNameClaim = userNameClaim;
    }

    @Description(value="The prefix to use with the value of `userNameClaim` to construct the user ID. This only takes effect if `userNameClaim` is specified and the value is present for the claim. When used in combination with `fallbackUserNameClaims`, it ensures consistent mapping of usernames and client IDs into the same user ID space and prevents name collisions.")
    public String getUserNamePrefix() {
        return this.userNamePrefix;
    }

    public void setUserNamePrefix(String userNamePrefix) {
        this.userNamePrefix = userNamePrefix;
    }

    @Description(value="The fallback username claim to be used for the user ID if the claim specified by `userNameClaim` is not present. This is useful when `client_credentials` authentication only results in the client ID being provided in another claim. It only takes effect if `userNameClaim` is set.")
    public String getFallbackUserNameClaim() {
        return this.fallbackUserNameClaim;
    }

    public void setFallbackUserNameClaim(String fallbackUserNameClaim) {
        this.fallbackUserNameClaim = fallbackUserNameClaim;
    }

    @Description(value="The prefix to use with the value of `fallbackUserNameClaim` to construct the user id. This only takes effect if `fallbackUserNameClaim` is true, and the value is present for the claim. Mapping usernames and client ids into the same user id space is useful in preventing name collisions.")
    public String getFallbackUserNamePrefix() {
        return this.fallbackUserNamePrefix;
    }

    public void setFallbackUserNamePrefix(String fallbackUserNamePrefix) {
        this.fallbackUserNamePrefix = fallbackUserNamePrefix;
    }

    @Description(value="JsonPath query used to extract groups for the user during authentication. Extracted groups can be used by a custom authorizer. By default no groups are extracted.")
    public String getGroupsClaim() {
        return this.groupsClaim;
    }

    public void setGroupsClaim(String groupsClaim) {
        this.groupsClaim = groupsClaim;
    }

    @Description(value="A delimiter used to parse groups when they are extracted as a single String value rather than a JSON array. Default value is ',' (comma).")
    public String getGroupsClaimDelimiter() {
        return this.groupsClaimDelimiter;
    }

    public void setGroupsClaimDelimiter(String groupsClaimDelimiter) {
        this.groupsClaimDelimiter = groupsClaimDelimiter;
    }

    @Description(value="Configure whether the access token type check is performed or not. This should be set to `false` if the authorization server does not include 'typ' claim in JWT token. Defaults to `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isCheckAccessTokenType() {
        return this.checkAccessTokenType;
    }

    public void setCheckAccessTokenType(boolean checkAccessTokenType) {
        this.checkAccessTokenType = checkAccessTokenType;
    }

    @Description(value="Valid value for the `token_type` attribute returned by the Introspection Endpoint. No default value, and not checked by default.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getValidTokenType() {
        return this.validTokenType;
    }

    public void setValidTokenType(String validTokenType) {
        this.validTokenType = validTokenType;
    }

    @Description(value="Configure whether the access token is treated as JWT. This must be set to `false` if the authorization server returns opaque tokens. Defaults to `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isAccessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    public void setAccessTokenIsJwt(boolean accessTokenIsJwt) {
        this.accessTokenIsJwt = accessTokenIsJwt;
    }

    @Description(value="Trusted certificates for TLS connection to the OAuth server.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CertSecretSource> getTlsTrustedCertificates() {
        return this.tlsTrustedCertificates;
    }

    public void setTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        this.tlsTrustedCertificates = tlsTrustedCertificates;
    }

    @Description(value="Enable or disable TLS hostname verification. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public void setDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification = disableTlsHostnameVerification;
    }

    @DeprecatedProperty
    @PresentInVersions(value="v1alpha1-v1beta2")
    @Deprecated
    @Description(value="Enable or disable ECDSA support by installing BouncyCastle crypto provider. ECDSA support is always enabled. The BouncyCastle libraries are no longer packaged with Strimzi. Value is ignored.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Boolean getEnableECDSA() {
        return this.enableECDSA;
    }

    public void setEnableECDSA(Boolean enableECDSA) {
        this.enableECDSA = enableECDSA;
    }

    @Description(value="URI of the User Info Endpoint to use as a fallback to obtaining the user id when the Introspection Endpoint does not return information that can be used for the user id. ")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getUserInfoEndpointUri() {
        return this.userInfoEndpointUri;
    }

    public void setUserInfoEndpointUri(String userInfoEndpointUri) {
        this.userInfoEndpointUri = userInfoEndpointUri;
    }

    @Description(value="Maximum number of seconds the authenticated session remains valid without re-authentication. This enables Apache Kafka re-authentication feature, and causes sessions to expire when the access token expires. If the access token expires before max time or if max time is reached, the client has to re-authenticate, otherwise the server will drop the connection. Not set by default - the authenticated session does not expire when the access token expires. This option only applies to SASL_OAUTHBEARER authentication mechanism (when `enableOauthBearer` is `true`).")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMaxSecondsWithoutReauthentication() {
        return this.maxSecondsWithoutReauthentication;
    }

    public void setMaxSecondsWithoutReauthentication(Integer maxSecondsWithoutReauthentication) {
        this.maxSecondsWithoutReauthentication = maxSecondsWithoutReauthentication;
    }

    @Description(value="Enable or disable OAuth authentication over SASL_OAUTHBEARER. Default value is `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isEnableOauthBearer() {
        return this.enableOauthBearer;
    }

    public void setEnableOauthBearer(boolean enableOauthBearer) {
        this.enableOauthBearer = enableOauthBearer;
    }

    @Description(value="Enable or disable OAuth authentication over SASL_PLAIN. There is no re-authentication support when this mechanism is used. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isEnablePlain() {
        return this.enablePlain;
    }

    public void setEnablePlain(boolean enablePlain) {
        this.enablePlain = enablePlain;
    }

    @Description(value="URI of the Token Endpoint to use with SASL_PLAIN mechanism when the client authenticates with `clientId` and a `secret`. If set, the client can authenticate over SASL_PLAIN by either setting `username` to `clientId`, and setting `password` to client `secret`, or by setting `username` to account username, and `password` to access token prefixed with `$accessToken:`. If this option is not set, the `password` is always interpreted as an access token (without a prefix), and `username` as the account username (a so called 'no-client-credentials' mode).")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public void setTokenEndpointUri(String tokenEndpointUri) {
        this.tokenEndpointUri = tokenEndpointUri;
    }

    @Description(value="Enable or disable OAuth metrics. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public void setEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
    }

    @Description(value="Enable or disable termination of Kafka broker processes due to potentially recoverable runtime errors during startup. Default value is `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean getFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    @Description(value="Whether the Accept header should be set in requests to the authorization servers. The default value is `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isIncludeAcceptHeader() {
        return this.includeAcceptHeader;
    }

    public void setIncludeAcceptHeader(boolean includeAcceptHeader) {
        this.includeAcceptHeader = includeAcceptHeader;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaListenerAuthenticationOAuth)) {
            return false;
        }
        KafkaListenerAuthenticationOAuth other = (KafkaListenerAuthenticationOAuth)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isCheckIssuer() != other.isCheckIssuer()) {
            return false;
        }
        if (this.isCheckAudience() != other.isCheckAudience()) {
            return false;
        }
        if (this.getJwksIgnoreKeyUse() != other.getJwksIgnoreKeyUse()) {
            return false;
        }
        if (this.isCheckAccessTokenType() != other.isCheckAccessTokenType()) {
            return false;
        }
        if (this.isAccessTokenIsJwt() != other.isAccessTokenIsJwt()) {
            return false;
        }
        if (this.isDisableTlsHostnameVerification() != other.isDisableTlsHostnameVerification()) {
            return false;
        }
        if (this.isEnablePlain() != other.isEnablePlain()) {
            return false;
        }
        if (this.isEnableOauthBearer() != other.isEnableOauthBearer()) {
            return false;
        }
        if (this.isEnableMetrics() != other.isEnableMetrics()) {
            return false;
        }
        if (this.getFailFast() != other.getFailFast()) {
            return false;
        }
        if (this.isIncludeAcceptHeader() != other.isIncludeAcceptHeader()) {
            return false;
        }
        Integer this$jwksRefreshSeconds = this.getJwksRefreshSeconds();
        Integer other$jwksRefreshSeconds = other.getJwksRefreshSeconds();
        if (this$jwksRefreshSeconds == null ? other$jwksRefreshSeconds != null : !((Object)this$jwksRefreshSeconds).equals(other$jwksRefreshSeconds)) {
            return false;
        }
        Integer this$jwksMinRefreshPauseSeconds = this.getJwksMinRefreshPauseSeconds();
        Integer other$jwksMinRefreshPauseSeconds = other.getJwksMinRefreshPauseSeconds();
        if (this$jwksMinRefreshPauseSeconds == null ? other$jwksMinRefreshPauseSeconds != null : !((Object)this$jwksMinRefreshPauseSeconds).equals(other$jwksMinRefreshPauseSeconds)) {
            return false;
        }
        Integer this$jwksExpirySeconds = this.getJwksExpirySeconds();
        Integer other$jwksExpirySeconds = other.getJwksExpirySeconds();
        if (this$jwksExpirySeconds == null ? other$jwksExpirySeconds != null : !((Object)this$jwksExpirySeconds).equals(other$jwksExpirySeconds)) {
            return false;
        }
        Boolean this$enableECDSA = this.getEnableECDSA();
        Boolean other$enableECDSA = other.getEnableECDSA();
        if (this$enableECDSA == null ? other$enableECDSA != null : !((Object)this$enableECDSA).equals(other$enableECDSA)) {
            return false;
        }
        Integer this$maxSecondsWithoutReauthentication = this.getMaxSecondsWithoutReauthentication();
        Integer other$maxSecondsWithoutReauthentication = other.getMaxSecondsWithoutReauthentication();
        if (this$maxSecondsWithoutReauthentication == null ? other$maxSecondsWithoutReauthentication != null : !((Object)this$maxSecondsWithoutReauthentication).equals(other$maxSecondsWithoutReauthentication)) {
            return false;
        }
        Integer this$connectTimeoutSeconds = this.getConnectTimeoutSeconds();
        Integer other$connectTimeoutSeconds = other.getConnectTimeoutSeconds();
        if (this$connectTimeoutSeconds == null ? other$connectTimeoutSeconds != null : !((Object)this$connectTimeoutSeconds).equals(other$connectTimeoutSeconds)) {
            return false;
        }
        Integer this$readTimeoutSeconds = this.getReadTimeoutSeconds();
        Integer other$readTimeoutSeconds = other.getReadTimeoutSeconds();
        if (this$readTimeoutSeconds == null ? other$readTimeoutSeconds != null : !((Object)this$readTimeoutSeconds).equals(other$readTimeoutSeconds)) {
            return false;
        }
        Integer this$httpRetries = this.getHttpRetries();
        Integer other$httpRetries = other.getHttpRetries();
        if (this$httpRetries == null ? other$httpRetries != null : !((Object)this$httpRetries).equals(other$httpRetries)) {
            return false;
        }
        Integer this$httpRetryPauseMs = this.getHttpRetryPauseMs();
        Integer other$httpRetryPauseMs = other.getHttpRetryPauseMs();
        if (this$httpRetryPauseMs == null ? other$httpRetryPauseMs != null : !((Object)this$httpRetryPauseMs).equals(other$httpRetryPauseMs)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        GenericSecretSource this$clientSecret = this.getClientSecret();
        GenericSecretSource other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !((Object)this$clientSecret).equals(other$clientSecret)) {
            return false;
        }
        String this$validIssuerUri = this.getValidIssuerUri();
        String other$validIssuerUri = other.getValidIssuerUri();
        if (this$validIssuerUri == null ? other$validIssuerUri != null : !this$validIssuerUri.equals(other$validIssuerUri)) {
            return false;
        }
        String this$jwksEndpointUri = this.getJwksEndpointUri();
        String other$jwksEndpointUri = other.getJwksEndpointUri();
        if (this$jwksEndpointUri == null ? other$jwksEndpointUri != null : !this$jwksEndpointUri.equals(other$jwksEndpointUri)) {
            return false;
        }
        String this$introspectionEndpointUri = this.getIntrospectionEndpointUri();
        String other$introspectionEndpointUri = other.getIntrospectionEndpointUri();
        if (this$introspectionEndpointUri == null ? other$introspectionEndpointUri != null : !this$introspectionEndpointUri.equals(other$introspectionEndpointUri)) {
            return false;
        }
        String this$serverBearerTokenLocation = this.getServerBearerTokenLocation();
        String other$serverBearerTokenLocation = other.getServerBearerTokenLocation();
        if (this$serverBearerTokenLocation == null ? other$serverBearerTokenLocation != null : !this$serverBearerTokenLocation.equals(other$serverBearerTokenLocation)) {
            return false;
        }
        String this$userNameClaim = this.getUserNameClaim();
        String other$userNameClaim = other.getUserNameClaim();
        if (this$userNameClaim == null ? other$userNameClaim != null : !this$userNameClaim.equals(other$userNameClaim)) {
            return false;
        }
        String this$userNamePrefix = this.getUserNamePrefix();
        String other$userNamePrefix = other.getUserNamePrefix();
        if (this$userNamePrefix == null ? other$userNamePrefix != null : !this$userNamePrefix.equals(other$userNamePrefix)) {
            return false;
        }
        String this$fallbackUserNameClaim = this.getFallbackUserNameClaim();
        String other$fallbackUserNameClaim = other.getFallbackUserNameClaim();
        if (this$fallbackUserNameClaim == null ? other$fallbackUserNameClaim != null : !this$fallbackUserNameClaim.equals(other$fallbackUserNameClaim)) {
            return false;
        }
        String this$fallbackUserNamePrefix = this.getFallbackUserNamePrefix();
        String other$fallbackUserNamePrefix = other.getFallbackUserNamePrefix();
        if (this$fallbackUserNamePrefix == null ? other$fallbackUserNamePrefix != null : !this$fallbackUserNamePrefix.equals(other$fallbackUserNamePrefix)) {
            return false;
        }
        String this$groupsClaim = this.getGroupsClaim();
        String other$groupsClaim = other.getGroupsClaim();
        if (this$groupsClaim == null ? other$groupsClaim != null : !this$groupsClaim.equals(other$groupsClaim)) {
            return false;
        }
        String this$groupsClaimDelimiter = this.getGroupsClaimDelimiter();
        String other$groupsClaimDelimiter = other.getGroupsClaimDelimiter();
        if (this$groupsClaimDelimiter == null ? other$groupsClaimDelimiter != null : !this$groupsClaimDelimiter.equals(other$groupsClaimDelimiter)) {
            return false;
        }
        String this$userInfoEndpointUri = this.getUserInfoEndpointUri();
        String other$userInfoEndpointUri = other.getUserInfoEndpointUri();
        if (this$userInfoEndpointUri == null ? other$userInfoEndpointUri != null : !this$userInfoEndpointUri.equals(other$userInfoEndpointUri)) {
            return false;
        }
        String this$validTokenType = this.getValidTokenType();
        String other$validTokenType = other.getValidTokenType();
        if (this$validTokenType == null ? other$validTokenType != null : !this$validTokenType.equals(other$validTokenType)) {
            return false;
        }
        List<CertSecretSource> this$tlsTrustedCertificates = this.getTlsTrustedCertificates();
        List<CertSecretSource> other$tlsTrustedCertificates = other.getTlsTrustedCertificates();
        if (this$tlsTrustedCertificates == null ? other$tlsTrustedCertificates != null : !((Object)this$tlsTrustedCertificates).equals(other$tlsTrustedCertificates)) {
            return false;
        }
        String this$tokenEndpointUri = this.getTokenEndpointUri();
        String other$tokenEndpointUri = other.getTokenEndpointUri();
        if (this$tokenEndpointUri == null ? other$tokenEndpointUri != null : !this$tokenEndpointUri.equals(other$tokenEndpointUri)) {
            return false;
        }
        String this$customClaimCheck = this.getCustomClaimCheck();
        String other$customClaimCheck = other.getCustomClaimCheck();
        if (this$customClaimCheck == null ? other$customClaimCheck != null : !this$customClaimCheck.equals(other$customClaimCheck)) {
            return false;
        }
        String this$clientScope = this.getClientScope();
        String other$clientScope = other.getClientScope();
        if (this$clientScope == null ? other$clientScope != null : !this$clientScope.equals(other$clientScope)) {
            return false;
        }
        String this$clientAudience = this.getClientAudience();
        String other$clientAudience = other.getClientAudience();
        return !(this$clientAudience == null ? other$clientAudience != null : !this$clientAudience.equals(other$clientAudience));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaListenerAuthenticationOAuth;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isCheckIssuer() ? 79 : 97);
        result = result * 59 + (this.isCheckAudience() ? 79 : 97);
        result = result * 59 + (this.getJwksIgnoreKeyUse() ? 79 : 97);
        result = result * 59 + (this.isCheckAccessTokenType() ? 79 : 97);
        result = result * 59 + (this.isAccessTokenIsJwt() ? 79 : 97);
        result = result * 59 + (this.isDisableTlsHostnameVerification() ? 79 : 97);
        result = result * 59 + (this.isEnablePlain() ? 79 : 97);
        result = result * 59 + (this.isEnableOauthBearer() ? 79 : 97);
        result = result * 59 + (this.isEnableMetrics() ? 79 : 97);
        result = result * 59 + (this.getFailFast() ? 79 : 97);
        result = result * 59 + (this.isIncludeAcceptHeader() ? 79 : 97);
        Integer $jwksRefreshSeconds = this.getJwksRefreshSeconds();
        result = result * 59 + ($jwksRefreshSeconds == null ? 43 : ((Object)$jwksRefreshSeconds).hashCode());
        Integer $jwksMinRefreshPauseSeconds = this.getJwksMinRefreshPauseSeconds();
        result = result * 59 + ($jwksMinRefreshPauseSeconds == null ? 43 : ((Object)$jwksMinRefreshPauseSeconds).hashCode());
        Integer $jwksExpirySeconds = this.getJwksExpirySeconds();
        result = result * 59 + ($jwksExpirySeconds == null ? 43 : ((Object)$jwksExpirySeconds).hashCode());
        Boolean $enableECDSA = this.getEnableECDSA();
        result = result * 59 + ($enableECDSA == null ? 43 : ((Object)$enableECDSA).hashCode());
        Integer $maxSecondsWithoutReauthentication = this.getMaxSecondsWithoutReauthentication();
        result = result * 59 + ($maxSecondsWithoutReauthentication == null ? 43 : ((Object)$maxSecondsWithoutReauthentication).hashCode());
        Integer $connectTimeoutSeconds = this.getConnectTimeoutSeconds();
        result = result * 59 + ($connectTimeoutSeconds == null ? 43 : ((Object)$connectTimeoutSeconds).hashCode());
        Integer $readTimeoutSeconds = this.getReadTimeoutSeconds();
        result = result * 59 + ($readTimeoutSeconds == null ? 43 : ((Object)$readTimeoutSeconds).hashCode());
        Integer $httpRetries = this.getHttpRetries();
        result = result * 59 + ($httpRetries == null ? 43 : ((Object)$httpRetries).hashCode());
        Integer $httpRetryPauseMs = this.getHttpRetryPauseMs();
        result = result * 59 + ($httpRetryPauseMs == null ? 43 : ((Object)$httpRetryPauseMs).hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        GenericSecretSource $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : ((Object)$clientSecret).hashCode());
        String $validIssuerUri = this.getValidIssuerUri();
        result = result * 59 + ($validIssuerUri == null ? 43 : $validIssuerUri.hashCode());
        String $jwksEndpointUri = this.getJwksEndpointUri();
        result = result * 59 + ($jwksEndpointUri == null ? 43 : $jwksEndpointUri.hashCode());
        String $introspectionEndpointUri = this.getIntrospectionEndpointUri();
        result = result * 59 + ($introspectionEndpointUri == null ? 43 : $introspectionEndpointUri.hashCode());
        String $serverBearerTokenLocation = this.getServerBearerTokenLocation();
        result = result * 59 + ($serverBearerTokenLocation == null ? 43 : $serverBearerTokenLocation.hashCode());
        String $userNameClaim = this.getUserNameClaim();
        result = result * 59 + ($userNameClaim == null ? 43 : $userNameClaim.hashCode());
        String $userNamePrefix = this.getUserNamePrefix();
        result = result * 59 + ($userNamePrefix == null ? 43 : $userNamePrefix.hashCode());
        String $fallbackUserNameClaim = this.getFallbackUserNameClaim();
        result = result * 59 + ($fallbackUserNameClaim == null ? 43 : $fallbackUserNameClaim.hashCode());
        String $fallbackUserNamePrefix = this.getFallbackUserNamePrefix();
        result = result * 59 + ($fallbackUserNamePrefix == null ? 43 : $fallbackUserNamePrefix.hashCode());
        String $groupsClaim = this.getGroupsClaim();
        result = result * 59 + ($groupsClaim == null ? 43 : $groupsClaim.hashCode());
        String $groupsClaimDelimiter = this.getGroupsClaimDelimiter();
        result = result * 59 + ($groupsClaimDelimiter == null ? 43 : $groupsClaimDelimiter.hashCode());
        String $userInfoEndpointUri = this.getUserInfoEndpointUri();
        result = result * 59 + ($userInfoEndpointUri == null ? 43 : $userInfoEndpointUri.hashCode());
        String $validTokenType = this.getValidTokenType();
        result = result * 59 + ($validTokenType == null ? 43 : $validTokenType.hashCode());
        List<CertSecretSource> $tlsTrustedCertificates = this.getTlsTrustedCertificates();
        result = result * 59 + ($tlsTrustedCertificates == null ? 43 : ((Object)$tlsTrustedCertificates).hashCode());
        String $tokenEndpointUri = this.getTokenEndpointUri();
        result = result * 59 + ($tokenEndpointUri == null ? 43 : $tokenEndpointUri.hashCode());
        String $customClaimCheck = this.getCustomClaimCheck();
        result = result * 59 + ($customClaimCheck == null ? 43 : $customClaimCheck.hashCode());
        String $clientScope = this.getClientScope();
        result = result * 59 + ($clientScope == null ? 43 : $clientScope.hashCode());
        String $clientAudience = this.getClientAudience();
        result = result * 59 + ($clientAudience == null ? 43 : $clientAudience.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaListenerAuthenticationOAuth(super=" + super.toString() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", validIssuerUri=" + this.getValidIssuerUri() + ", checkIssuer=" + this.isCheckIssuer() + ", checkAudience=" + this.isCheckAudience() + ", jwksEndpointUri=" + this.getJwksEndpointUri() + ", jwksRefreshSeconds=" + this.getJwksRefreshSeconds() + ", jwksMinRefreshPauseSeconds=" + this.getJwksMinRefreshPauseSeconds() + ", jwksExpirySeconds=" + this.getJwksExpirySeconds() + ", jwksIgnoreKeyUse=" + this.getJwksIgnoreKeyUse() + ", introspectionEndpointUri=" + this.getIntrospectionEndpointUri() + ", serverBearerTokenLocation=" + this.getServerBearerTokenLocation() + ", userNameClaim=" + this.getUserNameClaim() + ", userNamePrefix=" + this.getUserNamePrefix() + ", fallbackUserNameClaim=" + this.getFallbackUserNameClaim() + ", fallbackUserNamePrefix=" + this.getFallbackUserNamePrefix() + ", groupsClaim=" + this.getGroupsClaim() + ", groupsClaimDelimiter=" + this.getGroupsClaimDelimiter() + ", userInfoEndpointUri=" + this.getUserInfoEndpointUri() + ", checkAccessTokenType=" + this.isCheckAccessTokenType() + ", validTokenType=" + this.getValidTokenType() + ", accessTokenIsJwt=" + this.isAccessTokenIsJwt() + ", tlsTrustedCertificates=" + this.getTlsTrustedCertificates() + ", disableTlsHostnameVerification=" + this.isDisableTlsHostnameVerification() + ", enableECDSA=" + this.getEnableECDSA() + ", maxSecondsWithoutReauthentication=" + this.getMaxSecondsWithoutReauthentication() + ", enablePlain=" + this.isEnablePlain() + ", tokenEndpointUri=" + this.getTokenEndpointUri() + ", enableOauthBearer=" + this.isEnableOauthBearer() + ", customClaimCheck=" + this.getCustomClaimCheck() + ", connectTimeoutSeconds=" + this.getConnectTimeoutSeconds() + ", readTimeoutSeconds=" + this.getReadTimeoutSeconds() + ", httpRetries=" + this.getHttpRetries() + ", httpRetryPauseMs=" + this.getHttpRetryPauseMs() + ", clientScope=" + this.getClientScope() + ", clientAudience=" + this.getClientAudience() + ", enableMetrics=" + this.isEnableMetrics() + ", failFast=" + this.getFailFast() + ", includeAcceptHeader=" + this.isIncludeAcceptHeader() + ")";
    }
}

