/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.kafka.listener.ListenerAddress;
import io.strimzi.api.kafka.model.kafka.listener.ListenerAddressBuilder;
import io.strimzi.api.kafka.model.kafka.listener.ListenerAddressFluent;
import io.strimzi.api.kafka.model.kafka.listener.ListenerStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ListenerStatusFluent<A extends ListenerStatusFluent<A>>
extends BaseFluent<A> {
    private String type;
    private String name;
    private ArrayList<ListenerAddressBuilder> addresses;
    private List<String> certificates;

    public ListenerStatusFluent() {
    }

    public ListenerStatusFluent(ListenerStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ListenerStatus instance) {
        ListenerStatus listenerStatus = instance = instance != null ? instance : new ListenerStatus();
        if (instance != null) {
            this.withType(instance.getType());
            this.withName(instance.getName());
            this.withAddresses(instance.getAddresses());
            this.withCertificates(instance.getCertificates());
        }
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToAddresses(int index, ListenerAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(index, builder);
            this.addresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAddresses(int index, ListenerAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").set(index, builder);
            this.addresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(ListenerAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (ListenerAddress item : items) {
            ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAddresses(Collection<ListenerAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (ListenerAddress item : items) {
            ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(ListenerAddress ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (ListenerAddress item : items) {
            ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAddresses(Collection<ListenerAddress> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (ListenerAddress item : items) {
            ListenerAddressBuilder builder = new ListenerAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddresses(Predicate<ListenerAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        Iterator<ListenerAddressBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            ListenerAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ListenerAddress> buildAddresses() {
        return this.addresses != null ? ListenerStatusFluent.build(this.addresses) : null;
    }

    public ListenerAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public ListenerAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public ListenerAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public ListenerAddress buildMatchingAddress(Predicate<ListenerAddressBuilder> predicate) {
        for (ListenerAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<ListenerAddressBuilder> predicate) {
        for (ListenerAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<ListenerAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (ListenerAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(ListenerAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (ListenerAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public AddressesNested<A> addNewAddressLike(ListenerAddress item) {
        return new AddressesNested(-1, item);
    }

    public AddressesNested<A> setNewAddressLike(int index, ListenerAddress item) {
        return new AddressesNested(index, item);
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<ListenerAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public A addToCertificates(int index, String item) {
        if (this.certificates == null) {
            this.certificates = new ArrayList<String>();
        }
        this.certificates.add(index, item);
        return (A)((Object)this);
    }

    public A setToCertificates(int index, String item) {
        if (this.certificates == null) {
            this.certificates = new ArrayList<String>();
        }
        this.certificates.set(index, item);
        return (A)((Object)this);
    }

    public A addToCertificates(String ... items) {
        if (this.certificates == null) {
            this.certificates = new ArrayList<String>();
        }
        for (String item : items) {
            this.certificates.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCertificates(Collection<String> items) {
        if (this.certificates == null) {
            this.certificates = new ArrayList<String>();
        }
        for (String item : items) {
            this.certificates.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCertificates(String ... items) {
        if (this.certificates == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.certificates.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCertificates(Collection<String> items) {
        if (this.certificates == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.certificates.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCertificates() {
        return this.certificates;
    }

    public String getCertificate(int index) {
        return this.certificates.get(index);
    }

    public String getFirstCertificate() {
        return this.certificates.get(0);
    }

    public String getLastCertificate() {
        return this.certificates.get(this.certificates.size() - 1);
    }

    public String getMatchingCertificate(Predicate<String> predicate) {
        for (String item : this.certificates) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCertificate(Predicate<String> predicate) {
        for (String item : this.certificates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCertificates(List<String> certificates) {
        if (certificates != null) {
            this.certificates = new ArrayList<String>();
            for (String item : certificates) {
                this.addToCertificates(item);
            }
        } else {
            this.certificates = null;
        }
        return (A)((Object)this);
    }

    public A withCertificates(String ... certificates) {
        if (this.certificates != null) {
            this.certificates.clear();
            this._visitables.remove((Object)"certificates");
        }
        if (certificates != null) {
            for (String item : certificates) {
                this.addToCertificates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCertificates() {
        return this.certificates != null && !this.certificates.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListenerStatusFluent that = (ListenerStatusFluent)((Object)o);
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        return Objects.equals(this.certificates, that.certificates);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.addresses, this.certificates, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.certificates != null && !this.certificates.isEmpty()) {
            sb.append("certificates:");
            sb.append(this.certificates);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AddressesNested<N>
    extends ListenerAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        ListenerAddressBuilder builder;
        int index;

        AddressesNested(int index, ListenerAddress item) {
            this.index = index;
            this.builder = new ListenerAddressBuilder(this, item);
        }

        public N and() {
            return (N)ListenerStatusFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

