/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.mirrormaker2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.common.ClientTls;
import io.strimzi.api.kafka.model.common.ClientTlsBuilder;
import io.strimzi.api.kafka.model.common.ClientTlsFluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256Builder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256Fluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTlsFluent;
import io.strimzi.api.kafka.model.mirrormaker2.KafkaMirrorMaker2ClusterSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class KafkaMirrorMaker2ClusterSpecFluent<A extends KafkaMirrorMaker2ClusterSpecFluent<A>>
extends BaseFluent<A> {
    private String alias;
    private String bootstrapServers;
    private Map<String, Object> config;
    private ClientTlsBuilder tls;
    private VisitableBuilder<? extends KafkaClientAuthentication, ?> authentication;

    public KafkaMirrorMaker2ClusterSpecFluent() {
    }

    public KafkaMirrorMaker2ClusterSpecFluent(KafkaMirrorMaker2ClusterSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaMirrorMaker2ClusterSpec instance) {
        KafkaMirrorMaker2ClusterSpec kafkaMirrorMaker2ClusterSpec = instance = instance != null ? instance : new KafkaMirrorMaker2ClusterSpec();
        if (instance != null) {
            this.withAlias(instance.getAlias());
            this.withBootstrapServers(instance.getBootstrapServers());
            this.withConfig(instance.getConfig());
            this.withTls(instance.getTls());
            this.withAuthentication(instance.getAuthentication());
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public A withAlias(String alias) {
        this.alias = alias;
        return (A)((Object)this);
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public A withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return (A)((Object)this);
    }

    public boolean hasBootstrapServers() {
        return this.bootstrapServers != null;
    }

    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public <K, V> A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public ClientTls buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    public A withTls(ClientTls tls) {
        this._visitables.remove((Object)"tls");
        if (tls != null) {
            this.tls = new ClientTlsBuilder(tls);
            this._visitables.get((Object)"tls").add(this.tls);
        } else {
            this.tls = null;
            this._visitables.get((Object)"tls").remove((Object)this.tls);
        }
        return (A)((Object)this);
    }

    public boolean hasTls() {
        return this.tls != null;
    }

    public TlsNested<A> withNewTls() {
        return new TlsNested(null);
    }

    public TlsNested<A> withNewTlsLike(ClientTls item) {
        return new TlsNested(item);
    }

    public TlsNested<A> editTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(null));
    }

    public TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(new ClientTlsBuilder().build()));
    }

    public TlsNested<A> editOrNewTlsLike(ClientTls item) {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(item));
    }

    public KafkaClientAuthentication buildAuthentication() {
        return this.authentication != null ? (KafkaClientAuthentication)this.authentication.build() : null;
    }

    public A withAuthentication(KafkaClientAuthentication authentication) {
        if (authentication == null) {
            this.authentication = null;
            this._visitables.remove((Object)"authentication");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaMirrorMaker2ClusterSpecFluent.builder(authentication);
        this._visitables.get((Object)"authentication").clear();
        this._visitables.get((Object)"authentication").add(builder);
        this.authentication = builder;
        return (A)((Object)this);
    }

    public boolean hasAuthentication() {
        return this.authentication != null;
    }

    public KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512() {
        return new KafkaClientAuthenticationScramSha512Nested(null);
    }

    public KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item) {
        return new KafkaClientAuthenticationScramSha512Nested(item);
    }

    public KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls() {
        return new KafkaClientAuthenticationTlsNested(null);
    }

    public KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item) {
        return new KafkaClientAuthenticationTlsNested(item);
    }

    public KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth() {
        return new KafkaClientAuthenticationOAuthNested(null);
    }

    public KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item) {
        return new KafkaClientAuthenticationOAuthNested(item);
    }

    public KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256() {
        return new KafkaClientAuthenticationScramSha256Nested(null);
    }

    public KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256Like(KafkaClientAuthenticationScramSha256 item) {
        return new KafkaClientAuthenticationScramSha256Nested(item);
    }

    public KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain() {
        return new KafkaClientAuthenticationPlainNested(null);
    }

    public KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item) {
        return new KafkaClientAuthenticationPlainNested(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaMirrorMaker2ClusterSpecFluent that = (KafkaMirrorMaker2ClusterSpecFluent)((Object)o);
        if (!Objects.equals(this.alias, that.alias)) {
            return false;
        }
        if (!Objects.equals(this.bootstrapServers, that.bootstrapServers)) {
            return false;
        }
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals((Object)this.tls, (Object)that.tls)) {
            return false;
        }
        return Objects.equals(this.authentication, that.authentication);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alias, this.bootstrapServers, this.config, this.tls, this.authentication, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alias != null) {
            sb.append("alias:");
            sb.append(this.alias + ",");
        }
        if (this.bootstrapServers != null) {
            sb.append("bootstrapServers:");
            sb.append(this.bootstrapServers + ",");
        }
        if (this.config != null && !this.config.isEmpty()) {
            sb.append("config:");
            sb.append(this.config + ",");
        }
        if (this.tls != null) {
            sb.append("tls:");
            sb.append(this.tls + ",");
        }
        if (this.authentication != null) {
            sb.append("authentication:");
            sb.append(this.authentication);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512": {
                return new KafkaClientAuthenticationScramSha512Builder((KafkaClientAuthenticationScramSha512)item);
            }
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTls": {
                return new KafkaClientAuthenticationTlsBuilder((KafkaClientAuthenticationTls)item);
            }
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuth": {
                return new KafkaClientAuthenticationOAuthBuilder((KafkaClientAuthenticationOAuth)item);
            }
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256": {
                return new KafkaClientAuthenticationScramSha256Builder((KafkaClientAuthenticationScramSha256)item);
            }
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlain": {
                return new KafkaClientAuthenticationPlainBuilder((KafkaClientAuthenticationPlain)item);
            }
        }
        return KafkaMirrorMaker2ClusterSpecFluent.builderOf((Object)item);
    }

    public class TlsNested<N>
    extends ClientTlsFluent<TlsNested<N>>
    implements Nested<N> {
        ClientTlsBuilder builder;

        TlsNested(ClientTls item) {
            this.builder = new ClientTlsBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMaker2ClusterSpecFluent.this.withTls(this.builder.build());
        }

        public N endTls() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationScramSha512Nested<N>
    extends KafkaClientAuthenticationScramSha512Fluent<KafkaClientAuthenticationScramSha512Nested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationScramSha512Builder builder;

        KafkaClientAuthenticationScramSha512Nested(KafkaClientAuthenticationScramSha512 item) {
            this.builder = new KafkaClientAuthenticationScramSha512Builder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMaker2ClusterSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationScramSha512() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationTlsNested<N>
    extends KafkaClientAuthenticationTlsFluent<KafkaClientAuthenticationTlsNested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationTlsBuilder builder;

        KafkaClientAuthenticationTlsNested(KafkaClientAuthenticationTls item) {
            this.builder = new KafkaClientAuthenticationTlsBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMaker2ClusterSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationTls() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationOAuthNested<N>
    extends KafkaClientAuthenticationOAuthFluent<KafkaClientAuthenticationOAuthNested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationOAuthBuilder builder;

        KafkaClientAuthenticationOAuthNested(KafkaClientAuthenticationOAuth item) {
            this.builder = new KafkaClientAuthenticationOAuthBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMaker2ClusterSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationOAuth() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationScramSha256Nested<N>
    extends KafkaClientAuthenticationScramSha256Fluent<KafkaClientAuthenticationScramSha256Nested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationScramSha256Builder builder;

        KafkaClientAuthenticationScramSha256Nested(KafkaClientAuthenticationScramSha256 item) {
            this.builder = new KafkaClientAuthenticationScramSha256Builder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMaker2ClusterSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationScramSha256() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationPlainNested<N>
    extends KafkaClientAuthenticationPlainFluent<KafkaClientAuthenticationPlainNested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationPlainBuilder builder;

        KafkaClientAuthenticationPlainNested(KafkaClientAuthenticationPlain item) {
            this.builder = new KafkaClientAuthenticationPlainBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMaker2ClusterSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationPlain() {
            return this.and();
        }
    }
}

