/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.nodepool;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePool;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolSpec;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolSpecBuilder;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolSpecFluent;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolStatus;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolStatusBuilder;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolStatusFluent;
import java.util.Objects;
import java.util.Optional;

public class KafkaNodePoolFluent<A extends KafkaNodePoolFluent<A>>
extends CustomResourceFluent<KafkaNodePoolSpec, KafkaNodePoolStatus, A> {
    private String apiVersion;
    private String kind;
    private KafkaNodePoolSpecBuilder spec;
    private KafkaNodePoolStatusBuilder status;

    public KafkaNodePoolFluent() {
    }

    public KafkaNodePoolFluent(KafkaNodePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaNodePool instance) {
        KafkaNodePool kafkaNodePool = instance = instance != null ? instance : new KafkaNodePool();
        if (instance != null) {
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public KafkaNodePoolSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    public A withSpec(KafkaNodePoolSpec spec) {
        this._visitables.remove((Object)"spec");
        if (spec != null) {
            this.spec = new KafkaNodePoolSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove((Object)this.spec);
        }
        return (A)((Object)this);
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public SpecNested<A> withNewSpec() {
        return new SpecNested(null);
    }

    public SpecNested<A> withNewSpecLike(KafkaNodePoolSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<A> editSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(null));
    }

    public SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(new KafkaNodePoolSpecBuilder().build()));
    }

    public SpecNested<A> editOrNewSpecLike(KafkaNodePoolSpec item) {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(item));
    }

    public KafkaNodePoolStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    public A withStatus(KafkaNodePoolStatus status) {
        this._visitables.remove((Object)"status");
        if (status != null) {
            this.status = new KafkaNodePoolStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove((Object)this.status);
        }
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public StatusNested<A> withNewStatus() {
        return new StatusNested(null);
    }

    public StatusNested<A> withNewStatusLike(KafkaNodePoolStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<A> editStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(null));
    }

    public StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(new KafkaNodePoolStatusBuilder().build()));
    }

    public StatusNested<A> editOrNewStatusLike(KafkaNodePoolStatus item) {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaNodePoolFluent that = (KafkaNodePoolFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals((Object)this.spec, (Object)that.spec)) {
            return false;
        }
        return Objects.equals((Object)this.status, (Object)that.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.kind, this.spec, this.status, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append((Object)this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SpecNested<N>
    extends KafkaNodePoolSpecFluent<SpecNested<N>>
    implements Nested<N> {
        KafkaNodePoolSpecBuilder builder;

        SpecNested(KafkaNodePoolSpec item) {
            this.builder = new KafkaNodePoolSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class StatusNested<N>
    extends KafkaNodePoolStatusFluent<StatusNested<N>>
    implements Nested<N> {
        KafkaNodePoolStatusBuilder builder;

        StatusNested(KafkaNodePoolStatus item) {
            this.builder = new KafkaNodePoolStatusBuilder(this, item);
        }

        public N and() {
            return (N)KafkaNodePoolFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }
}

