/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.nodepool;

import io.strimzi.api.kafka.model.kafka.StatusFluent;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolStatus;
import io.strimzi.api.kafka.model.nodepool.ProcessRoles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaNodePoolStatusFluent<A extends KafkaNodePoolStatusFluent<A>>
extends StatusFluent<A> {
    private List<Integer> nodeIds;
    private String clusterId;
    private List<ProcessRoles> roles;
    private int replicas;
    private String labelSelector;

    public KafkaNodePoolStatusFluent() {
    }

    public KafkaNodePoolStatusFluent(KafkaNodePoolStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaNodePoolStatus instance) {
        KafkaNodePoolStatus kafkaNodePoolStatus = instance = instance != null ? instance : new KafkaNodePoolStatus();
        if (instance != null) {
            this.withNodeIds(instance.getNodeIds());
            this.withClusterId(instance.getClusterId());
            this.withRoles(instance.getRoles());
            this.withReplicas(instance.getReplicas());
            this.withLabelSelector(instance.getLabelSelector());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
        }
    }

    public A addToNodeIds(int index, Integer item) {
        if (this.nodeIds == null) {
            this.nodeIds = new ArrayList<Integer>();
        }
        this.nodeIds.add(index, item);
        return (A)((Object)this);
    }

    public A setToNodeIds(int index, Integer item) {
        if (this.nodeIds == null) {
            this.nodeIds = new ArrayList<Integer>();
        }
        this.nodeIds.set(index, item);
        return (A)((Object)this);
    }

    public A addToNodeIds(Integer ... items) {
        if (this.nodeIds == null) {
            this.nodeIds = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.nodeIds.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToNodeIds(Collection<Integer> items) {
        if (this.nodeIds == null) {
            this.nodeIds = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.nodeIds.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeIds(Integer ... items) {
        if (this.nodeIds == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.nodeIds.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNodeIds(Collection<Integer> items) {
        if (this.nodeIds == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.nodeIds.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Integer> getNodeIds() {
        return this.nodeIds;
    }

    public Integer getNodeId(int index) {
        return this.nodeIds.get(index);
    }

    public Integer getFirstNodeId() {
        return this.nodeIds.get(0);
    }

    public Integer getLastNodeId() {
        return this.nodeIds.get(this.nodeIds.size() - 1);
    }

    public Integer getMatchingNodeId(Predicate<Integer> predicate) {
        for (Integer item : this.nodeIds) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNodeId(Predicate<Integer> predicate) {
        for (Integer item : this.nodeIds) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNodeIds(List<Integer> nodeIds) {
        if (nodeIds != null) {
            this.nodeIds = new ArrayList<Integer>();
            for (Integer item : nodeIds) {
                this.addToNodeIds(item);
            }
        } else {
            this.nodeIds = null;
        }
        return (A)((Object)this);
    }

    public A withNodeIds(Integer ... nodeIds) {
        if (this.nodeIds != null) {
            this.nodeIds.clear();
            this._visitables.remove((Object)"nodeIds");
        }
        if (nodeIds != null) {
            for (Integer item : nodeIds) {
                this.addToNodeIds(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasNodeIds() {
        return this.nodeIds != null && !this.nodeIds.isEmpty();
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public A withClusterId(String clusterId) {
        this.clusterId = clusterId;
        return (A)((Object)this);
    }

    public boolean hasClusterId() {
        return this.clusterId != null;
    }

    public A addToRoles(int index, ProcessRoles item) {
        if (this.roles == null) {
            this.roles = new ArrayList<ProcessRoles>();
        }
        this.roles.add(index, item);
        return (A)((Object)this);
    }

    public A setToRoles(int index, ProcessRoles item) {
        if (this.roles == null) {
            this.roles = new ArrayList<ProcessRoles>();
        }
        this.roles.set(index, item);
        return (A)((Object)this);
    }

    public A addToRoles(ProcessRoles ... items) {
        if (this.roles == null) {
            this.roles = new ArrayList<ProcessRoles>();
        }
        for (ProcessRoles item : items) {
            this.roles.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToRoles(Collection<ProcessRoles> items) {
        if (this.roles == null) {
            this.roles = new ArrayList<ProcessRoles>();
        }
        for (ProcessRoles item : items) {
            this.roles.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromRoles(ProcessRoles ... items) {
        if (this.roles == null) {
            return (A)((Object)this);
        }
        for (ProcessRoles item : items) {
            this.roles.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRoles(Collection<ProcessRoles> items) {
        if (this.roles == null) {
            return (A)((Object)this);
        }
        for (ProcessRoles item : items) {
            this.roles.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public List<ProcessRoles> getRoles() {
        return this.roles;
    }

    public ProcessRoles getRole(int index) {
        return this.roles.get(index);
    }

    public ProcessRoles getFirstRole() {
        return this.roles.get(0);
    }

    public ProcessRoles getLastRole() {
        return this.roles.get(this.roles.size() - 1);
    }

    public ProcessRoles getMatchingRole(Predicate<ProcessRoles> predicate) {
        for (ProcessRoles item : this.roles) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRole(Predicate<ProcessRoles> predicate) {
        for (ProcessRoles item : this.roles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRoles(List<ProcessRoles> roles) {
        if (roles != null) {
            this.roles = new ArrayList<ProcessRoles>();
            for (ProcessRoles item : roles) {
                this.addToRoles(item);
            }
        } else {
            this.roles = null;
        }
        return (A)((Object)this);
    }

    public A withRoles(ProcessRoles ... roles) {
        if (this.roles != null) {
            this.roles.clear();
            this._visitables.remove((Object)"roles");
        }
        if (roles != null) {
            for (ProcessRoles item : roles) {
                this.addToRoles(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRoles() {
        return this.roles != null && !this.roles.isEmpty();
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return true;
    }

    public String getLabelSelector() {
        return this.labelSelector;
    }

    public A withLabelSelector(String labelSelector) {
        this.labelSelector = labelSelector;
        return (A)((Object)this);
    }

    public boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaNodePoolStatusFluent that = (KafkaNodePoolStatusFluent)((Object)o);
        if (!Objects.equals(this.nodeIds, that.nodeIds)) {
            return false;
        }
        if (!Objects.equals(this.clusterId, that.clusterId)) {
            return false;
        }
        if (!Objects.equals(this.roles, that.roles)) {
            return false;
        }
        if (this.replicas != that.replicas) {
            return false;
        }
        return Objects.equals(this.labelSelector, that.labelSelector);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nodeIds, this.clusterId, this.roles, this.replicas, this.labelSelector, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nodeIds != null && !this.nodeIds.isEmpty()) {
            sb.append("nodeIds:");
            sb.append(this.nodeIds + ",");
        }
        if (this.clusterId != null) {
            sb.append("clusterId:");
            sb.append(this.clusterId + ",");
        }
        if (this.roles != null && !this.roles.isEmpty()) {
            sb.append("roles:");
            sb.append(this.roles + ",");
        }
        sb.append("replicas:");
        sb.append(this.replicas + ",");
        if (this.labelSelector != null) {
            sb.append("labelSelector:");
            sb.append(this.labelSelector);
        }
        sb.append("}");
        return sb.toString();
    }
}

